/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline.discovery;

import dorkbox.network.Server;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.pipeline.discovery.BroadcastResponse;
import dorkbox.network.pipeline.discovery.ClientDiscoverHostHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastServer {
    private static final Logger logger = LoggerFactory.getLogger((String)Server.class.getSimpleName());
    private final int tcpPort;
    private final int udpPort;
    private final int bufferSize;

    public BroadcastServer() {
        this.bufferSize = 0;
        this.tcpPort = 0;
        this.udpPort = 0;
    }

    public BroadcastServer(int tcpPort, int udpPort) {
        this.tcpPort = tcpPort;
        this.udpPort = udpPort;
        this.bufferSize = tcpPort > 0 ^ udpPort > 0 ? 4 : 6;
    }

    public boolean isDiscoveryRequest(Channel channel, ByteBuf byteBuf, InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        if (byteBuf.readableBytes() == 1 && byteBuf.getByte(0) == 42) {
            byteBuf.readByte();
            ByteBuf directBuffer = channel.alloc().ioBuffer(this.bufferSize);
            directBuffer.writeByte(57);
            int enabledFlag = 0;
            if (this.tcpPort > 0) {
                enabledFlag |= 2;
            }
            if (this.udpPort > 0) {
                enabledFlag |= 4;
            }
            directBuffer.writeByte(enabledFlag);
            if (this.tcpPort > 0) {
                directBuffer.writeShort(this.tcpPort);
            }
            if (this.udpPort > 0) {
                directBuffer.writeShort(this.udpPort);
            }
            channel.writeAndFlush((Object)new DatagramPacket(directBuffer, remoteAddress, localAddress));
            logger.info("Responded to host discovery from [{}]", (Object)EndPoint.getHostDetails(remoteAddress));
            byteBuf.release();
            return true;
        }
        return false;
    }

    public static boolean isDiscoveryResponse(ByteBuf byteBuf, InetAddress remoteAddress, Channel channel) {
        if (byteBuf.readableBytes() <= 6 && byteBuf.getByte(0) == 57) {
            byteBuf.readByte();
            byte typeID = byteBuf.readByte();
            int tcpPort = 0;
            int udpPort = 0;
            if ((typeID & 2) == 2) {
                tcpPort = byteBuf.readUnsignedShort();
            }
            if ((typeID & 4) == 4) {
                udpPort = byteBuf.readUnsignedShort();
            }
            channel.attr(ClientDiscoverHostHandler.STATE).set((Object)new BroadcastResponse(remoteAddress, tcpPort, udpPort));
            byteBuf.release();
            return true;
        }
        return false;
    }
}

