/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline.udp;

import dorkbox.network.serialization.CryptoSerializationManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.IOException;
import java.util.List;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class KryoDecoderUdp
extends MessageToMessageDecoder<Object> {
    private final CryptoSerializationManager serializationManager;

    public KryoDecoderUdp(CryptoSerializationManager serializationManager) {
        this.serializationManager = serializationManager;
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof AddressedEnvelope;
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (!(event instanceof IdleStateEvent) || ((IdleStateEvent)event).state() == IdleState.ALL_IDLE) {
            // empty if block
        }
        super.userEventTriggered(context, event);
    }

    protected void decode(ChannelHandlerContext context, Object message, List<Object> out) throws Exception {
        ByteBuf data = (ByteBuf)((AddressedEnvelope)message).content();
        try {
            Object object = this.serializationManager.read(data, data.writerIndex());
            out.add(object);
        }
        catch (IOException e) {
            String msg = "Unable to deserialize object";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }
}

