/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline.udp;

import dorkbox.network.connection.CryptoConnection;
import dorkbox.network.serialization.CryptoSerializationManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.IOException;
import java.util.List;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class KryoDecoderUdpCrypto
extends MessageToMessageDecoder<DatagramPacket> {
    private final CryptoSerializationManager serializationManager;

    public KryoDecoderUdpCrypto(CryptoSerializationManager serializationManager) {
        this.serializationManager = serializationManager;
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (!(event instanceof IdleStateEvent) || ((IdleStateEvent)event).state() == IdleState.ALL_IDLE) {
            // empty if block
        }
        super.userEventTriggered(context, event);
    }

    public void decode(ChannelHandlerContext context, DatagramPacket in, List<Object> out) throws Exception {
        try {
            CryptoConnection last = (CryptoConnection)context.pipeline().last();
            ByteBuf data = (ByteBuf)in.content();
            Object object = this.serializationManager.readWithCrypto(last, data, data.readableBytes());
            out.add(object);
        }
        catch (IOException e) {
            String message = "Unable to deserialize object";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new IOException(message, e);
        }
    }
}

