/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline.udp;

import dorkbox.network.connection.EndPoint;
import dorkbox.network.serialization.CryptoSerializationManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class KryoEncoderUdp
extends MessageToMessageEncoder<Object> {
    private static final int maxSize = EndPoint.udpMaxSize;
    private final CryptoSerializationManager serializationManager;

    public KryoEncoderUdp(CryptoSerializationManager serializationManager) {
        this.serializationManager = serializationManager;
    }

    protected void encode(ChannelHandlerContext context, Object message, List<Object> out) throws Exception {
        if (message != null) {
            try {
                ByteBuf outBuffer = context.alloc().ioBuffer(maxSize);
                this.writeObject(this.serializationManager, context, message, outBuffer);
                if (outBuffer.readableBytes() > maxSize) {
                    String msg = "Object is TOO BIG FOR UDP! " + message.toString() + " (Max " + maxSize + ", was " + outBuffer.readableBytes() + ")";
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(msg);
                    throw new IOException(msg);
                }
                DatagramPacket packet = new DatagramPacket(outBuffer, (InetSocketAddress)context.channel().remoteAddress());
                out.add(packet);
            }
            catch (Exception e) {
                String msg = "Unable to serialize object of type: " + message.getClass().getName();
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(msg, (Throwable)e);
                throw new IOException(msg, e);
            }
        }
    }

    void writeObject(CryptoSerializationManager serializationManager, ChannelHandlerContext context, Object msg, ByteBuf buffer) throws IOException {
        serializationManager.write(buffer, msg);
    }
}

