/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.rmi.CachedMethod;
import dorkbox.network.rmi.InvokeMethod;

public class InvokeMethodSerializer
extends Serializer<InvokeMethod> {
    public void write(Kryo kryo, Output output, InvokeMethod object) {
        output.writeInt(object.objectID, true);
        output.writeInt(object.cachedMethod.methodClassID, true);
        output.writeByte(object.cachedMethod.methodIndex);
        Serializer[] serializers = object.cachedMethod.serializers;
        int length = serializers.length;
        Object[] args = object.args;
        for (int i = 0; i < length; ++i) {
            Serializer serializer = serializers[i];
            if (serializer != null) {
                kryo.writeObjectOrNull(output, args[i], serializer);
                continue;
            }
            kryo.writeClassAndObject(output, args[i]);
        }
        output.writeByte(object.responseData);
    }

    public InvokeMethod read(Kryo kryo, Input input, Class<InvokeMethod> type) {
        Object[] args;
        int argStartIndex;
        CachedMethod cachedMethod;
        int objectID = input.readInt(true);
        int methodClassID = input.readInt(true);
        byte methodIndex = input.readByte();
        try {
            cachedMethod = ((KryoExtra)kryo).getSerializationManager().getMethods(methodClassID)[methodIndex];
        }
        catch (Exception ex) {
            Class methodClass = kryo.getRegistration(methodClassID).getType();
            throw new KryoException("Invalid method index " + methodIndex + " for class: " + methodClass.getName());
        }
        Serializer[] serializers = cachedMethod.serializers;
        if (cachedMethod.overriddenMethod) {
            argStartIndex = 1;
            args = new Object[serializers.length + 1];
            args[0] = ((KryoExtra)kryo).connection;
        } else {
            argStartIndex = 0;
            args = new Object[serializers.length];
        }
        Class<?>[] parameterTypes = cachedMethod.method.getParameterTypes();
        int i = 0;
        int n = serializers.length;
        int j = argStartIndex;
        while (i < n) {
            Serializer serializer = serializers[i];
            args[j] = serializer != null ? kryo.readObjectOrNull(input, parameterTypes[i], serializer) : kryo.readClassAndObject(input);
            ++i;
            ++j;
        }
        InvokeMethod invokeMethod = new InvokeMethod();
        invokeMethod.objectID = objectID;
        invokeMethod.cachedMethod = cachedMethod;
        invokeMethod.args = args;
        invokeMethod.responseData = input.readByte();
        return invokeMethod;
    }
}

