/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.Listener;
import dorkbox.network.rmi.CachedMethod;
import dorkbox.network.rmi.InvokeMethod;
import dorkbox.network.rmi.InvokeMethodResult;
import dorkbox.util.Property;
import dorkbox.util.collections.LockFreeIntBiMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public final class RmiBridge {
    @Property
    public static boolean ENABLE_PROXY_OBJECTS = true;
    public static final int INVALID_RMI = Integer.MAX_VALUE;
    static final int returnValueMask = 128;
    static final int returnExceptionMask = 64;
    static final int responseIdMask = 63;
    private static final int INVALID_MAP_ID = -1;
    private final Logger logger;
    private final Executor executor;
    private final AtomicInteger rmiObjectIdCounter;
    private final LockFreeIntBiMap<Object> objectMap = new LockFreeIntBiMap(-1);
    private final Listener.OnMessageReceived<ConnectionImpl, InvokeMethod> invokeListener = new Listener.OnMessageReceived<ConnectionImpl, InvokeMethod>(){

        @Override
        public void received(final ConnectionImpl connection, final InvokeMethod invokeMethod) {
            int objectID = invokeMethod.objectID;
            final Object target = connection.getImplementationObject(objectID);
            if (target == null) {
                Logger logger2 = RmiBridge.this.logger;
                if (logger2.isWarnEnabled()) {
                    logger2.warn("Ignoring remote invocation request for unknown object ID: {}", (Object)objectID);
                }
                return;
            }
            Executor executor2 = RmiBridge.this.executor;
            if (executor2 == null) {
                try {
                    RmiBridge.this.invoke(connection, target, invokeMethod);
                }
                catch (IOException e) {
                    RmiBridge.this.logger.error("Unable to invoke method.", (Throwable)e);
                }
            } else {
                executor2.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RmiBridge.this.invoke(connection, target, invokeMethod);
                        }
                        catch (IOException e) {
                            RmiBridge.this.logger.error("Unable to invoke method.", (Throwable)e);
                        }
                    }
                });
            }
        }
    };

    public static boolean isGlobal(int objectId) {
        return (objectId & 1) == 0;
    }

    public RmiBridge(Logger logger, Executor executor, boolean isGlobal) {
        this.logger = logger;
        this.executor = executor;
        this.rmiObjectIdCounter = isGlobal ? new AtomicInteger(0) : new AtomicInteger(1);
    }

    public Listener.OnMessageReceived<ConnectionImpl, InvokeMethod> getListener() {
        return this.invokeListener;
    }

    protected void invoke(Connection connection, Object target, InvokeMethod invokeMethod) throws IOException {
        Object result;
        byte responseData;
        CachedMethod cachedMethod = invokeMethod.cachedMethod;
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            String argString = "";
            if (invokeMethod.args != null) {
                argString = Arrays.deepToString(invokeMethod.args);
                argString = argString.substring(1, argString.length() - 1);
            }
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(connection.toString()).append(" received: ").append(target.getClass().getSimpleName());
            stringBuilder.append(":").append(invokeMethod.objectID);
            stringBuilder.append("#").append(cachedMethod.method.getName());
            stringBuilder.append("(").append(argString).append(")");
            if (cachedMethod.overriddenMethod) {
                stringBuilder.append(" [Connection method override]");
            }
            logger2.trace(stringBuilder.toString());
        }
        boolean transmitReturnVal = ((responseData = invokeMethod.responseData) & 0x80) == 128;
        boolean transmitExceptions = (responseData & 0x40) == 64;
        int responseID = responseData & 0x3F;
        try {
            result = cachedMethod.invoke(connection, target, invokeMethod.args);
        }
        catch (Exception ex) {
            if (transmitExceptions) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                } else {
                    cause.initCause(null);
                }
                result = cause;
            }
            String message = "Error invoking method: " + cachedMethod.method.getDeclaringClass().getName() + "." + cachedMethod.method.getName();
            this.logger.error(message, (Throwable)ex);
            throw new IOException(message, ex);
        }
        if (responseID == 0) {
            return;
        }
        InvokeMethodResult invokeMethodResult = new InvokeMethodResult();
        invokeMethodResult.objectID = invokeMethod.objectID;
        invokeMethodResult.responseID = (byte)responseID;
        invokeMethodResult.result = !transmitReturnVal && !invokeMethod.cachedMethod.method.getReturnType().isPrimitive() ? null : result;
        connection.send(invokeMethodResult).flush();
    }

    private int nextObjectId() {
        int value = this.rmiObjectIdCounter.getAndAdd(2);
        if (value >= Integer.MAX_VALUE) {
            this.rmiObjectIdCounter.set(Integer.MAX_VALUE);
            this.logger.error("next RMI value '{}' has exceeded maximum limit '{}' in RmiBridge! Not creating RMI object.", (Object)value, (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
        return value;
    }

    public int register(Object object) {
        if (object == null) {
            return Integer.MAX_VALUE;
        }
        int nextObjectId = this.nextObjectId();
        if (nextObjectId != Integer.MAX_VALUE) {
            this.objectMap.put(nextObjectId, object);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Object <proxy #{}> registered with ObjectSpace with .toString() = '{}'", (Object)nextObjectId, object);
            }
        }
        return nextObjectId;
    }

    public void register(int objectID, Object object) {
        if (objectID < 0) {
            throw new IllegalArgumentException("objectID cannot be 2147483647");
        }
        if (objectID >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("objectID cannot be 2147483647");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.objectMap.put(objectID, object);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Object <proxy #{}> registered with ObjectSpace with .toString() = '{}'", (Object)objectID, object);
        }
    }

    public void remove(int objectID) {
        Object object = this.objectMap.remove(objectID);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Object <proxy #{}> removed from ObjectSpace with .toString() = '{}'", (Object)objectID, object);
        }
    }

    public void remove(Object object) {
        int objectID = this.objectMap.inverse().remove(object);
        if (objectID == -1) {
            this.logger.error("Object {} could not be found in the ObjectSpace.", object);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("Object {} (ID: {}) removed from ObjectSpace.", object, (Object)objectID);
        }
    }

    public Object getRegisteredObject(int objectID) {
        if (objectID < 0 || objectID >= Integer.MAX_VALUE) {
            return null;
        }
        return this.objectMap.get(objectID);
    }

    public <T> int getRegisteredId(T object) {
        int i = this.objectMap.inverse().get(object);
        if (i == -1) {
            return Integer.MAX_VALUE;
        }
        return i;
    }
}

