/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.util.IdentityMap;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.connection.Listener;
import dorkbox.network.rmi.CachedMethod;
import dorkbox.network.rmi.InvokeMethod;
import dorkbox.network.rmi.RemoteObject;
import dorkbox.network.rmi.RmiBridge;
import dorkbox.network.rmi.RmiObjectHandler;
import dorkbox.network.rmi.RmiProxyHandler;
import dorkbox.network.rmi.RmiRegistration;
import dorkbox.network.serialization.CryptoSerializationManager;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;

public class RmiObjectLocalHandler
extends RmiObjectHandler {
    private static final boolean ENABLE_PROXY_OBJECTS = RmiBridge.ENABLE_PROXY_OBJECTS;
    private static final Field[] NO_REMOTE_FIELDS = new Field[0];
    private static final AtomicReferenceFieldUpdater<RmiObjectLocalHandler, IdentityMap> implToProxyREF = AtomicReferenceFieldUpdater.newUpdater(RmiObjectLocalHandler.class, IdentityMap.class, "implToProxy");
    private static final AtomicReferenceFieldUpdater<RmiObjectLocalHandler, IdentityMap> remoteObjectREF = AtomicReferenceFieldUpdater.newUpdater(RmiObjectLocalHandler.class, IdentityMap.class, "objectHasRemoteObjects");
    private volatile IdentityMap<Object, Object> implToProxy = new IdentityMap();
    private volatile IdentityMap<Object, Field[]> objectHasRemoteObjects = new IdentityMap();
    private final Logger logger;

    public RmiObjectLocalHandler(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ConnectionImpl connection, InvokeMethod invokeMethod, Listener.OnMessageReceived<ConnectionImpl, InvokeMethod> rmiInvokeListener) {
        Object[] args;
        int argStartIndex;
        CachedMethod cachedMethod;
        int methodClassID = invokeMethod.cachedMethod.methodClassID;
        int methodIndex = invokeMethod.cachedMethod.methodIndex;
        CryptoSerializationManager serialization = connection.getEndPoint().getSerialization();
        try {
            cachedMethod = serialization.getMethods(methodClassID)[methodIndex];
        }
        catch (Exception ex) {
            String errorMessage;
            KryoExtra kryo = null;
            try {
                kryo = serialization.takeKryo();
                Class methodClass = kryo.getRegistration(methodClassID).getType();
                errorMessage = "Invalid method index " + methodIndex + " for class: " + methodClass.getName();
            }
            finally {
                serialization.returnKryo(kryo);
            }
            throw new KryoException(errorMessage);
        }
        Serializer[] serializers = cachedMethod.serializers;
        if (cachedMethod.overriddenMethod) {
            argStartIndex = 1;
            args = new Object[serializers.length + 1];
            args[0] = connection;
        } else {
            argStartIndex = 0;
            args = new Object[serializers.length];
        }
        int i = 0;
        int n = serializers.length;
        int j = argStartIndex;
        while (i < n) {
            args[j] = invokeMethod.args[i];
            ++i;
            ++j;
        }
        invokeMethod.cachedMethod = cachedMethod;
        invokeMethod.args = args;
        rmiInvokeListener.received(connection, invokeMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registration(ConnectionImpl connection, RmiRegistration registration) {
        Class<?> interfaceClass = registration.interfaceClass;
        int callbackId = registration.callbackId;
        if (registration.isRequest) {
            if (registration.rmiId == Integer.MAX_VALUE) {
                EndPoint endPoint = connection.getEndPoint();
                CryptoSerializationManager serialization = endPoint.getSerialization();
                Class<?> rmiImpl = serialization.getRmiImpl(registration.interfaceClass);
                RmiRegistration registrationResult = connection.createNewRmiObject(interfaceClass, rmiImpl, callbackId);
                connection.send(registrationResult);
            } else {
                RmiRegistration registrationResult = connection.getExistingRmiObject(interfaceClass, registration.rmiId, callbackId);
                connection.send(registrationResult);
            }
        } else if (ENABLE_PROXY_OBJECTS) {
            RemoteObject proxyObject = null;
            if (registration.rmiId == Integer.MAX_VALUE) {
                this.logger.error("RMI ID '{}' is invalid. Unable to create RMI object.", (Object)registration.rmiId);
            } else {
                proxyObject = connection.getProxyObject(registration.rmiId, interfaceClass);
                if (proxyObject != null) {
                    IdentityMap<Object, Object> identityMap = this.implToProxy;
                    synchronized (identityMap) {
                        this.implToProxy.put(registration.remoteObject, (Object)proxyObject);
                    }
                }
            }
            connection.runRmiCallback(interfaceClass, callbackId, proxyObject);
        } else {
            connection.runRmiCallback(interfaceClass, callbackId, registration.remoteObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object normalMessages(ConnectionImpl connection, Object message) {
        IdentityMap implToProxy = implToProxyREF.get(this);
        IdentityMap objectHasRemoteObjects = remoteObjectREF.get(this);
        Object proxy = implToProxy.get(message);
        if (proxy != null) {
            return proxy;
        }
        Class<?> messageClass = message.getClass();
        Field[] remoteObjectFields = (Field[])objectHasRemoteObjects.get(messageClass);
        if (remoteObjectFields == null) {
            ArrayList<Field> fields = new ArrayList<Field>();
            while (messageClass != Object.class) {
                for (Field field : messageClass.getDeclaredFields()) {
                    Class<?> type = field.getType();
                    if (!type.isInterface()) continue;
                    boolean prev = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        Object o = field.get(message);
                        if (o instanceof RemoteObject) {
                            RmiProxyHandler handler = (RmiProxyHandler)Proxy.getInvocationHandler(o);
                            int id = handler.objectID;
                            field.set(message, connection.getImplementationObject(id));
                            fields.add(field);
                            continue;
                        }
                        proxy = implToProxy.get(o);
                        if (proxy == null) continue;
                        field.set(message, proxy);
                        fields.add(field);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    finally {
                        field.setAccessible(prev);
                    }
                }
                messageClass = messageClass.getSuperclass();
            }
            Field[] array = fields.isEmpty() ? NO_REMOTE_FIELDS : fields.toArray(new Field[fields.size()]);
            IdentityMap<Object, Field[]> identityMap = this.objectHasRemoteObjects;
            synchronized (identityMap) {
                this.objectHasRemoteObjects.put(messageClass, (Object)array);
            }
        } else if (remoteObjectFields != NO_REMOTE_FIELDS) {
            for (Field field : remoteObjectFields) {
                boolean prev = field.isAccessible();
                try {
                    field.setAccessible(true);
                    Object o = field.get(message);
                    if (o instanceof RemoteObject) {
                        RmiProxyHandler handler = (RmiProxyHandler)Proxy.getInvocationHandler(o);
                        int id = handler.objectID;
                        field.set(message, connection.getImplementationObject(id));
                        continue;
                    }
                    proxy = implToProxy.get(o);
                    if (proxy == null) continue;
                    field.set(message, proxy);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                finally {
                    field.setAccessible(prev);
                }
            }
        }
        return message;
    }
}

