/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.Listener;
import dorkbox.network.rmi.InvokeMethod;
import dorkbox.network.rmi.RmiObjectHandler;
import dorkbox.network.rmi.RmiRegistration;
import org.slf4j.Logger;

public class RmiObjectNetworkHandler
extends RmiObjectHandler {
    private final Logger logger;

    public RmiObjectNetworkHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void invoke(ConnectionImpl connection, InvokeMethod message, Listener.OnMessageReceived<ConnectionImpl, InvokeMethod> rmiInvokeListener) {
        rmiInvokeListener.received(connection, message);
    }

    @Override
    public void registration(ConnectionImpl connection, RmiRegistration registration) {
        Class<?> interfaceClass = registration.interfaceClass;
        int callbackId = registration.callbackId;
        if (registration.isRequest) {
            if (registration.rmiId == Integer.MAX_VALUE) {
                RmiRegistration registrationResult = connection.createNewRmiObject(interfaceClass, interfaceClass, callbackId);
                connection.send(registrationResult);
            } else {
                RmiRegistration registrationResult = connection.getExistingRmiObject(interfaceClass, registration.rmiId, callbackId);
                connection.send(registrationResult);
            }
        } else {
            if (registration.rmiId == Integer.MAX_VALUE) {
                this.logger.error("RMI ID '{}' is invalid. Unable to create RMI object.", (Object)registration.rmiId);
            }
            connection.runRmiCallback(interfaceClass, callbackId, registration.remoteObject);
        }
    }
}

