/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.connection.Listener;
import dorkbox.network.rmi.CachedMethod;
import dorkbox.network.rmi.InvokeMethod;
import dorkbox.network.rmi.InvokeMethodResult;
import dorkbox.network.rmi.RemoteObject;
import dorkbox.network.rmi.TimeoutException;
import dorkbox.network.serialization.CryptoSerializationManager;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiProxyHandler
implements InvocationHandler {
    private final Logger logger;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition responseCondition = this.lock.newCondition();
    private final InvokeMethodResult[] responseTable = new InvokeMethodResult[64];
    private final boolean[] pendingResponses = new boolean[64];
    private final ConnectionImpl connection;
    public final int objectID;
    public final int ID;
    private final String proxyString;
    private final Listener.OnMessageReceived<Connection, InvokeMethodResult> responseListener;
    private int timeoutMillis = 3000;
    private boolean isAsync = false;
    private boolean transmitReturnValue = false;
    private boolean transmitExceptions = false;
    private boolean enableToString;
    private boolean udp;
    private Byte lastResponseID;
    private byte nextResponseId = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiProxyHandler(ConnectionImpl connection, final int objectID, Class<?> iFace) {
        this.connection = connection;
        this.objectID = objectID;
        this.proxyString = "<proxy #" + objectID + ">";
        EndPoint endPointConnection = this.connection.getEndPoint();
        CryptoSerializationManager serializationManager = endPointConnection.getSerialization();
        KryoExtra kryoExtra = null;
        try {
            kryoExtra = serializationManager.takeKryo();
            this.ID = kryoExtra.getRegistration(iFace).getId();
        }
        finally {
            if (kryoExtra != null) {
                serializationManager.returnKryo(kryoExtra);
            }
        }
        this.logger = LoggerFactory.getLogger((String)(connection.getEndPoint().getName() + ":" + this.getClass().getSimpleName()));
        this.responseListener = new Listener.OnMessageReceived<Connection, InvokeMethodResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void received(Connection connection, InvokeMethodResult invokeMethodResult) {
                byte responseID = invokeMethodResult.responseID;
                if (invokeMethodResult.objectID != objectID) {
                    return;
                }
                1 var4_4 = this;
                synchronized (var4_4) {
                    if (RmiProxyHandler.this.pendingResponses[responseID]) {
                        ((RmiProxyHandler)RmiProxyHandler.this).responseTable[responseID] = invokeMethodResult;
                    }
                }
                RmiProxyHandler.this.lock.lock();
                try {
                    RmiProxyHandler.this.responseCondition.signalAll();
                }
                finally {
                    RmiProxyHandler.this.lock.unlock();
                }
            }
        };
    }

    public Listener.OnMessageReceived<Connection, InvokeMethodResult> getListener() {
        return this.responseListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        boolean respondImmediately;
        boolean ignoreResponse;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == RemoteObject.class) {
            String name = method.getName();
            if (name.equals("close")) {
                this.connection.removeRmiListeners(this.objectID, this.getListener());
                return null;
            }
            if (name.equals("setResponseTimeout")) {
                this.timeoutMillis = (Integer)args[0];
                return null;
            }
            if (name.equals("getResponseTimeout")) {
                return this.timeoutMillis;
            }
            if (name.equals("setAsync")) {
                this.isAsync = (Boolean)args[0];
                return null;
            }
            if (name.equals("setTransmitReturnValue")) {
                this.transmitReturnValue = (Boolean)args[0];
                return null;
            }
            if (name.equals("setTransmitExceptions")) {
                this.transmitExceptions = (Boolean)args[0];
                return null;
            }
            if (name.equals("setTCP")) {
                this.udp = false;
                return null;
            }
            if (name.equals("setUDP")) {
                this.udp = true;
                return null;
            }
            if (name.equals("enableToString")) {
                this.enableToString = (Boolean)args[0];
                return null;
            }
            if (name.equals("waitForLastResponse")) {
                if (this.lastResponseID == null) {
                    throw new IllegalStateException("There is no last response to wait for.");
                }
                return this.waitForResponse(this.lastResponseID);
            }
            if (name.equals("getLastResponseID")) {
                if (this.lastResponseID == null) {
                    throw new IllegalStateException("There is no last response ID.");
                }
                return this.lastResponseID;
            }
            if (name.equals("waitForResponse")) {
                if (!this.transmitReturnValue && !this.transmitExceptions && this.isAsync) {
                    throw new IllegalStateException("This RemoteObject is currently set to ignore all responses.");
                }
                return this.waitForResponse((Byte)args[0]);
            }
            throw new Exception("Invocation handler could not find RemoteObject method for " + name);
        }
        if (!this.enableToString && declaringClass == Object.class && method.getName().equals("toString")) {
            return this.proxyString;
        }
        InvokeMethod invokeMethod = new InvokeMethod();
        invokeMethod.objectID = this.objectID;
        invokeMethod.args = args;
        for (CachedMethod cachedMethod : this.connection.getEndPoint().getSerialization().getMethods(this.ID)) {
            Method checkMethod = cachedMethod.method;
            if (!checkMethod.equals(method)) continue;
            invokeMethod.cachedMethod = cachedMethod;
            break;
        }
        if (invokeMethod.cachedMethod == null) {
            String msg = "Method not found: " + method;
            this.logger.error(msg);
            return msg;
        }
        byte responseID = 0;
        Class<?> returnType = method.getReturnType();
        boolean shouldReturnValue = returnType != Void.TYPE || this.transmitReturnValue;
        boolean shouldTransmitExceptions = method.getExceptionTypes().length != 0 || method.getGenericExceptionTypes().length != 0 || this.transmitExceptions;
        boolean bl = ignoreResponse = (this.isAsync || returnType == Void.TYPE) && !shouldReturnValue && !shouldTransmitExceptions;
        if (ignoreResponse) {
            invokeMethod.responseData = 0;
        } else {
            RmiProxyHandler rmiProxyHandler = this;
            synchronized (rmiProxyHandler) {
                byte by = this.nextResponseId;
                this.nextResponseId = (byte)(by + 1);
                responseID = by;
                if (this.nextResponseId > 63) {
                    this.nextResponseId = 1;
                }
                this.pendingResponses[responseID] = true;
            }
            byte responseData = responseID;
            if (shouldReturnValue) {
                responseData = (byte)(responseData | 0xFFFFFF80);
            }
            if (shouldTransmitExceptions) {
                responseData = (byte)(responseData | 0x40);
            }
            invokeMethod.responseData = responseData;
        }
        byte lastResponseID = (byte)(invokeMethod.responseData & 0x3F);
        this.lastResponseID = lastResponseID;
        if (this.udp) {
            this.connection.UDP(invokeMethod).flush();
        } else {
            this.connection.send(invokeMethod).flush();
        }
        if (this.logger.isTraceEnabled()) {
            String argString = "";
            if (args != null) {
                argString = Arrays.deepToString(args);
                argString = argString.substring(1, argString.length() - 1);
            }
            this.logger.trace(this.connection + " sent: " + method.getDeclaringClass().getSimpleName() + "#" + method.getName() + "(" + argString + ")");
        }
        boolean bl2 = respondImmediately = this.isAsync || returnType == Void.TYPE && !shouldReturnValue && !shouldTransmitExceptions;
        if (respondImmediately) {
            if (returnType.isPrimitive()) {
                if (returnType == Integer.TYPE) {
                    return 0;
                }
                if (returnType == Boolean.TYPE) {
                    return Boolean.FALSE;
                }
                if (returnType == Float.TYPE) {
                    return Float.valueOf(0.0f);
                }
                if (returnType == Character.TYPE) {
                    return Character.valueOf('\u0000');
                }
                if (returnType == Long.TYPE) {
                    return 0L;
                }
                if (returnType == Short.TYPE) {
                    return (short)0;
                }
                if (returnType == Byte.TYPE) {
                    return (byte)0;
                }
                if (returnType == Double.TYPE) {
                    return 0.0;
                }
            }
            return null;
        }
        try {
            Object result = this.waitForResponse(lastResponseID);
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            Object object = result;
            return object;
        }
        catch (TimeoutException ex) {
            throw new TimeoutException("Response timed out: " + method.getDeclaringClass().getName() + "." + method.getName());
        }
        finally {
            RmiProxyHandler rmiProxyHandler = this;
            synchronized (rmiProxyHandler) {
                this.pendingResponses[responseID] = false;
                this.responseTable[responseID] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object waitForResponse(byte responseID) throws IOException {
        long endTime;
        long remaining;
        if (this.timeoutMillis != 0) {
            remaining = this.timeoutMillis;
            endTime = System.currentTimeMillis() + remaining;
        } else {
            remaining = Long.MAX_VALUE;
            endTime = Long.MAX_VALUE;
        }
        while (remaining > 0L) {
            InvokeMethodResult invokeMethodResult;
            RmiProxyHandler rmiProxyHandler = this;
            synchronized (rmiProxyHandler) {
                invokeMethodResult = this.responseTable[responseID];
            }
            if (invokeMethodResult != null) {
                this.lastResponseID = null;
                return invokeMethodResult.result;
            }
            this.lock.lock();
            try {
                this.responseCondition.await(remaining, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Response timed out.", e);
            }
            finally {
                this.lock.unlock();
            }
            remaining = endTime - System.currentTimeMillis();
        }
        throw new TimeoutException("Response timed out.");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.objectID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RmiProxyHandler other = (RmiProxyHandler)obj;
        return this.objectID == other.objectID;
    }
}

