/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.reflectasm.MethodAccess;
import dorkbox.network.connection.Connection;
import dorkbox.network.rmi.AsmCachedMethod;
import dorkbox.network.rmi.CachedMethod;
import dorkbox.util.generics.ClassHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.slf4j.Logger;

public class RmiUtils {
    private static final Comparator<Method> METHOD_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            Class<?>[] argTypes2;
            String o2Name;
            String o1Name = o1.getName();
            int diff = o1Name.compareTo(o2Name = o2.getName());
            if (diff != 0) {
                return diff;
            }
            Class<?>[] argTypes1 = o1.getParameterTypes();
            if (argTypes1.length > (argTypes2 = o2.getParameterTypes()).length) {
                return 1;
            }
            if (argTypes1.length < argTypes2.length) {
                return -1;
            }
            for (int i = 0; i < argTypes1.length; ++i) {
                diff = argTypes1[i].getName().compareTo(argTypes2[i].getName());
                if (diff == 0) continue;
                return diff;
            }
            throw new RuntimeException("Two methods with same signature! ('" + o1Name + "', '" + o2Name + "'");
        }
    };

    private static MethodAccess getReflectAsmMethod(Logger logger, Class<?> clazz) {
        try {
            MethodAccess methodAccess = MethodAccess.get(clazz);
            if (methodAccess.getMethodNames().length == 0 && methodAccess.getParameterTypes().length == 0 && methodAccess.getReturnTypes().length == 0) {
                return null;
            }
            return methodAccess;
        }
        catch (Exception e) {
            logger.error("Unable to create ReflectASM method access", (Throwable)e);
            return null;
        }
    }

    public static CachedMethod[] getCachedMethods(Logger logger, Kryo kryo, boolean asmEnabled, Class<?> iFace, Class<?> impl, int classId) {
        MethodAccess ifaceMethodAccess = null;
        MethodAccess implMethodAccess = null;
        Method[] methods = RmiUtils.getMethods(iFace);
        int size = methods.length;
        CachedMethod[] cachedMethods = new CachedMethod[size];
        if (impl != null) {
            if (impl.isInterface()) {
                throw new IllegalArgumentException("Cannot have type as an interface, it must be an implementation");
            }
            Method[] implMethods = RmiUtils.getMethods(impl);
            RmiUtils.overwriteMethodsWithConnectionParam(implMethods, methods);
            if (asmEnabled) {
                implMethodAccess = RmiUtils.getReflectAsmMethod(logger, impl);
            }
        }
        if (asmEnabled) {
            ifaceMethodAccess = RmiUtils.getReflectAsmMethod(logger, iFace);
        }
        for (int i = 0; i < size; ++i) {
            Method method = methods[i];
            Class<?> declaringClass = method.getDeclaringClass();
            Class[] parameterTypes = method.getParameterTypes();
            boolean overriddenMethod = false;
            MethodAccess tweakMethodAccess = ifaceMethodAccess;
            if (declaringClass.equals(impl)) {
                tweakMethodAccess = implMethodAccess;
                overriddenMethod = true;
                if (logger.isTraceEnabled()) {
                    logger.trace("Overridden method: {}.{}", impl, (Object)method.getName());
                }
            }
            CachedMethod cachedMethod = null;
            if (tweakMethodAccess != null && method.getDeclaringClass() != Object.class) {
                try {
                    int index = tweakMethodAccess.getIndex(method.getName(), parameterTypes);
                    AsmCachedMethod asmCachedMethod = new AsmCachedMethod();
                    asmCachedMethod.methodAccessIndex = index;
                    asmCachedMethod.methodAccess = tweakMethodAccess;
                    asmCachedMethod.name = method.getName();
                    if (overriddenMethod) {
                        int length = parameterTypes.length;
                        if (length == 1) {
                            parameterTypes = new Class[]{};
                        } else {
                            Class[] newArgs = new Class[--length];
                            System.arraycopy(parameterTypes, 1, newArgs, 0, length);
                            parameterTypes = newArgs;
                        }
                    }
                    cachedMethod = asmCachedMethod;
                }
                catch (Exception e) {
                    logger.trace("Unable to use ReflectAsm for {}.{} (using java reflection instead)", new Object[]{declaringClass, method.getName(), e});
                }
            }
            if (cachedMethod == null) {
                cachedMethod = new CachedMethod();
            }
            cachedMethod.overriddenMethod = overriddenMethod;
            cachedMethod.methodClassID = classId;
            cachedMethod.method = method;
            cachedMethod.methodIndex = i;
            cachedMethod.serializers = new Serializer[parameterTypes.length];
            int nn = parameterTypes.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (!kryo.isFinal(parameterTypes[ii])) continue;
                cachedMethod.serializers[ii] = kryo.getSerializer(parameterTypes[ii]);
            }
            cachedMethods[i] = cachedMethod;
        }
        return cachedMethods;
    }

    private static void overwriteMethodsWithConnectionParam(Method[] implMethods, Method[] origMethods) {
        block0: for (Method origMethod : origMethods) {
            String origName = origMethod.getName();
            Class<?>[] origTypes = origMethod.getParameterTypes();
            int origLength = origTypes.length + 1;
            for (Method implMethod : implMethods) {
                Class<?> shouldBeConnectionType;
                String implName = implMethod.getName();
                Class<?>[] implTypes = implMethod.getParameterTypes();
                int implLength = implTypes.length;
                if (origLength != implLength || !origName.equals(implName) || !ClassHelper.hasInterface(Connection.class, shouldBeConnectionType = implTypes[0])) continue;
                if (implLength == 1) {
                    origMethods[i] = implMethod;
                    continue block0;
                }
                boolean found = true;
                for (int k = 1; k < implLength; ++k) {
                    if (origTypes[k - 1] == implTypes[k]) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                origMethods[i] = implMethod;
                continue block0;
            }
        }
    }

    private static Method[] getMethods(Class<?> type) {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        HashMap<String, ArrayList<Object[]>> accessibleMethods = new HashMap<String, ArrayList<Object[]>>();
        LinkedList classes = new LinkedList();
        classes.add(type);
        classes.add(Object.class);
        while (!classes.isEmpty()) {
            Class nextClass = (Class)classes.removeFirst();
            Method[] methods = nextClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || method.isSynthetic()) continue;
                String name = method.getName();
                Object[] types = method.getParameterTypes();
                ArrayList<Object[]> existingTypes = (ArrayList<Object[]>)accessibleMethods.get(name);
                if (existingTypes != null) {
                    boolean found = false;
                    for (Object[] existingType : existingTypes) {
                        if (!Arrays.equals(types, existingType)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                if (existingTypes == null) {
                    existingTypes = new ArrayList<Object[]>();
                }
                existingTypes.add(types);
                accessibleMethods.put(name, existingTypes);
                allMethods.add(method);
            }
            classes.addAll(Arrays.asList(nextClass.getInterfaces()));
            Class superclass = nextClass.getSuperclass();
            if (superclass == null) continue;
            classes.add(superclass);
        }
        accessibleMethods.clear();
        Collections.sort(allMethods, METHOD_COMPARATOR);
        Method[] methodsArray = new Method[allMethods.size()];
        allMethods.toArray(methodsArray);
        return methodsArray;
    }
}

