/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.serialization;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.SerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.util.IdentityMap;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryo.util.Util;
import dorkbox.network.connection.CryptoConnection;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.connection.ping.PingMessage;
import dorkbox.network.connection.registration.Registration;
import dorkbox.network.rmi.CachedMethod;
import dorkbox.network.rmi.InvocationHandlerSerializer;
import dorkbox.network.rmi.InvocationResultSerializer;
import dorkbox.network.rmi.InvokeMethod;
import dorkbox.network.rmi.InvokeMethodResult;
import dorkbox.network.rmi.InvokeMethodSerializer;
import dorkbox.network.rmi.RemoteObjectSerializer;
import dorkbox.network.rmi.RmiRegistration;
import dorkbox.network.rmi.RmiUtils;
import dorkbox.network.serialization.CryptoSerializationManager;
import dorkbox.network.serialization.RmiSerializationManager;
import dorkbox.objectPool.ObjectPool;
import dorkbox.objectPool.PoolableObject;
import dorkbox.util.Property;
import dorkbox.util.serialization.ArraysAsListSerializer;
import dorkbox.util.serialization.EccPrivateKeySerializer;
import dorkbox.util.serialization.EccPublicKeySerializer;
import dorkbox.util.serialization.IesParametersSerializer;
import dorkbox.util.serialization.IesWithCipherParametersSerializer;
import dorkbox.util.serialization.UnmodifiableCollectionsSerializer;
import io.netty.bootstrap.DatagramCloseMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serialization<C extends CryptoConnection>
implements CryptoSerializationManager<C>,
RmiSerializationManager {
    private static final Logger logger = LoggerFactory.getLogger((String)Serialization.class.getSimpleName());
    @Property
    public static boolean useUnsafeMemory = false;
    private boolean initialized = false;
    private final ObjectPool<KryoExtra<C>> kryoPool;
    private final boolean forbidInterfaceRegistration;
    private final List<Object> classesToRegister = new ArrayList<Object>();
    private boolean usesRmi = false;
    private InvokeMethodSerializer methodSerializer = null;
    private Serializer<Object> invocationSerializer = null;
    private IntMap<CachedMethod[]> methodCache;
    private RemoteObjectSerializer remoteObjectSerializer;
    private final IntMap<Class<?>> rmiKryoIdToImpl = new IntMap();
    private final IntMap<Class<?>> rmiKryoIdToIface = new IntMap();
    private final IdentityMap<Class<?>, Class<?>> rmiIfaceToImpl = new IdentityMap();
    private final IdentityMap<Class<?>, Class<?>> rmiImplToIface = new IdentityMap();
    private final boolean useAsm = !useUnsafeMemory && !Util.IS_ANDROID;
    private Logger wireReadLogger;
    private Logger wireWriteLogger;

    public static Serialization DEFAULT() {
        return Serialization.DEFAULT(true, true, true, null);
    }

    public static <C extends CryptoConnection> Serialization<C> DEFAULT(boolean references, boolean registrationRequired, boolean implementationRequired, SerializerFactory factory) {
        Serialization<C> serialization = new Serialization<C>(references, registrationRequired, implementationRequired, factory);
        serialization.register((Class)PingMessage.class);
        serialization.register((Class)DatagramCloseMessage.class);
        serialization.register((Class)byte[].class);
        serialization.register((Class)IESParameters.class, new IesParametersSerializer());
        serialization.register((Class)IESWithCipherParameters.class, new IesWithCipherParametersSerializer());
        serialization.register((Class)ECPublicKeyParameters.class, new EccPublicKeySerializer());
        serialization.register((Class)ECPrivateKeyParameters.class, new EccPrivateKeySerializer());
        serialization.register((Class)Registration.class);
        serialization.register((Class)ArrayList.class, (Serializer)new CollectionSerializer());
        serialization.register((Class)StackTraceElement.class);
        serialization.register((Class)StackTraceElement[].class);
        serialization.register((Class)Arrays.asList("").getClass(), new ArraysAsListSerializer());
        UnmodifiableCollectionsSerializer.registerSerializers(serialization);
        return serialization;
    }

    public static Serializer resolveSerializerInstance(Kryo k, Class superClass, Class<? extends Serializer> serializerClass) {
        try {
            try {
                return serializerClass.getConstructor(Kryo.class, Class.class).newInstance(k, superClass);
            }
            catch (NoSuchMethodException ex1) {
                try {
                    return serializerClass.getConstructor(Kryo.class).newInstance(k);
                }
                catch (NoSuchMethodException ex2) {
                    try {
                        return serializerClass.getConstructor(Class.class).newInstance(superClass);
                    }
                    catch (NoSuchMethodException ex3) {
                        return serializerClass.newInstance();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + superClass.getName(), ex);
        }
    }

    public Serialization(final boolean references, final boolean registrationRequired, boolean implementationRequired, final SerializerFactory factory) {
        this.forbidInterfaceRegistration = implementationRequired;
        this.kryoPool = ObjectPool.NonBlockingSoftReference((PoolableObject)new PoolableObject<KryoExtra<C>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public KryoExtra<C> create() {
                Serialization serialization = Serialization.this;
                synchronized (serialization) {
                    KryoExtra kryo = new KryoExtra(Serialization.this);
                    kryo.getFieldSerializerConfig().setUseAsm(Serialization.this.useAsm);
                    kryo.setRegistrationRequired(registrationRequired);
                    kryo.setReferences(references);
                    if (Serialization.this.usesRmi) {
                        kryo.register(Class.class);
                        kryo.register(RmiRegistration.class);
                        kryo.register(InvokeMethod.class, Serialization.this.methodSerializer);
                        kryo.register(Object[].class);
                        InvocationResultSerializer resultSerializer = new InvocationResultSerializer(kryo);
                        resultSerializer.removeField("objectID");
                        kryo.register(InvokeMethodResult.class, (Serializer)resultSerializer);
                        kryo.register(InvocationHandler.class, Serialization.this.invocationSerializer);
                    }
                    for (Object clazz : Serialization.this.classesToRegister) {
                        Object classSerializer;
                        if (clazz instanceof Class) {
                            Class aClass = (Class)clazz;
                            kryo.register(aClass);
                            continue;
                        }
                        if (clazz instanceof ClassSerializer) {
                            classSerializer = (ClassSerializer)clazz;
                            kryo.register(((ClassSerializer)classSerializer).clazz, ((ClassSerializer)classSerializer).serializer);
                            continue;
                        }
                        if (clazz instanceof ClassSerializer1) {
                            classSerializer = (ClassSerializer1)clazz;
                            kryo.register(((ClassSerializer1)classSerializer).clazz, ((ClassSerializer1)classSerializer).id);
                            continue;
                        }
                        if (clazz instanceof ClassSerializer2) {
                            classSerializer = (ClassSerializer2)clazz;
                            kryo.register(((ClassSerializer2)classSerializer).clazz, ((ClassSerializer2)classSerializer).serializer, ((ClassSerializer2)classSerializer).id);
                            continue;
                        }
                        if (clazz instanceof RemoteIfaceClass) {
                            RemoteIfaceClass remoteIfaceClass = (RemoteIfaceClass)clazz;
                            kryo.register(remoteIfaceClass.ifaceClass, Serialization.this.remoteObjectSerializer);
                            continue;
                        }
                        if (!(clazz instanceof RemoteImplClass)) continue;
                        RemoteImplClass remoteImplClass = (RemoteImplClass)clazz;
                        int id = kryo.register(remoteImplClass.implClass, Serialization.this.remoteObjectSerializer).getId();
                        Serialization.this.rmiKryoIdToImpl.put(id, (Object)remoteImplClass.implClass);
                        Serialization.this.rmiKryoIdToIface.put(id, (Object)remoteImplClass.ifaceClass);
                    }
                    if (factory != null) {
                        kryo.setDefaultSerializer(factory);
                    }
                    return kryo;
                }
            }
        });
    }

    private static ArrayList<Class<?>> getHierarchy(Class<?> clazz) {
        ArrayList allClasses = new ArrayList();
        LinkedList parseClasses = new LinkedList();
        parseClasses.add(clazz);
        while (!parseClasses.isEmpty()) {
            Class nextClass = (Class)parseClasses.removeFirst();
            allClasses.add(nextClass);
            parseClasses.addAll(Arrays.asList(nextClass.getInterfaces()));
            Class superclass = nextClass.getSuperclass();
            if (superclass == null) continue;
            parseClasses.add(superclass);
        }
        allClasses.remove(clazz);
        return allClasses;
    }

    @Override
    public synchronized RmiSerializationManager register(Class<?> clazz) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate register(Class) call.");
        } else {
            if (this.forbidInterfaceRegistration && clazz.isInterface()) {
                throw new IllegalArgumentException("Cannot register an interface for serialization. It must be an implementation.");
            }
            this.classesToRegister.add(clazz);
        }
        return this;
    }

    @Override
    public synchronized RmiSerializationManager register(Class<?> clazz, int id) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate register(Class, int) call.");
        } else {
            if (this.forbidInterfaceRegistration && clazz.isInterface()) {
                throw new IllegalArgumentException("Cannot register an interface for serialization. It must be an implementation.");
            }
            this.classesToRegister.add(new ClassSerializer1(clazz, id));
        }
        return this;
    }

    @Override
    public synchronized RmiSerializationManager register(Class<?> clazz, Serializer<?> serializer) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate register(Class, Serializer) call.");
        } else {
            if (this.forbidInterfaceRegistration && clazz.isInterface()) {
                throw new IllegalArgumentException("Cannot register an interface for serialization. It must be an implementation.");
            }
            this.classesToRegister.add(new ClassSerializer(clazz, serializer));
        }
        return this;
    }

    @Override
    public synchronized RmiSerializationManager register(Class<?> clazz, Serializer<?> serializer, int id) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate register(Class, Serializer, int) call.");
        } else {
            if (this.forbidInterfaceRegistration && clazz.isInterface()) {
                throw new IllegalArgumentException("Cannot register an interface for serialization. It must be an implementation.");
            }
            this.classesToRegister.add(new ClassSerializer2(clazz, serializer, id));
        }
        return this;
    }

    @Override
    public synchronized boolean initRmiSerialization() {
        if (!this.usesRmi) {
            return false;
        }
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate initRmiSerialization() call.");
            return true;
        }
        this.methodSerializer = new InvokeMethodSerializer();
        this.invocationSerializer = new InvocationHandlerSerializer(logger);
        this.remoteObjectSerializer = new RemoteObjectSerializer();
        this.methodCache = new IntMap();
        return true;
    }

    @Override
    public KryoExtra takeKryo() {
        return (KryoExtra)((Object)this.kryoPool.take());
    }

    @Override
    public void returnKryo(KryoExtra kryo) {
        this.kryoPool.put((Object)kryo);
    }

    @Override
    public Class<?> getRmiImpl(Class<?> iface) {
        return (Class)this.rmiIfaceToImpl.get(iface);
    }

    @Override
    public synchronized RmiSerializationManager registerRmiInterface(Class<?> ifaceClass) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate registerRemote(Class) call.");
            return this;
        }
        if (!ifaceClass.isInterface()) {
            throw new IllegalArgumentException("Cannot register an implementation for RMI access. It must be an interface.");
        }
        this.usesRmi = true;
        this.classesToRegister.add(new RemoteIfaceClass(ifaceClass));
        return this;
    }

    @Override
    public synchronized <Iface, Impl extends Iface> RmiSerializationManager registerRmiImplementation(Class<Iface> ifaceClass, Class<Impl> implClass) {
        if (this.initialized) {
            logger.warn("Serialization manager already initialized. Ignoring duplicate registerRemote(Class, Class) call.");
            return this;
        }
        if (!ifaceClass.isInterface()) {
            throw new IllegalArgumentException("Cannot register an implementation for RMI access. It must be an interface.");
        }
        if (implClass.isInterface()) {
            throw new IllegalArgumentException("Cannot register an interface for RMI implementations. It must be an implementation.");
        }
        this.usesRmi = true;
        this.classesToRegister.add(new RemoteImplClass(ifaceClass, implClass));
        Class a = (Class)this.rmiIfaceToImpl.put(ifaceClass, implClass);
        Class b = (Class)this.rmiImplToIface.put(implClass, ifaceClass);
        if (a != null || b != null) {
            throw new IllegalArgumentException("Unable to override interface (" + ifaceClass + ") and implementation (" + implClass + ") because they have already been overridden by something else. It is critical that they are both unique per JVM");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(ByteBuf buffer, Object message) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        try {
            if (this.wireWriteLogger.isTraceEnabled()) {
                int start = buffer.writerIndex();
                kryo.write(buffer, message);
                int end = buffer.writerIndex();
                this.wireWriteLogger.trace(ByteBufUtil.hexDump((ByteBuf)buffer, (int)start, (int)(end - start)));
            } else {
                kryo.write(buffer, message);
            }
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object read(ByteBuf buffer, int length) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        try {
            if (this.wireReadLogger.isTraceEnabled()) {
                int start = buffer.readerIndex();
                Object object = kryo.read(buffer);
                int end = buffer.readerIndex();
                this.wireReadLogger.trace(ByteBufUtil.hexDump((ByteBuf)buffer, (int)start, (int)(end - start)));
                Object object2 = object;
                return object2;
            }
            Object object = kryo.read(buffer);
            return object;
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
    }

    @Override
    public void writeFullClassAndObject(Output output, Object value) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        boolean prev = false;
        try {
            prev = kryo.isRegistrationRequired();
            kryo.setRegistrationRequired(false);
            kryo.writeClassAndObject(output, value);
        }
        catch (Exception ex) {
            String msg = "Unable to serialize buffer";
            if (logger != null) {
                logger.error("Unable to serialize buffer", (Throwable)ex);
            }
            throw new IOException("Unable to serialize buffer", ex);
        }
        finally {
            kryo.setRegistrationRequired(prev);
            this.kryoPool.put((Object)kryo);
        }
    }

    @Override
    public Object readFullClassAndObject(Input input) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        boolean prev = false;
        try {
            prev = kryo.isRegistrationRequired();
            kryo.setRegistrationRequired(false);
            Object object = kryo.readClassAndObject(input);
            return object;
        }
        catch (Exception ex) {
            String msg = "Unable to deserialize buffer";
            if (logger != null) {
                logger.error("Unable to deserialize buffer", (Throwable)ex);
            }
            throw new IOException("Unable to deserialize buffer", ex);
        }
        finally {
            kryo.setRegistrationRequired(prev);
            this.kryoPool.put((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finishInit(Logger wireReadLogger, Logger wireWriteLogger) {
        this.wireReadLogger = wireReadLogger;
        this.wireWriteLogger = wireWriteLogger;
        this.initialized = true;
        KryoExtra kryo = null;
        try {
            kryo = (KryoExtra)((Object)this.kryoPool.take());
            ClassResolver classResolver = kryo.getClassResolver();
            for (Object clazz : this.classesToRegister) {
                CachedMethod[] cachedMethods;
                int id;
                if (clazz instanceof RemoteIfaceClass) {
                    RemoteIfaceClass remoteIfaceClass = (RemoteIfaceClass)clazz;
                    id = classResolver.getRegistration(remoteIfaceClass.ifaceClass).getId();
                    cachedMethods = RmiUtils.getCachedMethods(logger, kryo, this.useAsm, remoteIfaceClass.ifaceClass, null, id);
                    this.methodCache.put(id, (Object)cachedMethods);
                    continue;
                }
                if (!(clazz instanceof RemoteImplClass)) continue;
                RemoteImplClass remoteImplClass = (RemoteImplClass)clazz;
                id = classResolver.getRegistration(remoteImplClass.implClass).getId();
                cachedMethods = RmiUtils.getCachedMethods(logger, kryo, this.useAsm, remoteImplClass.ifaceClass, remoteImplClass.implClass, id);
                this.methodCache.put(id, (Object)cachedMethods);
            }
        }
        finally {
            if (kryo != null) {
                this.kryoPool.put((Object)kryo);
            }
        }
    }

    @Override
    public CachedMethod[] getMethods(int classId) {
        return (CachedMethod[])this.methodCache.get(classId);
    }

    @Override
    public synchronized boolean initialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeWithCrypto(C connection, ByteBuf buffer, Object message) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        try {
            if (connection.isLoopback()) {
                if (this.wireWriteLogger.isTraceEnabled()) {
                    int start = buffer.writerIndex();
                    kryo.writeCompressed(connection, buffer, message);
                    int end = buffer.writerIndex();
                    this.wireWriteLogger.trace(ByteBufUtil.hexDump((ByteBuf)buffer, (int)start, (int)(end - start)));
                } else {
                    kryo.writeCompressed(connection, buffer, message);
                }
            } else if (this.wireWriteLogger.isTraceEnabled()) {
                int start = buffer.writerIndex();
                kryo.writeCrypto(connection, buffer, message);
                int end = buffer.writerIndex();
                this.wireWriteLogger.trace(ByteBufUtil.hexDump((ByteBuf)buffer, (int)start, (int)(end - start)));
            } else {
                kryo.writeCrypto(connection, buffer, message);
            }
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object readWithCrypto(C connection, ByteBuf buffer, int length) throws IOException {
        KryoExtra kryo = (KryoExtra)((Object)this.kryoPool.take());
        try {
            if (connection.isLoopback()) {
                if (this.wireReadLogger.isTraceEnabled()) {
                    int start = buffer.readerIndex();
                    Object object = kryo.readCompressed(connection, buffer, length);
                    int end = buffer.readerIndex();
                    this.wireReadLogger.trace(ByteBufUtil.hexDump((ByteBuf)buffer, (int)start, (int)(end - start)));
                    Object object2 = object;
                    return object2;
                }
                Object start = kryo.readCompressed(connection, buffer, length);
                return start;
            }
            if (this.wireReadLogger.isTraceEnabled()) {
                int start = buffer.readerIndex();
                Object object = kryo.readCrypto(connection, buffer, length);
                int end = buffer.readerIndex();
                this.wireReadLogger.trace(ByteBufUtil.hexDump((ByteBuf)buffer, (int)start, (int)(end - start)));
                Object object3 = object;
                return object3;
            }
            Object object = kryo.readCrypto(connection, buffer, length);
            return object;
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
    }

    private static class ClassSerializer {
        final Class<?> clazz;
        final Serializer<?> serializer;

        ClassSerializer(Class<?> clazz, Serializer<?> serializer) {
            this.clazz = clazz;
            this.serializer = serializer;
        }
    }

    private static class ClassSerializer1 {
        final Class<?> clazz;
        final int id;

        ClassSerializer1(Class<?> clazz, int id) {
            this.clazz = clazz;
            this.id = id;
        }
    }

    private static class ClassSerializer2 {
        final Class<?> clazz;
        final Serializer<?> serializer;
        final int id;

        ClassSerializer2(Class<?> clazz, Serializer<?> serializer, int id) {
            this.clazz = clazz;
            this.serializer = serializer;
            this.id = id;
        }
    }

    private static class RemoteIfaceClass {
        private final Class<?> ifaceClass;

        RemoteIfaceClass(Class<?> ifaceClass) {
            this.ifaceClass = ifaceClass;
        }
    }

    private static class RemoteImplClass {
        private final Class<?> ifaceClass;
        private final Class<?> implClass;

        RemoteImplClass(Class<?> ifaceClass, Class<?> implClass) {
            this.ifaceClass = ifaceClass;
            this.implClass = implClass;
        }
    }
}

