/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.LocationResolver;
import dorkbox.util.OS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.ExportException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class NativeLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractLibrary(String sourceFileName, String destinationDirectory, String destinationName, String version) throws Exception {
        try {
            String suffix = OS.isLinux() ? ".so" : (OS.isWindows() ? ".dll" : ".dylib");
            String outputFileName = version == null ? destinationName + suffix : destinationName + "." + version + suffix;
            File file = new File(destinationDirectory, outputFileName);
            if (!file.canRead() || file.length() == 0L || !file.canExecute()) {
                InputStream inputStream = LocationResolver.getResourceAsStream(sourceFileName);
                FileOutputStream outStream = null;
                try {
                    int read;
                    outStream = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while ((read = inputStream.read(buffer)) > 0) {
                        ((OutputStream)outStream).write(buffer, 0, read);
                    }
                    outStream.flush();
                    ((OutputStream)outStream).close();
                    outStream = null;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        if (outStream != null) {
                            ((OutputStream)outStream).close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            return file;
        }
        catch (Exception e) {
            throw new ExportException("Error extracting library: " + sourceFileName, e);
        }
    }

    public static void loadLibrary(final File file) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.load(file.getAbsolutePath());
                return null;
            }
        });
    }

    private NativeLoader() {
    }
}

