/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.OSType;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.TimeZone;

public class OS {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    public static final int javaVersion = OS._getJavaVersion();
    private static final OSType osType;
    private static final String originalTimeZone;

    public static OSType get() {
        return osType;
    }

    public static boolean is64bit() {
        return osType.is64bit();
    }

    public static boolean is32bit() {
        return osType.is32bit();
    }

    public static boolean isX86() {
        return osType.isX86();
    }

    public static boolean isMips() {
        return osType.isMips();
    }

    public static boolean isArm() {
        return osType.isArm();
    }

    public static boolean isLinux() {
        return osType.isLinux();
    }

    public static boolean isUnix() {
        return osType.isUnix();
    }

    public static boolean isSolaris() {
        return osType.isSolaris();
    }

    public static boolean isWindows() {
        return osType.isWindows();
    }

    public static boolean isMacOsX() {
        return osType.isMacOsX();
    }

    public static boolean isAndroid() {
        return osType.isAndroid();
    }

    private static int _getJavaVersion() {
        String fullJavaVersion = System.getProperty("java.version");
        char versionChar = fullJavaVersion.startsWith("1.") ? fullJavaVersion.charAt(2) : fullJavaVersion.charAt(0);
        switch (versionChar) {
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    public static void setUTC() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    public static String getOriginalTimeZone() {
        return originalTimeZone;
    }

    public static int getOptimumNumberOfThreads() {
        return Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
    }

    public static String getExceptionMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (message != null) {
            int index = message.indexOf(LINE_SEPARATOR);
            if (index > -1) {
                message = message.substring(0, index);
            }
        } else {
            message = throwable.getClass().getSimpleName();
        }
        return message;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public final void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    public final void readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException();
    }

    static {
        originalTimeZone = TimeZone.getDefault().getID();
        Thread timerAccuracyThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(Long.MAX_VALUE);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }, "ForceHighResTimer");
        timerAccuracyThread.setDaemon(true);
        timerAccuracyThread.start();
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName != null && osArch != null) {
            osName = osName.toLowerCase(Locale.US);
            osArch = osArch.toLowerCase(Locale.US);
            if (osName.startsWith("linux")) {
                boolean isAndroid;
                try {
                    ClassLoader systemClassLoader = System.getSecurityManager() == null ? ClassLoader.getSystemClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            return ClassLoader.getSystemClassLoader();
                        }
                    });
                    Class.forName("android.app.Application", false, systemClassLoader);
                    isAndroid = true;
                }
                catch (ClassNotFoundException e) {
                    isAndroid = false;
                }
                osType = isAndroid ? (osArch.equals("armeabi") ? OSType.AndroidArm56 : (osArch.equals("armeabi-v7a") ? OSType.AndroidArm7 : (osArch.equals("arm64-v8a") ? OSType.AndroidArm8 : (osArch.equals("x86") ? OSType.AndroidX86 : (osArch.equals("x86_64") ? OSType.AndroidX86_64 : (osArch.equals("mips") ? OSType.AndroidMips : (osArch.equals("mips64") ? OSType.AndroidMips64 : null))))))) : ("amd64".equals(osArch) ? OSType.Linux64 : (osArch.startsWith("arm") ? (osArch.contains("v8") ? OSType.LinuxArm64 : OSType.LinuxArm32) : OSType.Linux32));
            } else {
                osType = osName.startsWith("windows") ? ("amd64".equals(osArch) ? OSType.Windows64 : OSType.Windows32) : (osName.startsWith("mac") || osName.startsWith("darwin") ? ("x86_64".equals(osArch) ? OSType.MacOsX64 : OSType.MacOsX32) : (osName.startsWith("freebsd") || osName.contains("nix") || osName.contains("nux") || osName.startsWith("aix") ? ("x86".equals(osArch) || "i386".equals(osArch) ? OSType.Unix32 : ("arm".equals(osArch) ? OSType.UnixArm : OSType.Unix64)) : (osName.startsWith("solaris") || osName.startsWith("sunos") ? OSType.Solaris : null)));
            }
        } else {
            osType = null;
        }
    }
}

