/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.bytes;

import dorkbox.util.bytes.UInteger;
import dorkbox.util.bytes.ULong;
import dorkbox.util.bytes.UShort;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class BigEndian {

    public static final class Char_ {
        public static char from(byte[] bytes, int offset, int bytenum) {
            char number = '\u0000';
            switch (bytenum) {
                case 2: {
                    number = (char)(number | (bytes[offset + 0] & 0xFF) << 8);
                }
                case 1: {
                    number = (char)(number | (bytes[offset + 1] & 0xFF) << 0);
                }
            }
            return number;
        }

        public static char from(byte[] bytes) {
            char number = '\u0000';
            switch (bytes.length) {
                default: {
                    number = (char)(number | (bytes[0] & 0xFF) << 8);
                }
                case 1: 
            }
            number = (char)(number | (bytes[1] & 0xFF) << 0);
            return number;
        }

        public static char from(byte b0, byte b1) {
            return (char)((b0 & 0xFF) << 8 | (b1 & 0xFF) << 0);
        }

        public static char from(ByteBuffer buff) {
            return Char_.from(buff.get(), buff.get());
        }

        public static char from(InputStream inputStream) throws IOException {
            return Char_.from((byte)inputStream.read(), (byte)inputStream.read());
        }

        public static byte[] toBytes(char x) {
            return new byte[]{(byte)(x >> 8), (byte)(x >> 0)};
        }

        public static void toBytes(char x, byte[] bytes, int offset) {
            bytes[offset + 0] = (byte)(x >> 8);
            bytes[offset + 1] = (byte)(x >> 0);
        }

        public static void toBytes(char x, byte[] bytes) {
            bytes[0] = (byte)(x >> 8);
            bytes[1] = (byte)(x >> 0);
        }

        private Char_() {
        }
    }

    public static final class Int_ {
        public static int from(byte[] bytes, int offset, int bytenum) {
            int number = 0;
            switch (bytenum) {
                case 4: {
                    number |= (bytes[offset + 0] & 0xFF) << 24;
                }
                case 3: {
                    number |= (bytes[offset + 1] & 0xFF) << 16;
                }
                case 2: {
                    number |= (bytes[offset + 2] & 0xFF) << 8;
                }
                case 1: {
                    number |= (bytes[offset + 3] & 0xFF) << 0;
                }
            }
            return number;
        }

        public static int from(byte[] bytes) {
            int number = 0;
            switch (bytes.length) {
                default: {
                    number |= (bytes[0] & 0xFF) << 24;
                }
                case 3: {
                    number |= (bytes[1] & 0xFF) << 16;
                }
                case 2: {
                    number |= (bytes[2] & 0xFF) << 8;
                }
                case 1: 
            }
            return number |= (bytes[3] & 0xFF) << 0;
        }

        public static int from(byte b0, byte b1, byte b2, byte b3) {
            return (b0 & 0xFF) << 24 | (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 0;
        }

        public static int from(ByteBuffer buff) {
            return Int_.from(buff.get(), buff.get(), buff.get(), buff.get());
        }

        public static int from(InputStream inputStream) throws IOException {
            return Int_.from((byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read());
        }

        public static byte[] toBytes(int x) {
            return new byte[]{(byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)(x >> 0)};
        }

        public static void toBytes(int x, byte[] bytes, int offset) {
            bytes[offset + 0] = (byte)(x >> 24);
            bytes[offset + 1] = (byte)(x >> 16);
            bytes[offset + 2] = (byte)(x >> 8);
            bytes[offset + 3] = (byte)(x >> 0);
        }

        public static void toBytes(int x, byte[] bytes) {
            bytes[0] = (byte)(x >> 24);
            bytes[1] = (byte)(x >> 16);
            bytes[2] = (byte)(x >> 8);
            bytes[3] = (byte)(x >> 0);
        }

        private Int_() {
        }
    }

    public static final class Long_ {
        public static long from(byte[] bytes, int offset, int bytenum) {
            long number = 0L;
            switch (bytenum) {
                case 8: {
                    number |= (long)(bytes[offset + 0] & 0xFF) << 56;
                }
                case 7: {
                    number |= (long)(bytes[offset + 1] & 0xFF) << 48;
                }
                case 6: {
                    number |= (long)(bytes[offset + 2] & 0xFF) << 40;
                }
                case 5: {
                    number |= (long)(bytes[offset + 3] & 0xFF) << 32;
                }
                case 4: {
                    number |= (long)(bytes[offset + 4] & 0xFF) << 24;
                }
                case 3: {
                    number |= (long)(bytes[offset + 5] & 0xFF) << 16;
                }
                case 2: {
                    number |= (long)(bytes[offset + 6] & 0xFF) << 8;
                }
                case 1: {
                    number |= (long)(bytes[offset + 7] & 0xFF) << 0;
                }
            }
            return number;
        }

        public static long from(byte[] bytes) {
            long number = 0L;
            switch (bytes.length) {
                default: {
                    number |= (long)(bytes[0] & 0xFF) << 56;
                }
                case 7: {
                    number |= (long)(bytes[1] & 0xFF) << 48;
                }
                case 6: {
                    number |= (long)(bytes[2] & 0xFF) << 40;
                }
                case 5: {
                    number |= (long)(bytes[3] & 0xFF) << 32;
                }
                case 4: {
                    number |= (long)(bytes[4] & 0xFF) << 24;
                }
                case 3: {
                    number |= (long)(bytes[5] & 0xFF) << 16;
                }
                case 2: {
                    number |= (long)(bytes[6] & 0xFF) << 8;
                }
                case 1: 
            }
            return number |= (long)(bytes[7] & 0xFF) << 0;
        }

        public static long from(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
            return (long)(b0 & 0xFF) << 56 | (long)(b1 & 0xFF) << 48 | (long)(b2 & 0xFF) << 40 | (long)(b3 & 0xFF) << 32 | (long)(b4 & 0xFF) << 24 | (long)(b5 & 0xFF) << 16 | (long)(b6 & 0xFF) << 8 | (long)(b7 & 0xFF) << 0;
        }

        public static long from(ByteBuffer buff) {
            return Long_.from(buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get());
        }

        public static long from(InputStream inputStream) throws IOException {
            return Long_.from((byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read());
        }

        public static byte[] toBytes(long x) {
            return new byte[]{(byte)(x >> 56), (byte)(x >> 48), (byte)(x >> 40), (byte)(x >> 32), (byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)(x >> 0)};
        }

        public static void toBytes(long x, byte[] bytes, int offset) {
            bytes[offset + 0] = (byte)(x >> 56);
            bytes[offset + 1] = (byte)(x >> 48);
            bytes[offset + 2] = (byte)(x >> 40);
            bytes[offset + 3] = (byte)(x >> 32);
            bytes[offset + 4] = (byte)(x >> 24);
            bytes[offset + 5] = (byte)(x >> 16);
            bytes[offset + 6] = (byte)(x >> 8);
            bytes[offset + 7] = (byte)(x >> 0);
        }

        public static void toBytes(long x, byte[] bytes) {
            bytes[0] = (byte)(x >> 56);
            bytes[1] = (byte)(x >> 48);
            bytes[2] = (byte)(x >> 40);
            bytes[3] = (byte)(x >> 32);
            bytes[4] = (byte)(x >> 24);
            bytes[5] = (byte)(x >> 16);
            bytes[6] = (byte)(x >> 8);
            bytes[7] = (byte)(x >> 0);
        }

        private Long_() {
        }
    }

    public static final class Short_ {
        public static short from(byte[] bytes, int offset, int bytenum) {
            short number = 0;
            switch (bytenum) {
                case 2: {
                    number = (short)(number | (bytes[offset + 0] & 0xFF) << 8);
                }
                case 1: {
                    number = (short)(number | (bytes[offset + 1] & 0xFF) << 0);
                }
            }
            return number;
        }

        public static short from(byte[] bytes) {
            short number = 0;
            switch (bytes.length) {
                default: {
                    number = (short)(number | (bytes[0] & 0xFF) << 8);
                }
                case 1: 
            }
            number = (short)(number | (bytes[1] & 0xFF) << 0);
            return number;
        }

        public static short from(byte b0, byte b1) {
            return (short)((b0 & 0xFF) << 8 | (b1 & 0xFF) << 0);
        }

        public static short from(ByteBuffer buff) {
            return Short_.from(buff.get(), buff.get());
        }

        public static short from(InputStream inputStream) throws IOException {
            return Short_.from((byte)inputStream.read(), (byte)inputStream.read());
        }

        public static byte[] toBytes(short x) {
            return new byte[]{(byte)(x >> 8), (byte)(x >> 0)};
        }

        public static void toBytes(short x, byte[] bytes, int offset) {
            bytes[offset + 0] = (byte)(x >> 8);
            bytes[offset + 1] = (byte)(x >> 0);
        }

        public static void toBytes(short x, byte[] bytes) {
            bytes[0] = (byte)(x >> 8);
            bytes[1] = (byte)(x >> 0);
        }

        private Short_() {
        }
    }

    public static final class UChar_ {
        public static UShort from(byte[] bytes, int offset, int bytenum) {
            int number = 0;
            switch (bytenum) {
                case 2: {
                    number = (char)(number | (bytes[offset + 0] & 0xFF) << 8);
                }
                case 1: {
                    number = (char)(number | (bytes[offset + 1] & 0xFF) << 0);
                }
            }
            return UShort.valueOf(number);
        }

        public static UShort from(byte[] bytes) {
            short number = 0;
            switch (bytes.length) {
                default: {
                    number = (short)(number | (bytes[0] & 0xFF) << 8);
                }
                case 1: 
            }
            number = (short)(number | (bytes[1] & 0xFF) << 0);
            return UShort.valueOf(number);
        }

        public static UShort from(byte b0, byte b1) {
            return UShort.valueOf((short)((b0 & 0xFF) << 8) | (b1 & 0xFF) << 0);
        }

        public static UShort from(ByteBuffer buff) {
            return UChar_.from(buff.get(), buff.get());
        }

        public static UShort from(InputStream inputStream) throws IOException {
            return UChar_.from((byte)inputStream.read(), (byte)inputStream.read());
        }

        public static byte[] toBytes(UShort x) {
            int num = x.intValue();
            return new byte[]{(byte)((num & 0xFF00) >> 8), (byte)(num & 0xFF)};
        }

        public static void toBytes(UShort x, byte[] bytes, int offset) {
            int num = x.intValue();
            bytes[offset + 0] = (byte)((num & 0xFF00) >> 8);
            bytes[offset + 1] = (byte)(num & 0xFF);
        }

        public static void toBytes(UShort x, byte[] bytes) {
            int num = x.intValue();
            bytes[0] = (byte)((num & 0xFF00) >> 8);
            bytes[1] = (byte)(num & 0xFF);
        }

        private UChar_() {
        }
    }

    public static final class UInt_ {
        public static UInteger from(byte[] bytes, int offset, int bytenum) {
            int number = 0;
            switch (bytenum) {
                case 4: {
                    number |= (bytes[offset + 0] & 0xFF) << 24;
                }
                case 3: {
                    number |= (bytes[offset + 1] & 0xFF) << 16;
                }
                case 2: {
                    number |= (bytes[offset + 2] & 0xFF) << 8;
                }
                case 1: {
                    number |= (bytes[offset + 3] & 0xFF) << 0;
                }
            }
            return UInteger.valueOf(number);
        }

        public static UInteger from(byte[] bytes) {
            int number = 0;
            switch (bytes.length) {
                default: {
                    number |= (bytes[0] & 0xFF) << 24;
                }
                case 3: {
                    number |= (bytes[1] & 0xFF) << 16;
                }
                case 2: {
                    number |= (bytes[2] & 0xFF) << 8;
                }
                case 1: 
            }
            return UInteger.valueOf(number |= (bytes[3] & 0xFF) << 0);
        }

        public static UInteger from(byte b0, byte b1, byte b2, byte b3) {
            int number = (b0 & 0xFF) << 24 | (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 0;
            return UInteger.valueOf(number);
        }

        public static UInteger from(ByteBuffer buff) {
            return UInt_.from(buff.get(), buff.get(), buff.get(), buff.get());
        }

        public static UInteger from(InputStream inputStream) throws IOException {
            return UInt_.from((byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read());
        }

        public static byte[] toBytes(UInteger x) {
            long num = x.longValue();
            return new byte[]{(byte)((num & 0xFF000000L) >> 24), (byte)((num & 0xFF0000L) >> 16), (byte)((num & 0xFF00L) >> 8), (byte)(num & 0xFFL)};
        }

        public static void toBytes(UInteger x, byte[] bytes, int offset) {
            long num = x.longValue();
            bytes[offset + 0] = (byte)((num & 0xFF000000L) >> 24);
            bytes[offset + 1] = (byte)((num & 0xFF0000L) >> 16);
            bytes[offset + 2] = (byte)((num & 0xFF00L) >> 8);
            bytes[offset + 3] = (byte)(num & 0xFFL);
        }

        public static void toBytes(UInteger x, byte[] bytes) {
            long num = x.longValue();
            bytes[0] = (byte)((num & 0xFF000000L) >> 24);
            bytes[1] = (byte)((num & 0xFF0000L) >> 16);
            bytes[2] = (byte)((num & 0xFF00L) >> 8);
            bytes[3] = (byte)(num & 0xFFL);
        }

        private UInt_() {
        }
    }

    public static final class ULong_ {
        public static ULong from(byte[] bytes, int offset, int bytenum) {
            long number = 0L;
            switch (bytenum) {
                case 8: {
                    number |= (long)(bytes[offset + 0] & 0xFF) << 56;
                }
                case 7: {
                    number |= (long)(bytes[offset + 1] & 0xFF) << 48;
                }
                case 6: {
                    number |= (long)(bytes[offset + 2] & 0xFF) << 40;
                }
                case 5: {
                    number |= (long)(bytes[offset + 3] & 0xFF) << 32;
                }
                case 4: {
                    number |= (long)(bytes[offset + 4] & 0xFF) << 24;
                }
                case 3: {
                    number |= (long)(bytes[offset + 5] & 0xFF) << 16;
                }
                case 2: {
                    number |= (long)(bytes[offset + 6] & 0xFF) << 8;
                }
                case 1: {
                    number |= (long)(bytes[offset + 7] & 0xFF) << 0;
                }
            }
            return ULong.valueOf(number);
        }

        public static ULong from(byte[] bytes) {
            BigInteger ulong = new BigInteger(1, bytes);
            return ULong.valueOf(ulong);
        }

        public static ULong from(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
            byte[] bytes = new byte[]{b0, b1, b2, b3, b4, b5, b6, b7};
            BigInteger ulong = new BigInteger(1, bytes);
            return ULong.valueOf(ulong);
        }

        public static ULong from(ByteBuffer buff) {
            return ULong_.from(buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get(), buff.get());
        }

        public static ULong from(InputStream inputStream) throws IOException {
            return ULong_.from((byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read());
        }

        public static byte[] toBytes(ULong x) {
            byte[] bytes = x.toBigInteger().toByteArray();
            if (bytes.length < 8) {
                byte[] fixedBytes = new byte[8];
                int length = bytes.length;
                for (int i = 0; i < 8; ++i) {
                    fixedBytes[i] = i < length ? bytes[i] : (byte)0;
                }
                bytes = fixedBytes;
            }
            return bytes;
        }

        public static void toBytes(ULong x, byte[] bytes, int offset) {
            byte[] bytes1 = ULong_.toBytes(x);
            int length = bytes.length;
            int pos = 8;
            while (length > 0) {
                bytes[pos--] = bytes1[offset + length--];
            }
        }

        public static void toBytes(ULong x, byte[] bytes) {
            byte[] bytes1 = ULong_.toBytes(x);
            int length = bytes.length;
            int pos = 8;
            while (length > 0) {
                bytes[pos--] = bytes1[length--];
            }
        }

        private ULong_() {
        }
    }

    public static final class UShort_ {
        public static UShort from(byte[] bytes, int offset, int bytenum) {
            int number = 0;
            switch (bytenum) {
                case 2: {
                    number = (char)(number | (bytes[offset + 0] & 0xFF) << 8);
                }
                case 1: {
                    number = (char)(number | (bytes[offset + 1] & 0xFF) << 0);
                }
            }
            return UShort.valueOf(number);
        }

        public static UShort from(byte[] bytes) {
            short number = 0;
            switch (bytes.length) {
                default: {
                    number = (short)(number | (bytes[0] & 0xFF) << 8);
                }
                case 1: 
            }
            number = (short)(number | (bytes[1] & 0xFF) << 0);
            return UShort.valueOf(number);
        }

        public static UShort from(byte b0, byte b1) {
            return UShort.valueOf((short)((b0 & 0xFF) << 8) | (b1 & 0xFF) << 0);
        }

        public static UShort from(ByteBuffer buff) {
            return UShort_.from(buff.get(), buff.get());
        }

        public static UShort from(InputStream inputStream) throws IOException {
            return UShort_.from((byte)inputStream.read(), (byte)inputStream.read());
        }

        public static byte[] toBytes(UShort x) {
            int num = x.intValue();
            return new byte[]{(byte)((num & 0xFF00) >> 8), (byte)(num & 0xFF)};
        }

        public static void toBytes(UShort x, byte[] bytes, int offset) {
            int num = x.intValue();
            bytes[offset + 0] = (byte)((num & 0xFF00) >> 8);
            bytes[offset + 1] = (byte)(num & 0xFF);
        }

        public static void toBytes(UShort x, byte[] bytes) {
            int num = x.intValue();
            bytes[0] = (byte)((num & 0xFF00) >> 8);
            bytes[1] = (byte)(num & 0xFF);
        }

        private UShort_() {
        }
    }
}

