/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.bytes;

import java.util.Arrays;

public class ByteArrayWrapper {
    private byte[] data;
    private Integer hashCode;

    private ByteArrayWrapper() {
    }

    public ByteArrayWrapper(byte[] data, boolean copyBytes) {
        if (data == null) {
            throw new NullPointerException();
        }
        int length = data.length;
        if (copyBytes) {
            this.data = new byte[length];
            System.arraycopy(data, 0, this.data, 0, length);
        } else {
            this.data = data;
        }
    }

    public static ByteArrayWrapper copy(byte[] data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayWrapper(data, true);
    }

    public static ByteArrayWrapper wrap(byte[] data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayWrapper(data, false);
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int hashCode() {
        Integer hashCode = this.hashCode;
        if (hashCode == null) {
            this.hashCode = hashCode = Integer.valueOf(Arrays.hashCode(this.data));
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteArrayWrapper)) {
            return false;
        }
        return Arrays.equals(this.data, ((ByteArrayWrapper)other).data);
    }

    public String toString() {
        return "ByteArrayWrapper " + Arrays.toString(this.data);
    }
}

