/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.bytes;

import dorkbox.util.bytes.OptimizeUtilsByteBuf;

public class OptimizeUtilsByteArray {
    public static int intLength(int value, boolean optimizePositive) {
        return OptimizeUtilsByteBuf.intLength(value, optimizePositive);
    }

    public static boolean canReadInt(byte[] buffer) {
        int position = 0;
        return OptimizeUtilsByteArray.canReadInt(buffer, position);
    }

    public static boolean canReadInt(byte[] buffer, int position) {
        int length = buffer.length;
        if (length >= 5) {
            return true;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == length) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == length) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == length) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        return position != length;
    }

    public static int readInt(byte[] buffer, boolean optimizePositive) {
        int position = 0;
        return OptimizeUtilsByteArray.readInt(buffer, optimizePositive, position);
    }

    public static int readInt(byte[] buffer, boolean optimizePositive, int position) {
        byte b = buffer[position++];
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer[position++];
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer[position++];
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer[position++];
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer[position++];
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public static int writeInt(byte[] buffer, int value, boolean optimizePositive) {
        int position = 0;
        return OptimizeUtilsByteArray.writeInt(buffer, value, optimizePositive, position);
    }

    public static int writeInt(byte[] buffer, int value, boolean optimizePositive, int position) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            buffer[position++] = (byte)value;
            return 1;
        }
        if (value >>> 14 == 0) {
            buffer[position++] = (byte)(value & 0x7F | 0x80);
            buffer[position++] = (byte)(value >>> 7);
            return 2;
        }
        if (value >>> 21 == 0) {
            buffer[position++] = (byte)(value & 0x7F | 0x80);
            buffer[position++] = (byte)(value >>> 7 | 0x80);
            buffer[position++] = (byte)(value >>> 14);
            return 3;
        }
        if (value >>> 28 == 0) {
            buffer[position++] = (byte)(value & 0x7F | 0x80);
            buffer[position++] = (byte)(value >>> 7 | 0x80);
            buffer[position++] = (byte)(value >>> 14 | 0x80);
            buffer[position++] = (byte)(value >>> 21);
            return 4;
        }
        buffer[position++] = (byte)(value & 0x7F | 0x80);
        buffer[position++] = (byte)(value >>> 7 | 0x80);
        buffer[position++] = (byte)(value >>> 14 | 0x80);
        buffer[position++] = (byte)(value >>> 21 | 0x80);
        buffer[position++] = (byte)(value >>> 28);
        return 5;
    }

    public static int longLength(long value, boolean optimizePositive) {
        return OptimizeUtilsByteBuf.longLength(value, optimizePositive);
    }

    public static long readLong(byte[] buffer, boolean optimizePositive) {
        int position = 0;
        return OptimizeUtilsByteArray.readLong(buffer, optimizePositive, position);
    }

    public static long readLong(byte[] buffer, boolean optimizePositive, int position) {
        byte b = buffer[position++];
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer[position++];
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer[position++];
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer[position++];
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer[position++];
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer[position++];
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer[position++];
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer[position++];
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer[position++];
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    public static int writeLong(byte[] buffer, long value, boolean optimizePositive) {
        int position = 0;
        return OptimizeUtilsByteArray.writeLong(buffer, value, optimizePositive, position);
    }

    public static int writeLong(byte[] buffer, long value, boolean optimizePositive, int position) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            buffer[position++] = (byte)value;
            return 1;
        }
        if (value >>> 14 == 0L) {
            buffer[position++] = (byte)(value & 0x7FL | 0x80L);
            buffer[position++] = (byte)(value >>> 7);
            return 2;
        }
        if (value >>> 21 == 0L) {
            buffer[position++] = (byte)(value & 0x7FL | 0x80L);
            buffer[position++] = (byte)(value >>> 7 | 0x80L);
            buffer[position++] = (byte)(value >>> 14);
            return 3;
        }
        if (value >>> 28 == 0L) {
            buffer[position++] = (byte)(value & 0x7FL | 0x80L);
            buffer[position++] = (byte)(value >>> 7 | 0x80L);
            buffer[position++] = (byte)(value >>> 14 | 0x80L);
            buffer[position++] = (byte)(value >>> 21);
            return 4;
        }
        if (value >>> 35 == 0L) {
            buffer[position++] = (byte)(value & 0x7FL | 0x80L);
            buffer[position++] = (byte)(value >>> 7 | 0x80L);
            buffer[position++] = (byte)(value >>> 14 | 0x80L);
            buffer[position++] = (byte)(value >>> 21 | 0x80L);
            buffer[position++] = (byte)(value >>> 28);
            return 5;
        }
        if (value >>> 42 == 0L) {
            buffer[position++] = (byte)(value & 0x7FL | 0x80L);
            buffer[position++] = (byte)(value >>> 7 | 0x80L);
            buffer[position++] = (byte)(value >>> 14 | 0x80L);
            buffer[position++] = (byte)(value >>> 21 | 0x80L);
            buffer[position++] = (byte)(value >>> 28 | 0x80L);
            buffer[position++] = (byte)(value >>> 35);
            return 6;
        }
        if (value >>> 49 == 0L) {
            buffer[position++] = (byte)(value & 0x7FL | 0x80L);
            buffer[position++] = (byte)(value >>> 7 | 0x80L);
            buffer[position++] = (byte)(value >>> 14 | 0x80L);
            buffer[position++] = (byte)(value >>> 21 | 0x80L);
            buffer[position++] = (byte)(value >>> 28 | 0x80L);
            buffer[position++] = (byte)(value >>> 35 | 0x80L);
            buffer[position++] = (byte)(value >>> 42);
            return 7;
        }
        if (value >>> 56 == 0L) {
            buffer[position++] = (byte)(value & 0x7FL | 0x80L);
            buffer[position++] = (byte)(value >>> 7 | 0x80L);
            buffer[position++] = (byte)(value >>> 14 | 0x80L);
            buffer[position++] = (byte)(value >>> 21 | 0x80L);
            buffer[position++] = (byte)(value >>> 28 | 0x80L);
            buffer[position++] = (byte)(value >>> 35 | 0x80L);
            buffer[position++] = (byte)(value >>> 42 | 0x80L);
            buffer[position++] = (byte)(value >>> 49);
            return 8;
        }
        buffer[position++] = (byte)(value & 0x7FL | 0x80L);
        buffer[position++] = (byte)(value >>> 7 | 0x80L);
        buffer[position++] = (byte)(value >>> 14 | 0x80L);
        buffer[position++] = (byte)(value >>> 21 | 0x80L);
        buffer[position++] = (byte)(value >>> 28 | 0x80L);
        buffer[position++] = (byte)(value >>> 35 | 0x80L);
        buffer[position++] = (byte)(value >>> 42 | 0x80L);
        buffer[position++] = (byte)(value >>> 49 | 0x80L);
        buffer[position++] = (byte)(value >>> 56);
        return 9;
    }

    public static boolean canReadLong(byte[] buffer) {
        int position = 0;
        return OptimizeUtilsByteArray.canReadLong(buffer, position);
    }

    private static boolean canReadLong(byte[] buffer, int position) {
        int limit = buffer.length;
        if (limit >= 9) {
            return true;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == limit) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == limit) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == limit) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == limit) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == limit) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == limit) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        if (position == limit) {
            return false;
        }
        if ((buffer[position++] & 0x80) == 0) {
            return true;
        }
        return position != limit;
    }

    private OptimizeUtilsByteArray() {
    }
}

