/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.collections;

import com.esotericsoftware.kryo.util.IdentityMap;
import dorkbox.util.Property;
import dorkbox.util.collections.ConcurrentEntry;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ConcurrentIterator<T> {
    @Property
    public static final float LOAD_FACTOR = 0.8f;
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private final int ID = ID_COUNTER.getAndIncrement();
    private final IdentityMap<T, ConcurrentEntry> entries = new IdentityMap(32, 0.8f);
    private volatile ConcurrentEntry<T> head = null;
    public static final AtomicReferenceFieldUpdater<ConcurrentIterator, ConcurrentEntry> headREF = AtomicReferenceFieldUpdater.newUpdater(ConcurrentIterator.class, ConcurrentEntry.class, "head");

    public final void clear() {
        this.entries.clear();
        this.head = null;
    }

    public synchronized void add(T listener) {
        ConcurrentEntry<T> head = headREF.get(this);
        if (!this.entries.containsKey(listener)) {
            head = new ConcurrentEntry<T>(listener, head);
            this.entries.put(listener, head);
            headREF.lazySet(this, head);
        }
    }

    public synchronized boolean remove(T listener) {
        ConcurrentEntry concurrentEntry = (ConcurrentEntry)this.entries.get(listener);
        if (concurrentEntry != null) {
            ConcurrentEntry head = headREF.get(this);
            if (concurrentEntry == head) {
                head = head.next();
            } else {
                concurrentEntry.remove();
            }
            headREF.lazySet(this, head);
            this.entries.remove(listener);
            return true;
        }
        return false;
    }

    public synchronized int size() {
        return this.entries.size;
    }

    public final int hashCode() {
        return this.ID;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcurrentIterator other = (ConcurrentIterator)obj;
        return this.ID == other.ID;
    }
}

