/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class LockFreeHashMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final AtomicReferenceFieldUpdater<LockFreeHashMap, HashMap> mapREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeHashMap.class, HashMap.class, "hashMap");
    private volatile HashMap<K, V> hashMap;

    public LockFreeHashMap() {
        this.hashMap = new HashMap();
    }

    public LockFreeHashMap(int initialCapacity) {
        this.hashMap = new HashMap(initialCapacity);
    }

    public LockFreeHashMap(Map<K, V> map) {
        this.hashMap = new HashMap<K, V>(map);
    }

    public LockFreeHashMap(int initialCapacity, float loadFactor) {
        this.hashMap = new HashMap(initialCapacity, loadFactor);
    }

    public Map<K, V> getMap() {
        return Collections.unmodifiableMap(mapREF.get(this));
    }

    @Override
    public int size() {
        return mapREF.get(this).size();
    }

    @Override
    public boolean isEmpty() {
        return mapREF.get(this).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return mapREF.get(this).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return mapREF.get(this).containsValue(value);
    }

    @Override
    public V get(Object key) {
        return mapREF.get(this).get(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        return this.hashMap.put(key, value);
    }

    @Override
    public synchronized V remove(Object key) {
        return this.hashMap.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        this.hashMap.putAll(map);
    }

    @Override
    public synchronized void clear() {
        this.hashMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return mapREF.get(this).equals(o);
    }

    @Override
    public int hashCode() {
        return mapREF.get(this).hashCode();
    }

    public String toString() {
        return mapREF.get(this).toString();
    }
}

