/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.collections;

import dorkbox.util.collections.IntMap;
import dorkbox.util.collections.LockFreeObjectIntBiMap;
import dorkbox.util.collections.ObjectIntMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LockFreeIntBiMap<V> {
    private static final AtomicReferenceFieldUpdater<LockFreeIntBiMap, IntMap> forwardREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeIntBiMap.class, IntMap.class, "forwardHashMap");
    private static final AtomicReferenceFieldUpdater<LockFreeIntBiMap, ObjectIntMap> reverseREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeIntBiMap.class, ObjectIntMap.class, "reverseHashMap");
    private volatile IntMap<V> forwardHashMap;
    private volatile ObjectIntMap<V> reverseHashMap;
    private final int defaultReturnValue;
    private final LockFreeObjectIntBiMap<V> inverse;

    public LockFreeIntBiMap() {
        this(Integer.MIN_VALUE);
    }

    public LockFreeIntBiMap(int defaultReturnValue) {
        this(new IntMap(), new ObjectIntMap(), defaultReturnValue);
    }

    public LockFreeIntBiMap(IntMap<V> forwardHashMap, ObjectIntMap<V> reverseHashMap, int defaultReturnValue) {
        this.forwardHashMap = forwardHashMap;
        this.reverseHashMap = reverseHashMap;
        this.defaultReturnValue = defaultReturnValue;
        this.inverse = new LockFreeObjectIntBiMap<V>(reverseHashMap, forwardHashMap, defaultReturnValue, this);
    }

    LockFreeIntBiMap(IntMap<V> forwardHashMap, ObjectIntMap<V> reverseHashMap, int defaultReturnValue, LockFreeObjectIntBiMap<V> inverse) {
        this.forwardHashMap = forwardHashMap;
        this.reverseHashMap = reverseHashMap;
        this.defaultReturnValue = defaultReturnValue;
        this.inverse = inverse;
    }

    public synchronized void clear() {
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
    }

    public LockFreeObjectIntBiMap<V> inverse() {
        return this.inverse;
    }

    public synchronized V put(int key, V value) throws IllegalArgumentException {
        V prevForwardValue = this.forwardHashMap.put(key, value);
        if (prevForwardValue != null) {
            this.reverseHashMap.remove(prevForwardValue, this.defaultReturnValue);
        }
        int prevReverseValue = this.reverseHashMap.get(value, this.defaultReturnValue);
        this.reverseHashMap.put(value, key);
        if (prevReverseValue != this.defaultReturnValue) {
            if (prevForwardValue != null) {
                this.forwardHashMap.put(key, prevForwardValue);
            } else {
                this.forwardHashMap.remove(key);
            }
            this.reverseHashMap.put(value, prevReverseValue);
            throw new IllegalArgumentException("Value already exists. Keys and values must both be unique!");
        }
        return prevForwardValue;
    }

    public synchronized V putForce(int key, V value) {
        V prevForwardValue = this.forwardHashMap.put(key, value);
        if (prevForwardValue != null) {
            this.reverseHashMap.remove(prevForwardValue, this.defaultReturnValue);
        }
        int prevReverseValue = this.reverseHashMap.get(value, this.defaultReturnValue);
        this.reverseHashMap.put(value, key);
        if (prevReverseValue != this.defaultReturnValue) {
            this.forwardHashMap.remove(prevReverseValue);
        }
        return prevForwardValue;
    }

    public synchronized void putAll(Map<Integer, V> hashMap) throws IllegalArgumentException {
        LockFreeIntBiMap<V> biMap = new LockFreeIntBiMap<V>();
        for (Map.Entry<Integer, V> entry : hashMap.entrySet()) {
            Integer key = entry.getKey();
            V value = entry.getValue();
            biMap.put(key, value);
            if (this.forwardHashMap.containsKey(key)) {
                throw new IllegalArgumentException("Key already exists. Keys and values must both be unique!");
            }
            if (!this.reverseHashMap.containsKey(value)) continue;
            throw new IllegalArgumentException("Value already exists. Keys and values must both be unique!");
        }
        this.forwardHashMap.putAll(biMap.forwardHashMap);
        this.reverseHashMap.putAll(biMap.reverseHashMap);
    }

    public synchronized void putAllForce(Map<Integer, V> hashMap) {
        for (Map.Entry<Integer, V> entry : hashMap.entrySet()) {
            Integer key = entry.getKey();
            V value = entry.getValue();
            this.putForce(key, value);
        }
    }

    public synchronized V remove(int key) {
        V value = this.forwardHashMap.remove(key);
        this.reverseHashMap.remove(value, this.defaultReturnValue);
        return value;
    }

    public V get(int key) {
        return forwardREF.get(this).get(key);
    }

    public IntMap.Keys keys() {
        return forwardREF.get(this).keys();
    }

    public Iterator<V> values() {
        return forwardREF.get(this).values();
    }

    public boolean isEmpty() {
        return LockFreeIntBiMap.forwardREF.get((LockFreeIntBiMap)this).size == 0;
    }

    public int size() {
        return LockFreeIntBiMap.forwardREF.get((LockFreeIntBiMap)this).size;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = forwardREF.get(this).hashCode();
        result = 31 * result + reverseREF.get(this).hashCode();
        result = 31 * result + this.defaultReturnValue;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LockFreeIntBiMap {");
        IntMap.Keys keys = this.keys();
        Iterator<V> values = this.values();
        while (keys.hasNext) {
            builder.append(keys.next());
            builder.append(" (").append(values.next()).append("), ");
        }
        int length = builder.length();
        if (length > 1) {
            builder.delete(length - 2, length);
        }
        builder.append('}');
        return builder.toString();
    }
}

