/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.collections;

import dorkbox.util.collections.IntMap;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class LockFreeIntMap<V>
implements Cloneable,
Serializable {
    private static final AtomicReferenceFieldUpdater<LockFreeIntMap, IntMap> mapREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeIntMap.class, IntMap.class, "map");
    private volatile IntMap<V> map;

    public LockFreeIntMap() {
        this.map = new IntMap();
    }

    public LockFreeIntMap(int initialCapacity) {
        this.map = new IntMap(initialCapacity);
    }

    public LockFreeIntMap(int initialCapacity, float loadFactor) {
        this.map = new IntMap(initialCapacity, loadFactor);
    }

    public int size() {
        return LockFreeIntMap.mapREF.get((LockFreeIntMap)this).size;
    }

    public boolean isEmpty() {
        return LockFreeIntMap.mapREF.get((LockFreeIntMap)this).size == 0;
    }

    public boolean containsKey(int key) {
        return mapREF.get(this).containsKey(key);
    }

    public boolean containsValue(Object value, boolean identity) {
        return mapREF.get(this).containsValue(value, identity);
    }

    public V get(int key) {
        return mapREF.get(this).get(key);
    }

    public synchronized V put(int key, V value) {
        return this.map.put(key, value);
    }

    public synchronized V remove(int key) {
        return this.map.remove(key);
    }

    public synchronized void putAll(IntMap<V> map) {
        this.map.putAll(map);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return mapREF.get(this).hashCode();
    }

    public String toString() {
        return mapREF.get(this).toString();
    }

    public IntMap.Keys keySet() {
        return mapREF.get(this).keys();
    }

    public IntMap.Values<V> values() {
        return mapREF.get(this).values();
    }
}

