/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.collections;

import dorkbox.util.collections.IntMap;
import dorkbox.util.collections.LockFreeIntBiMap;
import dorkbox.util.collections.ObjectIntMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LockFreeObjectIntBiMap<V> {
    private static final AtomicReferenceFieldUpdater<LockFreeObjectIntBiMap, ObjectIntMap> forwardREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeObjectIntBiMap.class, ObjectIntMap.class, "forwardHashMap");
    private static final AtomicReferenceFieldUpdater<LockFreeObjectIntBiMap, IntMap> reverseREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeObjectIntBiMap.class, IntMap.class, "reverseHashMap");
    private volatile ObjectIntMap<V> forwardHashMap;
    private volatile IntMap<V> reverseHashMap;
    private final int defaultReturnValue;
    private final LockFreeIntBiMap<V> inverse;

    public LockFreeObjectIntBiMap() {
        this(Integer.MIN_VALUE);
    }

    public LockFreeObjectIntBiMap(int defaultReturnValue) {
        this(new ObjectIntMap(), new IntMap(), defaultReturnValue);
    }

    LockFreeObjectIntBiMap(ObjectIntMap<V> forwardHashMap, IntMap<V> reverseHashMap, int defaultReturnValue) {
        this.forwardHashMap = forwardHashMap;
        this.reverseHashMap = reverseHashMap;
        this.defaultReturnValue = defaultReturnValue;
        this.inverse = new LockFreeIntBiMap<V>(reverseHashMap, forwardHashMap, defaultReturnValue, this);
    }

    LockFreeObjectIntBiMap(ObjectIntMap<V> forwardHashMap, IntMap<V> reverseHashMap, int defaultReturnValue, LockFreeIntBiMap<V> inverse) {
        this.forwardHashMap = forwardHashMap;
        this.reverseHashMap = reverseHashMap;
        this.defaultReturnValue = defaultReturnValue;
        this.inverse = inverse;
    }

    public synchronized void clear() {
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
    }

    public LockFreeIntBiMap<V> inverse() {
        return this.inverse;
    }

    public synchronized int put(V key, int value) throws IllegalArgumentException {
        V prevReverseValue;
        int prevForwardValue = this.forwardHashMap.get(key, this.defaultReturnValue);
        this.forwardHashMap.put(key, value);
        if (prevForwardValue != this.defaultReturnValue) {
            this.reverseHashMap.remove(prevForwardValue);
        }
        if ((prevReverseValue = this.reverseHashMap.put(value, key)) != null) {
            if (prevForwardValue != this.defaultReturnValue) {
                this.forwardHashMap.put(key, prevForwardValue);
            } else {
                this.forwardHashMap.remove(key, this.defaultReturnValue);
            }
            this.reverseHashMap.put(value, prevReverseValue);
            throw new IllegalArgumentException("Value already exists. Keys and values must both be unique!");
        }
        return prevForwardValue;
    }

    public synchronized int putForce(V key, int value) {
        int prevForwardValue = this.forwardHashMap.get(key, this.defaultReturnValue);
        this.forwardHashMap.put(key, value);
        if (prevForwardValue != this.defaultReturnValue) {
            this.reverseHashMap.remove(prevForwardValue);
        }
        V prevReverseValue = this.reverseHashMap.get(value);
        this.reverseHashMap.put(value, key);
        if (prevReverseValue != null) {
            this.forwardHashMap.remove(prevReverseValue, this.defaultReturnValue);
        }
        return prevForwardValue;
    }

    public synchronized void putAll(Map<V, Integer> hashMap) throws IllegalArgumentException {
        LockFreeObjectIntBiMap<V> biMap = new LockFreeObjectIntBiMap<V>();
        for (Map.Entry<V, Integer> entry : hashMap.entrySet()) {
            V key = entry.getKey();
            Integer value = entry.getValue();
            biMap.put(key, value);
            if (this.forwardHashMap.containsKey(key)) {
                throw new IllegalArgumentException("Key already exists. Keys and values must both be unique!");
            }
            if (!this.reverseHashMap.containsKey(value)) continue;
            throw new IllegalArgumentException("Value already exists. Keys and values must both be unique!");
        }
        this.forwardHashMap.putAll(biMap.forwardHashMap);
        this.reverseHashMap.putAll(biMap.reverseHashMap);
    }

    public synchronized void putAllForce(Map<V, Integer> hashMap) {
        for (Map.Entry<V, Integer> entry : hashMap.entrySet()) {
            V key = entry.getKey();
            Integer value = entry.getValue();
            this.putForce(key, value);
        }
    }

    public synchronized int remove(V key) {
        int value = this.forwardHashMap.remove(key, this.defaultReturnValue);
        this.reverseHashMap.remove(value);
        return value;
    }

    public int get(V key) {
        return forwardREF.get(this).get(key, this.defaultReturnValue);
    }

    public Iterator<V> keys() {
        return this.inverse.values();
    }

    public IntMap.Keys values() {
        return this.inverse.keys();
    }

    public boolean isEmpty() {
        return LockFreeObjectIntBiMap.forwardREF.get((LockFreeObjectIntBiMap)this).size == 0;
    }

    public int size() {
        return LockFreeObjectIntBiMap.forwardREF.get((LockFreeObjectIntBiMap)this).size;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = forwardREF.get(this).hashCode();
        result = 31 * result + reverseREF.get(this).hashCode();
        result = 31 * result + this.defaultReturnValue;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LockFreeObjectIntBiMap {");
        Iterator<V> keys = this.keys();
        IntMap.Keys values = this.values();
        while (keys.hasNext()) {
            builder.append(keys.next());
            builder.append(" (").append(values.next()).append("), ");
        }
        int length = builder.length();
        if (length > 1) {
            builder.delete(length - 2, length);
        }
        builder.append('}');
        return builder.toString();
    }
}

