/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.entropy;

import dorkbox.util.entropy.EntropyProvider;
import dorkbox.util.entropy.SimpleEntropy;
import dorkbox.util.exceptions.InitializationException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Entropy {
    private static EntropyProvider provider = null;

    public static byte[] get(String messageForUser) throws InitializationException {
        Class<Entropy> clazz = Entropy.class;
        synchronized (Entropy.class) {
            try {
                if (provider == null) {
                    Entropy.init(SimpleEntropy.class, new Object[0]);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return provider.get(messageForUser);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(Entropy.class);
                String error = "Unable to get entropy bytes for " + provider.getClass();
                logger.error(error, (Throwable)e);
                throw new InitializationException(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Class<? extends EntropyProvider> providerClass, Object ... args) throws InitializationException {
        Class<Entropy> clazz = Entropy.class;
        synchronized (Entropy.class) {
            if (provider == null) {
                Exception exception = null;
                try {
                    Method[] declaredMethods;
                    Method createMethod = null;
                    for (Method m : declaredMethods = providerClass.getDeclaredMethods()) {
                        if (!m.getName().equals("create")) continue;
                        createMethod = m;
                        break;
                    }
                    if (createMethod != null) {
                        createMethod.setAccessible(true);
                        provider = args.length == 0 ? (EntropyProvider)createMethod.invoke(null, new Object[0]) : (EntropyProvider)createMethod.invoke(null, args);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
                catch (Exception e) {
                    exception = e;
                }
                Logger logger = LoggerFactory.getLogger(Entropy.class);
                String error = "Unable to create entropy provider for " + providerClass + " with " + args.length + " args";
                if (exception != null) {
                    logger.error(error, (Throwable)exception);
                } else {
                    logger.error(error);
                }
                throw new InitializationException(error);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private Entropy() {
    }
}

