/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.generics;

import dorkbox.util.generics.TypeResolver;
import java.lang.reflect.Type;

public final class ClassHelper {
    public static Class<?> getGenericParameterAsClassForSuperClass(Class<?> clazz, Class<?> subClazz, int genericParameterToGet) {
        Class<?> classToCheck = subClazz;
        Class<?>[] classes = TypeResolver.resolveRawArguments(clazz, classToCheck);
        if (classes.length > genericParameterToGet && classes[genericParameterToGet] != TypeResolver.Unknown.class) {
            return classes[genericParameterToGet];
        }
        while (classToCheck != Object.class) {
            Type superClassGeneric = classToCheck.getGenericSuperclass();
            classes = TypeResolver.resolveRawArguments(superClassGeneric, classToCheck);
            if (classes.length > genericParameterToGet && classes[genericParameterToGet] != TypeResolver.Unknown.class) {
                return classes[genericParameterToGet];
            }
            classToCheck = classToCheck.getSuperclass();
        }
        for (classToCheck = subClazz; classToCheck != Object.class; classToCheck = classToCheck.getSuperclass()) {
            Type[] genericInterfaces;
            for (Type genericInterface : genericInterfaces = classToCheck.getGenericInterfaces()) {
                classes = TypeResolver.resolveRawArguments(genericInterface, classToCheck);
                if (classes.length <= genericParameterToGet || classes[genericParameterToGet] == TypeResolver.Unknown.class) continue;
                return classes[genericParameterToGet];
            }
        }
        return null;
    }

    public static boolean hasInterface(Class<?> requiredClass, Class<?> clazz) {
        Class<?>[] interfaces;
        if (requiredClass == clazz) {
            return true;
        }
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            if (iface != requiredClass) continue;
            return true;
        }
        for (Class<?> iface : interfaces) {
            boolean b = ClassHelper.hasInterface(requiredClass, iface);
            if (!b) continue;
            return b;
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            if (!ClassHelper.hasInterface(requiredClass, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParentClass(Class<?> parentClazz, Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        if (parentClazz == superClass) {
            return true;
        }
        if (superClass != null && superClass != Object.class) {
            return ClassHelper.hasParentClass(parentClazz, superClass);
        }
        return false;
    }

    private ClassHelper() {
    }
}

