/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.storage;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.minlog.Log;
import dorkbox.util.serialization.SerializationManager;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.slf4j.Logger;

class DefaultStorageSerializationManager
implements SerializationManager {
    private Kryo kryo = new Kryo(){
        {
            Log.set((int)5);
        }
    };

    DefaultStorageSerializationManager() {
    }

    @Override
    public SerializationManager register(Class<?> clazz) {
        this.kryo.register(clazz);
        return this;
    }

    @Override
    public SerializationManager register(Class<?> clazz, int id) {
        this.kryo.register(clazz, id);
        return this;
    }

    @Override
    public SerializationManager register(Class<?> clazz, Serializer<?> serializer) {
        this.kryo.register(clazz, serializer);
        return this;
    }

    @Override
    public SerializationManager register(Class<?> type, Serializer<?> serializer, int id) {
        this.kryo.register(type, serializer, id);
        return this;
    }

    @Override
    public void write(ByteBuf buffer, Object message) {
        Output output = new Output();
        this.writeFullClassAndObject(output, message);
        buffer.writeBytes(output.getBuffer());
    }

    @Override
    public Object read(ByteBuf buffer, int length) throws IOException {
        Input input = new Input();
        buffer.readBytes(input.getBuffer());
        Object o = this.readFullClassAndObject(input);
        buffer.skipBytes(input.position());
        return o;
    }

    @Override
    public void writeFullClassAndObject(Output output, Object value) {
        this.kryo.writeClassAndObject(output, value);
    }

    @Override
    public Object readFullClassAndObject(Input input) throws IOException {
        return this.kryo.readClassAndObject(input);
    }

    @Override
    public void finishInit(Logger logger, Logger writeLogger) {
    }

    @Override
    public boolean initialized() {
        return false;
    }
}

