/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.storage;

import dorkbox.util.DelayTimer;
import dorkbox.util.serialization.SerializationManager;
import dorkbox.util.storage.Storage;
import dorkbox.util.storage.StorageBase;
import dorkbox.util.storage.StorageKey;
import dorkbox.util.storage.StorageSystem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;

class DiskStorage
implements Storage {
    private final DelayTimer timer;
    private volatile HashMap<StorageKey, Object> actionMap = new HashMap();
    private final Object singleWriterLock = new Object[0];
    private static final AtomicReferenceFieldUpdater<DiskStorage, HashMap> actionMapREF = AtomicReferenceFieldUpdater.newUpdater(DiskStorage.class, HashMap.class, "actionMap");
    private final StorageBase storage;
    private final AtomicInteger references = new AtomicInteger(1);
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final long milliSeconds;

    DiskStorage(File storageFile, SerializationManager serializationManager, boolean readOnly, long saveDelayInMilliseconds, Logger logger) throws IOException {
        this.storage = new StorageBase(storageFile, serializationManager, logger);
        this.milliSeconds = saveDelayInMilliseconds;
        this.timer = readOnly ? null : new DelayTimer("Storage Writer", false, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap actions;
                Object object = DiskStorage.this.singleWriterLock;
                synchronized (object) {
                    actions = DiskStorage.this.actionMap;
                    DiskStorage.this.actionMap = new HashMap();
                }
                DiskStorage.this.storage.doActionThings(actions);
            }
        });
        this.isOpen.set(true);
    }

    @Override
    public final int size() {
        if (!this.isOpen.get()) {
            throw new RuntimeException("Unable to act on closed storage");
        }
        if (this.timer != null) {
            this.timer.delay(0L);
        }
        return this.storage.size();
    }

    @Override
    public final boolean contains(StorageKey key) {
        if (!this.isOpen.get()) {
            throw new RuntimeException("Unable to act on closed storage");
        }
        HashMap actionMap = actionMapREF.get(this);
        return actionMap.containsKey(key) || this.storage.contains(key);
    }

    @Override
    public final <T> T get(StorageKey key) {
        return this.get0(key);
    }

    @Override
    public <T> T get(StorageKey key, T data) {
        Class<?> savedCLass;
        T source = this.get0(key);
        if (source == null) {
            this.put(key, data);
            return data;
        }
        Class<?> expectedClass = data.getClass();
        if (!expectedClass.isAssignableFrom(savedCLass = source.getClass())) {
            String message = "Saved value type '" + savedCLass + "' is different than expected value '" + expectedClass + "'";
            if (this.storage.logger != null) {
                this.storage.logger.error(message);
            } else {
                System.err.print(message);
            }
            return null;
        }
        return source;
    }

    private <T> T get0(StorageKey key) {
        if (!this.isOpen.get()) {
            throw new RuntimeException("Unable to act on closed storage");
        }
        HashMap actionMap = actionMapREF.get(this);
        Object object = actionMap.get(key);
        if (object != null) {
            Object returnObject = object;
            return (T)returnObject;
        }
        return this.storage.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(StorageKey key, Object object) {
        if (!this.isOpen.get()) {
            throw new RuntimeException("Unable to act on closed storage");
        }
        if (this.timer != null) {
            Object object2 = this.singleWriterLock;
            synchronized (object2) {
                this.actionMap.put(key, object);
            }
        } else {
            throw new RuntimeException("Unable to put on a read-only storage");
        }
        this.timer.delay(this.milliSeconds);
    }

    @Override
    public final boolean delete(StorageKey key) {
        if (!this.isOpen.get()) {
            throw new RuntimeException("Unable to act on closed storage");
        }
        if (this.timer != null) {
            this.timer.delay(0L);
            return this.storage.delete(key);
        }
        throw new RuntimeException("Unable to delete on a read-only storage");
    }

    @Override
    public void close() {
        StorageSystem.close(this);
    }

    void closeFully() {
        if (this.timer != null) {
            this.timer.delay(0L);
        }
        this.isOpen.set(false);
        this.storage.close();
    }

    @Override
    public final File getFile() {
        return this.storage.getFile();
    }

    @Override
    public final long getFileSize() {
        if (this.timer != null) {
            this.timer.delay(0L);
        }
        return this.storage.getFileSize();
    }

    @Override
    public final boolean hasWriteWaiting() {
        if (!this.isOpen.get()) {
            throw new RuntimeException("Unable to act on closed storage");
        }
        if (this.timer != null) {
            return this.timer.isWaiting();
        }
        return false;
    }

    @Override
    public final long getSaveDelay() {
        return this.milliSeconds;
    }

    @Override
    public final int getVersion() {
        return this.storage.getVersion();
    }

    @Override
    public final void setVersion(int version) {
        this.storage.setVersion(version);
    }

    void increaseReference() {
        this.references.incrementAndGet();
    }

    boolean decrementReference() {
        return this.references.decrementAndGet() <= 0;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public final void save() {
        if (!this.isOpen.get()) {
            throw new RuntimeException("Unable to act on closed storage");
        }
        if (this.timer == null) {
            throw new RuntimeException("Unable to save on a read-only storage");
        }
        this.timer.delay(0L);
    }
}

