/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.storage;

import dorkbox.util.storage.Storage;
import dorkbox.util.storage.StorageKey;
import dorkbox.util.storage.StorageSystem;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class MemoryStorage
implements Storage {
    private volatile HashMap<StorageKey, Object> storage = new HashMap();
    private final Object singleWriterLock = new Object[0];
    private static final AtomicReferenceFieldUpdater<MemoryStorage, HashMap> storageREF = AtomicReferenceFieldUpdater.newUpdater(MemoryStorage.class, HashMap.class, "storage");
    private int version;

    MemoryStorage() {
    }

    @Override
    public int size() {
        HashMap storage = storageREF.get(this);
        return storage.size();
    }

    @Override
    public boolean contains(StorageKey key) {
        HashMap storage = storageREF.get(this);
        return storage.containsKey(key);
    }

    @Override
    public <T> T get(StorageKey key) {
        HashMap storage = storageREF.get(this);
        return (T)storage.get(key);
    }

    @Override
    public <T> T get(StorageKey key, T data) {
        HashMap storage = storageREF.get(this);
        Object o = storage.get(key);
        if (o == null) {
            storage.put(key, data);
            return data;
        }
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(StorageKey key, Object object) {
        Object object2 = this.singleWriterLock;
        synchronized (object2) {
            this.storage.put(key, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean delete(StorageKey key) {
        Object object = this.singleWriterLock;
        synchronized (object) {
            this.storage.remove(key);
        }
        return true;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public long getFileSize() {
        return 0L;
    }

    @Override
    public boolean hasWriteWaiting() {
        return false;
    }

    @Override
    public long getSaveDelay() {
        return 0L;
    }

    @Override
    public synchronized int getVersion() {
        return this.version;
    }

    @Override
    public synchronized void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void save() {
    }

    @Override
    public void close() {
        StorageSystem.close(this);
    }
}

