/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.storage;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.util.OS;
import dorkbox.util.serialization.SerializationManager;
import dorkbox.util.storage.Metadata;
import dorkbox.util.storage.StorageKey;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.Channels;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

class StorageBase {
    protected final Logger logger;
    private static final long VERSION_HEADER_LOCATION = 0L;
    private static final long NUM_RECORDS_HEADER_LOCATION = 4L;
    private static final long DATA_START_HEADER_LOCATION = 8L;
    static final int FILE_HEADERS_REGION_LENGTH = 16;
    private volatile HashMap<StorageKey, Metadata> memoryIndex;
    private final Object singleWriterLock = new Object[0];
    private static final AtomicReferenceFieldUpdater<StorageBase, HashMap> memoryREF = AtomicReferenceFieldUpdater.newUpdater(StorageBase.class, HashMap.class, "memoryIndex");
    private final Float weight;
    private final ReentrantLock referenceLock = new ReentrantLock();
    private final File baseFile;
    private final RandomAccessFile randomAccessFile;
    private int databaseVersion = 0;
    private int numberOfRecords;
    private long dataPosition;
    private final SerializationManager serializationManager;
    private final Output output;
    private final Input input;
    private static final int BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StorageBase(File filePath, SerializationManager serializationManager, Logger logger) throws IOException {
        File parentFile;
        boolean newStorage;
        this.serializationManager = serializationManager;
        this.logger = logger;
        if (logger != null) {
            logger.info("Opening storage file: '{}'", (Object)filePath.getAbsolutePath());
        }
        this.baseFile = filePath;
        boolean bl = newStorage = !filePath.exists();
        if (newStorage && (parentFile = this.baseFile.getParentFile()) != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Unable to create dirs for: " + filePath);
        }
        this.randomAccessFile = new RandomAccessFile(this.baseFile, "rw");
        if (newStorage || this.randomAccessFile.length() <= 16L) {
            this.setVersion(this.randomAccessFile, 0);
            this.setRecordCount(this.randomAccessFile, 0);
            long indexPointer = Metadata.getMetaDataPointer(21);
            this.setDataStartPosition(indexPointer);
            this.randomAccessFile.setLength(indexPointer);
        } else {
            this.randomAccessFile.seek(0L);
            this.databaseVersion = this.randomAccessFile.readInt();
            this.numberOfRecords = this.randomAccessFile.readInt();
            this.dataPosition = this.randomAccessFile.readLong();
            if (this.randomAccessFile.length() < this.dataPosition) {
                if (logger != null) {
                    logger.error("Corrupted storage file!");
                }
                throw new IllegalArgumentException("Unable to parse header information from storage. Maybe it's corrupted?");
            }
        }
        if (logger != null) {
            logger.info("Storage version: {}", (Object)this.databaseVersion);
        }
        InputStream inputStream = Channels.newInputStream(this.randomAccessFile.getChannel());
        OutputStream outputStream = Channels.newOutputStream(this.randomAccessFile.getChannel());
        this.output = new Output(outputStream, 1024);
        this.input = new Input(inputStream, 1024);
        this.weight = Float.valueOf(0.5f);
        Object object = this.singleWriterLock;
        synchronized (object) {
            this.memoryIndex = new HashMap(this.numberOfRecords);
            if (!newStorage) {
                Metadata meta;
                for (int index = 0; index < this.numberOfRecords && (meta = Metadata.readHeader(this.randomAccessFile, index)) != null; ++index) {
                    this.memoryIndex.put(meta.key, meta);
                }
                if (this.memoryIndex.size() != this.numberOfRecords) {
                    this.setRecordCount(this.randomAccessFile, this.memoryIndex.size());
                    if (logger != null) {
                        logger.warn("Mismatch record count in storage, auto-correcting size.");
                    }
                }
            }
        }
    }

    final int size() {
        HashMap memoryIndex = memoryREF.get(this);
        return memoryIndex.size();
    }

    final boolean contains(StorageKey key) {
        HashMap memoryIndex = memoryREF.get(this);
        return memoryIndex.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T getCached(StorageKey key) {
        HashMap memoryIndex = memoryREF.get(this);
        Metadata meta = (Metadata)memoryIndex.get(key);
        if (meta == null) {
            return null;
        }
        try {
            this.referenceLock.lock();
            WeakReference<Object> ref = meta.objectReferenceCache;
            if (ref != null) {
                Object referenceObject;
                Object t = referenceObject = ref.get();
                return t;
            }
        }
        finally {
            this.referenceLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T get(StorageKey key) {
        HashMap memoryIndex = memoryREF.get(this);
        Metadata meta = (Metadata)memoryIndex.get(key);
        if (meta == null) {
            return null;
        }
        try {
            this.referenceLock.lock();
            WeakReference<Object> ref = meta.objectReferenceCache;
            if (ref != null) {
                Object referenceObject;
                Object t = referenceObject = ref.get();
                return t;
            }
        }
        finally {
            this.referenceLock.unlock();
        }
        try {
            this.randomAccessFile.seek(meta.dataPointer);
            Object readRecordData = Metadata.readData(this.serializationManager, this.input);
            if (readRecordData != null) {
                try {
                    this.referenceLock.lock();
                    meta.objectReferenceCache = new WeakReference(readRecordData);
                }
                finally {
                    this.referenceLock.unlock();
                }
            }
            return readRecordData;
        }
        catch (Exception e) {
            String message = e.getMessage();
            int index = message.indexOf(OS.LINE_SEPARATOR);
            if (index > -1) {
                message = message.substring(0, index);
            }
            if (this.logger != null) {
                this.logger.error("Error reading data from disk: {}", (Object)message);
            } else {
                System.err.print("Error reading data from disk: " + message);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean delete(StorageKey key) {
        Object object = this.singleWriterLock;
        synchronized (object) {
            Metadata delRec = this.memoryIndex.get(key);
            try {
                this.deleteRecordData(delRec, delRec.dataCapacity);
                int currentNumRecords = this.memoryIndex.size();
                if (delRec.indexPosition != currentNumRecords - 1) {
                    Metadata last = Metadata.readHeader(this.randomAccessFile, currentNumRecords - 1);
                    assert (last != null);
                    last.moveRecord(this.randomAccessFile, delRec.indexPosition);
                }
                this.memoryIndex.remove(key);
                this.setRecordCount(this.randomAccessFile, currentNumRecords - 1);
                return true;
            }
            catch (IOException e) {
                if (this.logger != null) {
                    this.logger.error("Error while deleting data from disk", (Throwable)e);
                } else {
                    e.printStackTrace();
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        if (this.logger != null) {
            this.logger.info("Closing storage file: '{}'", (Object)this.baseFile.getAbsolutePath());
        }
        try {
            this.randomAccessFile.getFD().sync();
            this.input.close();
            this.randomAccessFile.close();
            Object object = this.singleWriterLock;
            synchronized (object) {
                this.memoryIndex.clear();
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.error("Error while closing the file", (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    long getFileSize() {
        try {
            return this.randomAccessFile.length();
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.error("Error getting file size for {}", (Object)this.baseFile.getAbsolutePath(), (Object)e);
            } else {
                e.printStackTrace();
            }
            return -1L;
        }
    }

    final File getFile() {
        return this.baseFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save0(StorageKey key, Object object) {
        Object object2 = this.singleWriterLock;
        synchronized (object2) {
            block15: {
                Metadata metaData = this.memoryIndex.get(key);
                int currentRecordCount = this.numberOfRecords;
                if (metaData != null) {
                    try {
                        if (currentRecordCount == 1) {
                            int sizeOfWrittenData;
                            FileLock lock = this.randomAccessFile.getChannel().lock(this.dataPosition, Long.MAX_VALUE - this.dataPosition, false);
                            this.randomAccessFile.seek(this.dataPosition);
                            Metadata.writeData(this.serializationManager, object, this.output);
                            metaData.dataCapacity = sizeOfWrittenData = (int)(this.randomAccessFile.length() - this.dataPosition);
                            metaData.dataCount = sizeOfWrittenData;
                            lock.release();
                        } else {
                            ByteArrayOutputStream dataStream = StorageBase.getDataAsByteArray(this.serializationManager, object);
                            int size = dataStream.size();
                            if (size > metaData.dataCapacity) {
                                this.deleteRecordData(metaData, size);
                                metaData.dataPointer = this.randomAccessFile.length();
                                metaData.dataCapacity = size;
                                metaData.dataCount = 0;
                            }
                            metaData.writeDataRaw(dataStream, this.randomAccessFile);
                        }
                        metaData.writeDataInfo(this.randomAccessFile);
                    }
                    catch (IOException e) {
                        if (this.logger != null) {
                            this.logger.error("Error while saving data to disk", (Throwable)e);
                            break block15;
                        }
                        e.printStackTrace();
                    }
                } else {
                    try {
                        this.setRecordCount(this.randomAccessFile, currentRecordCount + 1);
                        this.ensureIndexCapacity(this.randomAccessFile);
                        long length = this.randomAccessFile.length();
                        metaData = new Metadata(key, currentRecordCount, length);
                        metaData.writeMetaDataInfo(this.randomAccessFile);
                        this.memoryIndex.put(key, metaData);
                        FileLock lock = this.randomAccessFile.getChannel().lock(0L, Long.MAX_VALUE, false);
                        this.randomAccessFile.seek(length);
                        int total = Metadata.writeData(this.serializationManager, object, this.output);
                        lock.release();
                        metaData.dataCount = metaData.dataCapacity = total;
                        metaData.writeDataInfo(this.randomAccessFile);
                    }
                    catch (IOException e) {
                        if (this.logger != null) {
                            this.logger.error("Error while writing data to disk", (Throwable)e);
                        } else {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
            }
        }
        metaData.objectReferenceCache = new WeakReference<Object>(object);
    }

    private static ByteArrayOutputStream getDataAsByteArray(SerializationManager serializationManager, Object data) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)outputStream, 1024);
        serializationManager.writeFullClassAndObject(output, data);
        output.flush();
        outputStream.flush();
        outputStream.close();
        return outputStream;
    }

    void doActionThings(Map<StorageKey, Object> actions) {
        Set<Map.Entry<StorageKey, Object>> entries = actions.entrySet();
        for (Map.Entry<StorageKey, Object> entry : entries) {
            StorageKey key = entry.getKey();
            Object object = entry.getValue();
            this.save0(key, object);
        }
    }

    private int getWeightedNewRecordCount(int numberOfRecords) {
        return numberOfRecords + 1 + (int)((float)numberOfRecords * this.weight.floatValue());
    }

    private void deleteRecordData(Metadata deletedRecord, int sizeOfDataToAdd) throws IOException {
        if (this.randomAccessFile.length() == deletedRecord.dataPointer + (long)deletedRecord.dataCapacity) {
            FileLock lock = this.randomAccessFile.getChannel().lock(deletedRecord.dataPointer, Long.MAX_VALUE - deletedRecord.dataPointer, false);
            this.randomAccessFile.setLength(deletedRecord.dataPointer);
            lock.release();
        } else {
            Metadata first = this.index_getMetaDataFromData(this.dataPosition);
            if (first == deletedRecord) {
                int numberOfRecords = this.numberOfRecords;
                int newNumberOfRecords = this.getWeightedNewRecordCount(numberOfRecords);
                long endIndexPointer = Metadata.getMetaDataPointer(newNumberOfRecords);
                long endOfDataPointer = deletedRecord.dataPointer + (long)deletedRecord.dataCapacity;
                long newEndOfDataPointer = endOfDataPointer - (long)sizeOfDataToAdd;
                if (endIndexPointer < this.dataPosition && endIndexPointer <= newEndOfDataPointer) {
                    this.setDataStartPosition(newEndOfDataPointer);
                } else {
                    this.setDataStartPosition(endOfDataPointer);
                }
            } else {
                Metadata previous = this.index_getMetaDataFromData(deletedRecord.dataPointer - 1L);
                if (previous != null) {
                    previous.dataCapacity += deletedRecord.dataCapacity;
                    previous.writeDataInfo(this.randomAccessFile);
                } else if (this.logger != null) {
                    this.logger.error("Trying to delete an object, and it's in a weird state");
                } else {
                    System.err.println("Trying to delete an object, and it's in a weird state");
                }
            }
        }
    }

    private void setVersion(RandomAccessFile file, int versionNumber) throws IOException {
        this.databaseVersion = versionNumber;
        FileLock lock = this.randomAccessFile.getChannel().lock(0L, 4L, false);
        file.seek(0L);
        file.writeInt(versionNumber);
        lock.release();
    }

    private void setRecordCount(RandomAccessFile file, int numberOfRecords) throws IOException {
        if (this.numberOfRecords != numberOfRecords) {
            this.numberOfRecords = numberOfRecords;
            FileLock lock = this.randomAccessFile.getChannel().lock(4L, 4L, false);
            file.seek(4L);
            file.writeInt(numberOfRecords);
            lock.release();
        }
    }

    private void setDataStartPosition(long dataPositionPointer) throws IOException {
        FileLock lock = this.randomAccessFile.getChannel().lock(8L, 8L, false);
        this.dataPosition = dataPositionPointer;
        this.randomAccessFile.seek(8L);
        this.randomAccessFile.writeLong(dataPositionPointer);
        lock.release();
    }

    int getVersion() {
        return this.databaseVersion;
    }

    void setVersion(int versionNumber) {
        try {
            this.setVersion(this.randomAccessFile, versionNumber);
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.error("Unable to set the version number", (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    private Metadata index_getMetaDataFromData(long targetFp) {
        HashMap memoryIndex = memoryREF.get(this);
        for (Metadata next : memoryIndex.values()) {
            if (targetFp < next.dataPointer || targetFp >= next.dataPointer + (long)next.dataCapacity) continue;
            return next;
        }
        return null;
    }

    private void ensureIndexCapacity(RandomAccessFile file) throws IOException {
        int numberOfRecords = this.numberOfRecords;
        long endIndexPointer = Metadata.getMetaDataPointer(numberOfRecords + 1);
        if (endIndexPointer > file.length() && numberOfRecords == 0) {
            file.setLength(endIndexPointer);
            this.setDataStartPosition(endIndexPointer);
            return;
        }
        long readDataPosition = this.dataPosition;
        if (endIndexPointer < readDataPosition) {
            return;
        }
        int newNumberOfRecords = this.getWeightedNewRecordCount(numberOfRecords);
        endIndexPointer = Metadata.getMetaDataPointer(newNumberOfRecords);
        if (endIndexPointer > file.length()) {
            file.setLength(endIndexPointer);
        } else {
            endIndexPointer = file.length();
        }
        this.setDataStartPosition(endIndexPointer);
        long writeDataPosition = endIndexPointer;
        while (endIndexPointer > readDataPosition && numberOfRecords > 0) {
            Metadata first = this.index_getMetaDataFromData(readDataPosition);
            if (first == null) {
                readDataPosition += 48L;
                continue;
            }
            first.moveData(file, writeDataPosition);
            int dataCapacity = first.dataCapacity;
            readDataPosition += (long)dataCapacity;
            writeDataPosition += (long)dataCapacity;
            --numberOfRecords;
        }
    }
}

