/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.DatagramSessionChannelConfig;
import io.netty.bootstrap.SessionManager;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.RecyclableArrayList;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class DatagramSessionChannel
extends AbstractChannel
implements Channel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private final DatagramSessionChannelConfig config;
    private SessionManager sessionManager;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private volatile boolean isOpen = true;

    DatagramSessionChannel(Channel parentChannel, SessionManager sessionManager, DatagramSessionChannelConfig sessionConfig, InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        super(parentChannel);
        this.sessionManager = sessionManager;
        this.config = sessionConfig;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
    }

    public ChannelConfig config() {
        return this.config;
    }

    protected void doBeginRead() throws Exception {
    }

    protected void doBind(SocketAddress addr) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doClose() throws Exception {
        this.isOpen = false;
        this.sessionManager.doCloseChannel(this);
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(ChannelOutboundBuffer buffer) throws Exception {
        final RecyclableArrayList list = RecyclableArrayList.newInstance();
        boolean free = true;
        try {
            Object buf = null;
            while ((buf = (DatagramPacket)buffer.current()) != null) {
                list.add((Object)buf.retain());
                buffer.remove();
            }
            free = false;
        }
        finally {
            if (free) {
                for (Object obj : list) {
                    ReferenceCountUtil.safeRelease(obj);
                }
                list.recycle();
            }
        }
        EventLoop eventLoop = this.parent().eventLoop();
        if (eventLoop.inEventLoop()) {
            this.write0(list);
        } else {
            eventLoop.submit(new Runnable(){

                @Override
                public void run() {
                    DatagramSessionChannel.this.write0(list);
                }
            });
        }
    }

    public boolean isActive() {
        return this.isOpen;
    }

    protected boolean isCompatible(EventLoop eventloop) {
        return true;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.localAddress0();
    }

    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new ChannelUnsafe();
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    protected InetSocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write0(RecyclableArrayList list) {
        try {
            Channel.Unsafe unsafe = super.parent().unsafe();
            for (Object buf : list) {
                unsafe.write(buf, this.voidPromise());
            }
            unsafe.flush();
        }
        finally {
            list.recycle();
        }
    }

    private class ChannelUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private ChannelUnsafe() {
            super((AbstractChannel)DatagramSessionChannel.this);
        }

        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            channelPromise.setFailure((Throwable)new UnsupportedOperationException());
        }
    }
}

