/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.SessionBootstrapConfig;
import io.netty.bootstrap.SessionManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public class SessionBootstrap
extends AbstractBootstrap<SessionBootstrap, Channel> {
    private static final AddressResolverGroup<?> DEFAULT_RESOLVER = DefaultAddressResolverGroup.INSTANCE;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SessionBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new LinkedHashMap();
    private final SessionBootstrapConfig config = new SessionBootstrapConfig(this);
    private volatile EventLoopGroup childGroup;
    private volatile ChannelHandler childHandler;
    private volatile AddressResolverGroup<SocketAddress> resolver = DEFAULT_RESOLVER;
    private final int tcpPort;
    private final int udpPort;

    private static Map.Entry<AttributeKey<?>, Object>[] newAttrArray(int size) {
        return new Map.Entry[size];
    }

    private static Map.Entry<ChannelOption<?>, Object>[] newOptionArray(int size) {
        return new Map.Entry[size];
    }

    public SessionBootstrap(int tcpPort, int udpPort) {
        this.tcpPort = tcpPort;
        this.udpPort = udpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionBootstrap(SessionBootstrap bootstrap) {
        super((AbstractBootstrap)bootstrap);
        this.resolver = bootstrap.resolver;
        this.childGroup = bootstrap.childGroup;
        this.childHandler = bootstrap.childHandler;
        Map<ChannelOption<?>, Object> map = bootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(bootstrap.childOptions);
        }
        map = bootstrap.childAttrs;
        synchronized (map) {
            this.childAttrs.putAll(bootstrap.childAttrs);
        }
        this.tcpPort = bootstrap.tcpPort;
        this.udpPort = bootstrap.udpPort;
    }

    public <T> SessionBootstrap childAttr(AttributeKey<T> childKey, T value) {
        if (childKey == null) {
            throw new NullPointerException("childKey");
        }
        if (value == null) {
            this.childAttrs.remove(childKey);
        } else {
            this.childAttrs.put(childKey, value);
        }
        return this;
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return SessionBootstrap.copiedMap(this.childAttrs);
    }

    @Deprecated
    public EventLoopGroup childGroup() {
        return this.childGroup;
    }

    public SessionBootstrap childHandler(ChannelHandler childHandler) {
        if (childHandler == null) {
            throw new NullPointerException("childHandler");
        }
        this.childHandler = childHandler;
        return this;
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SessionBootstrap childOption(ChannelOption<T> childOption, T value) {
        if (childOption == null) {
            throw new NullPointerException("childOption");
        }
        if (value == null) {
            Map<ChannelOption<?>, Object> map = this.childOptions;
            synchronized (map) {
                this.childOptions.remove(childOption);
            }
        }
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            this.childOptions.put(childOption, value);
        }
        return this;
    }

    final Map<ChannelOption<?>, Object> childOptions() {
        return SessionBootstrap.copiedMap(this.childOptions);
    }

    public SessionBootstrap clone() {
        return new SessionBootstrap(this);
    }

    public final SessionBootstrapConfig config() {
        return this.config;
    }

    public SessionBootstrap group(EventLoopGroup group) {
        return this.group(group, group);
    }

    public SessionBootstrap group(EventLoopGroup parentGroup, EventLoopGroup childGroup) {
        super.group(parentGroup);
        if (childGroup == null) {
            throw new NullPointerException("childGroup");
        }
        if (this.childGroup != null) {
            throw new IllegalStateException("childGroup set already");
        }
        this.childGroup = childGroup;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Channel channel) throws Exception {
        Map.Entry[] currentChildAttrs;
        Map.Entry[] currentChildOptions;
        Map attrs;
        Map options;
        Map map = options = this.options0();
        synchronized (map) {
            SessionBootstrap.setChannelOptions((Channel)channel, (Map)options, (InternalLogger)logger);
        }
        Map map2 = attrs = this.attrs0();
        synchronized (map2) {
            for (Map.Entry e : attrs.entrySet()) {
                AttributeKey key = (AttributeKey)e.getKey();
                channel.attr(key).set(e.getValue());
            }
        }
        ChannelPipeline p = channel.pipeline();
        final EventLoopGroup currentChildGroup = this.childGroup;
        final ChannelHandler currentChildHandler = this.childHandler;
        Map<ChannelOption<?>, Object> map3 = this.childOptions;
        synchronized (map3) {
            currentChildOptions = this.childOptions.entrySet().toArray(SessionBootstrap.newOptionArray(this.childOptions.size()));
        }
        map3 = this.childAttrs;
        synchronized (map3) {
            currentChildAttrs = this.childAttrs.entrySet().toArray(SessionBootstrap.newAttrArray(this.childAttrs.size()));
        }
        p.addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            public void initChannel(final Channel ch) throws Exception {
                final ChannelPipeline pipeline = ch.pipeline();
                ChannelHandler handler = SessionBootstrap.this.config.handler();
                if (handler != null) {
                    pipeline.addLast(new ChannelHandler[]{handler});
                }
                ch.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        pipeline.addLast(new ChannelHandler[]{new SessionManager(SessionBootstrap.this.tcpPort, SessionBootstrap.this.udpPort, ch, currentChildGroup, currentChildHandler, currentChildOptions, currentChildAttrs)});
                    }
                });
            }
        }});
    }

    public SocketAddress remoteAddress() {
        return null;
    }

    public AddressResolverGroup<?> resolver() {
        return this.resolver;
    }

    public SessionBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.childGroup == null) {
            logger.warn("childGroup is not set. Using parentGroup instead.");
            this.childGroup = this.config.group();
        }
        return this;
    }
}

