/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import dorkbox.network.pipeline.discovery.BroadcastServer;
import dorkbox.util.bytes.BigEndian;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.DatagramSessionChannel;
import io.netty.bootstrap.DatagramSessionChannelConfig;
import io.netty.bootstrap.SessionBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.AttributeKey;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SessionManager
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SessionBootstrap.class);
    private final BroadcastServer broadcastServer;
    private final LongObjectHashMap<DatagramSessionChannel> datagramChannels = new LongObjectHashMap();
    private final EventLoopGroup childGroup;
    private final ChannelHandler childHandler;
    private final Map.Entry<ChannelOption<?>, Object>[] childOptions;
    private final Map.Entry<AttributeKey<?>, Object>[] childAttrs;
    private final Runnable enableAutoReadTask;
    private final DatagramSessionChannelConfig sessionConfig;

    private static void forceClose(DatagramSessionChannel child, Throwable t) throws Exception {
        child.unsafe().closeForcibly();
        child.doClose();
        logger.warn("Failed to register an accepted channel: {}", (Object)child, (Object)t);
    }

    private static long getChannelId(InetSocketAddress remoteAddress) {
        int address = remoteAddress.getAddress().hashCode();
        int port = remoteAddress.getPort();
        byte[] combined = new byte[]{(byte)(port >>> 24 & 0xFF), (byte)(port >>> 16 & 0xFF), (byte)(port >>> 8 & 0xFF), (byte)(port & 0xFF), (byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
        return BigEndian.Long_.from(combined);
    }

    SessionManager(int tcpPort, int udpPort, final Channel channel, EventLoopGroup childGroup, ChannelHandler childHandler, Map.Entry<ChannelOption<?>, Object>[] childOptions, Map.Entry<AttributeKey<?>, Object>[] childAttrs) {
        this.sessionConfig = new DatagramSessionChannelConfig(channel);
        this.childGroup = childGroup;
        this.childHandler = childHandler;
        this.childOptions = childOptions;
        this.childAttrs = childAttrs;
        this.enableAutoReadTask = new Runnable(){

            @Override
            public void run() {
                channel.config().setAutoRead(true);
            }
        };
        this.broadcastServer = new BroadcastServer(tcpPort, udpPort);
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        super.channelInactive(context);
        ArrayList channels = new ArrayList(this.datagramChannels.values());
        for (DatagramSessionChannel channel : channels) {
            if (!channel.isActive() || channel.eventLoop().isShutdown()) continue;
            channel.close();
        }
    }

    public void channelRead(ChannelHandlerContext context, Object msg) {
        ChannelPipeline sessionPipeline;
        InetSocketAddress remoteAddress;
        InetSocketAddress localAddress;
        DatagramPacket packet;
        ByteBuf content;
        Channel channel = context.channel();
        if (this.broadcastServer.isDiscoveryRequest(channel, content = (ByteBuf)(packet = (DatagramPacket)msg).content(), localAddress = (InetSocketAddress)packet.recipient(), remoteAddress = (InetSocketAddress)packet.sender())) {
            return;
        }
        long channelId = SessionManager.getChannelId(remoteAddress);
        DatagramSessionChannel sessionChannel = (DatagramSessionChannel)((Object)this.datagramChannels.get(channelId));
        if (sessionChannel == null) {
            try {
                sessionChannel = new DatagramSessionChannel(context.channel(), this, this.sessionConfig, localAddress, remoteAddress);
                this.datagramChannels.put(channelId, (Object)sessionChannel);
                sessionPipeline = sessionChannel.pipeline();
                sessionPipeline.addLast(new ChannelHandler[]{this.childHandler});
                AbstractBootstrap.setChannelOptions((Channel)sessionChannel, (Map.Entry[])this.childOptions, (InternalLogger)logger);
                for (Map.Entry<AttributeKey<?>, Object> e : this.childAttrs) {
                    sessionChannel.attr(e.getKey()).set(e.getValue());
                }
                try {
                    final DatagramSessionChannel finalSessionChannel = sessionChannel;
                    this.childGroup.register((Channel)sessionChannel).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                SessionManager.forceClose(finalSessionChannel, future.cause());
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    SessionManager.forceClose(sessionChannel, t);
                }
            }
            catch (Throwable t) {
                logger.warn("Failed to create a new datagram channel from a read operation.", t);
                try {
                    if (sessionChannel != null) {
                        sessionChannel.close();
                    }
                }
                catch (Throwable t2) {
                    logger.warn("Failed to close the datagram channel.", t2);
                }
                return;
            }
        } else {
            sessionPipeline = sessionChannel.pipeline();
        }
        sessionPipeline.fireChannelRead((Object)packet);
        sessionPipeline.fireChannelReadComplete();
    }

    public void doCloseChannel(DatagramSessionChannel datagramSessionChannel) {
        InetSocketAddress remoteAddress = datagramSessionChannel.remoteAddress();
        long channelId = SessionManager.getChannelId(remoteAddress);
        this.datagramChannels.remove(channelId);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ChannelConfig config = ctx.channel().config();
        if (config.isAutoRead()) {
            config.setAutoRead(false);
            ctx.channel().eventLoop().schedule(this.enableAutoReadTask, 1L, TimeUnit.SECONDS);
        }
        ctx.fireExceptionCaught(cause);
    }
}

