/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.aspect;

import com.epam.reportportal.annotations.Step;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.aspect.StepNameUtils;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class StepRequestUtils {
    private StepRequestUtils() {
    }

    @Nonnull
    public static StartTestItemRQ buildStartStepRequest(@Nonnull String name, @Nullable String description, @Nonnull MethodSignature signature) {
        StartTestItemRQ request = com.epam.reportportal.service.step.StepRequestUtils.buildStartStepRequest(name, description);
        request.setAttributes(StepRequestUtils.createStepAttributes(signature));
        return request;
    }

    @Nonnull
    public static StartTestItemRQ buildStartStepRequest(@Nonnull MethodSignature signature, @Nonnull Step step, @Nonnull JoinPoint joinPoint) {
        String name = StepNameUtils.getStepName(step, signature, joinPoint);
        return StepRequestUtils.buildStartStepRequest(name, step.description(), signature);
    }

    @Nullable
    private static Set<ItemAttributesRQ> createStepAttributes(@Nonnull MethodSignature methodSignature) {
        Attributes attributesAnnotation = methodSignature.getMethod().getAnnotation(Attributes.class);
        if (attributesAnnotation != null) {
            return AttributeParser.retrieveAttributes(attributesAnnotation);
        }
        return null;
    }
}

