/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class ALMGuidanceMetrics
extends APINode {
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="adopted_objects")
    private List<Object> mAdoptedObjects = null;
    @SerializedName(value="guidance_name")
    private String mGuidanceName = null;
    @SerializedName(value="guidance_type")
    private String mGuidanceType = null;
    @SerializedName(value="l28_adoption")
    private Long mL28Adoption = null;
    @SerializedName(value="l28_available")
    private Long mL28Available = null;
    @SerializedName(value="l28_click")
    private Long mL28Click = null;
    @SerializedName(value="l28_conversion")
    private Long mL28Conversion = null;
    @SerializedName(value="l28_impression")
    private Long mL28Impression = null;
    @SerializedName(value="l28_pitch")
    private Long mL28Pitch = null;
    @SerializedName(value="last_pitch_ds")
    private String mLastPitchDs = null;
    @SerializedName(value="parent_advertiser_id")
    private String mParentAdvertiserId = null;
    @SerializedName(value="report_ds")
    private String mReportDs = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ALMGuidanceMetrics loadJSON(String json, APIContext context, String header) {
        ALMGuidanceMetrics almGuidanceMetrics = (ALMGuidanceMetrics)ALMGuidanceMetrics.getGson().fromJson(json, ALMGuidanceMetrics.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(almGuidanceMetrics.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        almGuidanceMetrics.context = context;
        almGuidanceMetrics.rawValue = json;
        almGuidanceMetrics.header = header;
        return almGuidanceMetrics;
    }

    public static APINodeList<ALMGuidanceMetrics> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ALMGuidanceMetrics> almGuidanceMetricss = new APINodeList<ALMGuidanceMetrics>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        almGuidanceMetricss.add(ALMGuidanceMetrics.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return almGuidanceMetricss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            almGuidanceMetricss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        almGuidanceMetricss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            almGuidanceMetricss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            almGuidanceMetricss.add(ALMGuidanceMetrics.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                almGuidanceMetricss.add(ALMGuidanceMetrics.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            almGuidanceMetricss.add(ALMGuidanceMetrics.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return almGuidanceMetricss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        almGuidanceMetricss.add(ALMGuidanceMetrics.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return almGuidanceMetricss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        almGuidanceMetricss.add(ALMGuidanceMetrics.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return almGuidanceMetricss;
                }
                almGuidanceMetricss.clear();
                almGuidanceMetricss.add(ALMGuidanceMetrics.loadJSON(json, context, header));
                return almGuidanceMetricss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ALMGuidanceMetrics.getGson().toJson((Object)this);
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public ALMGuidanceMetrics setFieldAdAccountId(String value) {
        this.mAdAccountId = value;
        return this;
    }

    public List<Object> getFieldAdoptedObjects() {
        return this.mAdoptedObjects;
    }

    public ALMGuidanceMetrics setFieldAdoptedObjects(List<Object> value) {
        this.mAdoptedObjects = value;
        return this;
    }

    public String getFieldGuidanceName() {
        return this.mGuidanceName;
    }

    public ALMGuidanceMetrics setFieldGuidanceName(String value) {
        this.mGuidanceName = value;
        return this;
    }

    public String getFieldGuidanceType() {
        return this.mGuidanceType;
    }

    public ALMGuidanceMetrics setFieldGuidanceType(String value) {
        this.mGuidanceType = value;
        return this;
    }

    public Long getFieldL28Adoption() {
        return this.mL28Adoption;
    }

    public ALMGuidanceMetrics setFieldL28Adoption(Long value) {
        this.mL28Adoption = value;
        return this;
    }

    public Long getFieldL28Available() {
        return this.mL28Available;
    }

    public ALMGuidanceMetrics setFieldL28Available(Long value) {
        this.mL28Available = value;
        return this;
    }

    public Long getFieldL28Click() {
        return this.mL28Click;
    }

    public ALMGuidanceMetrics setFieldL28Click(Long value) {
        this.mL28Click = value;
        return this;
    }

    public Long getFieldL28Conversion() {
        return this.mL28Conversion;
    }

    public ALMGuidanceMetrics setFieldL28Conversion(Long value) {
        this.mL28Conversion = value;
        return this;
    }

    public Long getFieldL28Impression() {
        return this.mL28Impression;
    }

    public ALMGuidanceMetrics setFieldL28Impression(Long value) {
        this.mL28Impression = value;
        return this;
    }

    public Long getFieldL28Pitch() {
        return this.mL28Pitch;
    }

    public ALMGuidanceMetrics setFieldL28Pitch(Long value) {
        this.mL28Pitch = value;
        return this;
    }

    public String getFieldLastPitchDs() {
        return this.mLastPitchDs;
    }

    public ALMGuidanceMetrics setFieldLastPitchDs(String value) {
        this.mLastPitchDs = value;
        return this;
    }

    public String getFieldParentAdvertiserId() {
        return this.mParentAdvertiserId;
    }

    public ALMGuidanceMetrics setFieldParentAdvertiserId(String value) {
        this.mParentAdvertiserId = value;
        return this;
    }

    public String getFieldReportDs() {
        return this.mReportDs;
    }

    public ALMGuidanceMetrics setFieldReportDs(String value) {
        this.mReportDs = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ALMGuidanceMetrics copyFrom(ALMGuidanceMetrics instance) {
        this.mAdAccountId = instance.mAdAccountId;
        this.mAdoptedObjects = instance.mAdoptedObjects;
        this.mGuidanceName = instance.mGuidanceName;
        this.mGuidanceType = instance.mGuidanceType;
        this.mL28Adoption = instance.mL28Adoption;
        this.mL28Available = instance.mL28Available;
        this.mL28Click = instance.mL28Click;
        this.mL28Conversion = instance.mL28Conversion;
        this.mL28Impression = instance.mL28Impression;
        this.mL28Pitch = instance.mL28Pitch;
        this.mLastPitchDs = instance.mLastPitchDs;
        this.mParentAdvertiserId = instance.mParentAdvertiserId;
        this.mReportDs = instance.mReportDs;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ALMGuidanceMetrics> getParser() {
        return new APIRequest.ResponseParser<ALMGuidanceMetrics>(){

            @Override
            public APINodeList<ALMGuidanceMetrics> parseResponse(String response, APIContext context, APIRequest<ALMGuidanceMetrics> request, String header) throws APIException.MalformedResponseException {
                return ALMGuidanceMetrics.parseResponse(response, context, request, header);
            }
        };
    }
}

