/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdPlacement
extends APINode {
    @SerializedName(value="bundle_id")
    private String mBundleId = null;
    @SerializedName(value="display_format")
    private String mDisplayFormat = null;
    @SerializedName(value="external_placement_id")
    private String mExternalPlacementId = null;
    @SerializedName(value="google_display_format")
    private String mGoogleDisplayFormat = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="placement_group")
    private Object mPlacementGroup = null;
    @SerializedName(value="platform")
    private String mPlatform = null;
    @SerializedName(value="status")
    private String mStatus = null;
    protected static Gson gson = null;

    AdPlacement() {
    }

    public AdPlacement(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdPlacement(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdPlacement fetch() throws APIException {
        AdPlacement newInstance = AdPlacement.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdPlacement fetchById(Long id, APIContext context) throws APIException {
        return AdPlacement.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdPlacement> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdPlacement.fetchByIdAsync(id.toString(), context);
    }

    public static AdPlacement fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdPlacement> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdPlacement> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdPlacement>(context, "", "/", "GET", AdPlacement.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdPlacement>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdPlacement>(context, "", "/", "GET", AdPlacement.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdPlacement loadJSON(String json, APIContext context, String header) {
        AdPlacement adPlacement = (AdPlacement)AdPlacement.getGson().fromJson(json, AdPlacement.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adPlacement.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adPlacement.context = context;
        adPlacement.rawValue = json;
        adPlacement.header = header;
        return adPlacement;
    }

    public static APINodeList<AdPlacement> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdPlacement> adPlacements = new APINodeList<AdPlacement>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adPlacements.add(AdPlacement.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adPlacements;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adPlacements.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adPlacements.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adPlacements.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adPlacements.add(AdPlacement.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adPlacements.add(AdPlacement.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adPlacements.add(AdPlacement.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adPlacements;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adPlacements.add(AdPlacement.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adPlacements;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adPlacements.add(AdPlacement.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adPlacements;
                }
                adPlacements.clear();
                adPlacements.add(AdPlacement.loadJSON(json, context, header));
                return adPlacements;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdPlacement.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBundleId() {
        return this.mBundleId;
    }

    public String getFieldDisplayFormat() {
        return this.mDisplayFormat;
    }

    public String getFieldExternalPlacementId() {
        return this.mExternalPlacementId;
    }

    public String getFieldGoogleDisplayFormat() {
        return this.mGoogleDisplayFormat;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Object getFieldPlacementGroup() {
        return this.mPlacementGroup;
    }

    public String getFieldPlatform() {
        return this.mPlatform;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdPlacement copyFrom(AdPlacement instance) {
        this.mBundleId = instance.mBundleId;
        this.mDisplayFormat = instance.mDisplayFormat;
        this.mExternalPlacementId = instance.mExternalPlacementId;
        this.mGoogleDisplayFormat = instance.mGoogleDisplayFormat;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPlacementGroup = instance.mPlacementGroup;
        this.mPlatform = instance.mPlatform;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdPlacement> getParser() {
        return new APIRequest.ResponseParser<AdPlacement>(){

            @Override
            public APINodeList<AdPlacement> parseResponse(String response, APIContext context, APIRequest<AdPlacement> request, String header) throws APIException.MalformedResponseException {
                return AdPlacement.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdPlacement> {
        AdPlacement lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"bundle_id", "display_format", "external_placement_id", "google_display_format", "id", "name", "placement_group", "platform", "status"};

        @Override
        public AdPlacement getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdPlacement parseResponse(String response, String header) throws APIException {
            return AdPlacement.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdPlacement execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdPlacement execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdPlacement> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdPlacement> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdPlacement>(){

                public AdPlacement apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBundleIdField() {
            return this.requestBundleIdField(true);
        }

        public APIRequestGet requestBundleIdField(boolean value) {
            this.requestField("bundle_id", value);
            return this;
        }

        public APIRequestGet requestDisplayFormatField() {
            return this.requestDisplayFormatField(true);
        }

        public APIRequestGet requestDisplayFormatField(boolean value) {
            this.requestField("display_format", value);
            return this;
        }

        public APIRequestGet requestExternalPlacementIdField() {
            return this.requestExternalPlacementIdField(true);
        }

        public APIRequestGet requestExternalPlacementIdField(boolean value) {
            this.requestField("external_placement_id", value);
            return this;
        }

        public APIRequestGet requestGoogleDisplayFormatField() {
            return this.requestGoogleDisplayFormatField(true);
        }

        public APIRequestGet requestGoogleDisplayFormatField(boolean value) {
            this.requestField("google_display_format", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPlacementGroupField() {
            return this.requestPlacementGroupField(true);
        }

        public APIRequestGet requestPlacementGroupField(boolean value) {
            this.requestField("placement_group", value);
            return this;
        }

        public APIRequestGet requestPlatformField() {
            return this.requestPlatformField(true);
        }

        public APIRequestGet requestPlatformField(boolean value) {
            this.requestField("platform", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }
}

