/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdSavedReport
extends APINode {
    @SerializedName(value="app_owner")
    private Application mAppOwner = null;
    @SerializedName(value="breakdowns")
    private List<String> mBreakdowns = null;
    @SerializedName(value="builtin_column_set")
    private String mBuiltinColumnSet = null;
    @SerializedName(value="creation_source")
    private String mCreationSource = null;
    @SerializedName(value="date_interval")
    private Object mDateInterval = null;
    @SerializedName(value="date_preset")
    private String mDatePreset = null;
    @SerializedName(value="format_version")
    private Long mFormatVersion = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="insights_section")
    private Object mInsightsSection = null;
    @SerializedName(value="is_shared_unread")
    private Boolean mIsSharedUnread = null;
    @SerializedName(value="level")
    private String mLevel = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="normalized_filter")
    private JsonArray mNormalizedFilter = null;
    @SerializedName(value="sort")
    private List<Object> mSort = null;
    @SerializedName(value="user_attribution_windows")
    private List<String> mUserAttributionWindows = null;
    @SerializedName(value="user_columns")
    private List<String> mUserColumns = null;
    @SerializedName(value="user_filter")
    private JsonArray mUserFilter = null;
    @SerializedName(value="user_owner")
    private User mUserOwner = null;
    protected static Gson gson = null;

    AdSavedReport() {
    }

    public AdSavedReport(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdSavedReport(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdSavedReport fetch() throws APIException {
        AdSavedReport newInstance = AdSavedReport.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdSavedReport fetchById(Long id, APIContext context) throws APIException {
        return AdSavedReport.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdSavedReport> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdSavedReport.fetchByIdAsync(id.toString(), context);
    }

    public static AdSavedReport fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdSavedReport> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdSavedReport> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdSavedReport>(context, "", "/", "GET", AdSavedReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdSavedReport>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdSavedReport>(context, "", "/", "GET", AdSavedReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdSavedReport loadJSON(String json, APIContext context, String header) {
        AdSavedReport adSavedReport = (AdSavedReport)AdSavedReport.getGson().fromJson(json, AdSavedReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adSavedReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adSavedReport.context = context;
        adSavedReport.rawValue = json;
        adSavedReport.header = header;
        return adSavedReport;
    }

    public static APINodeList<AdSavedReport> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdSavedReport> adSavedReports = new APINodeList<AdSavedReport>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adSavedReports.add(AdSavedReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adSavedReports;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adSavedReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adSavedReports.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adSavedReports.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adSavedReports.add(AdSavedReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adSavedReports.add(AdSavedReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adSavedReports.add(AdSavedReport.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adSavedReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adSavedReports.add(AdSavedReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adSavedReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adSavedReports.add(AdSavedReport.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adSavedReports;
                }
                adSavedReports.clear();
                adSavedReports.add(AdSavedReport.loadJSON(json, context, header));
                return adSavedReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdSavedReport.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Application getFieldAppOwner() {
        if (this.mAppOwner != null) {
            this.mAppOwner.context = this.getContext();
        }
        return this.mAppOwner;
    }

    public List<String> getFieldBreakdowns() {
        return this.mBreakdowns;
    }

    public String getFieldBuiltinColumnSet() {
        return this.mBuiltinColumnSet;
    }

    public String getFieldCreationSource() {
        return this.mCreationSource;
    }

    public Object getFieldDateInterval() {
        return this.mDateInterval;
    }

    public String getFieldDatePreset() {
        return this.mDatePreset;
    }

    public Long getFieldFormatVersion() {
        return this.mFormatVersion;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Object getFieldInsightsSection() {
        return this.mInsightsSection;
    }

    public Boolean getFieldIsSharedUnread() {
        return this.mIsSharedUnread;
    }

    public String getFieldLevel() {
        return this.mLevel;
    }

    public String getFieldName() {
        return this.mName;
    }

    public JsonArray getFieldNormalizedFilter() {
        return this.mNormalizedFilter;
    }

    public List<Object> getFieldSort() {
        return this.mSort;
    }

    public List<String> getFieldUserAttributionWindows() {
        return this.mUserAttributionWindows;
    }

    public List<String> getFieldUserColumns() {
        return this.mUserColumns;
    }

    public JsonArray getFieldUserFilter() {
        return this.mUserFilter;
    }

    public User getFieldUserOwner() {
        if (this.mUserOwner != null) {
            this.mUserOwner.context = this.getContext();
        }
        return this.mUserOwner;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdSavedReport copyFrom(AdSavedReport instance) {
        this.mAppOwner = instance.mAppOwner;
        this.mBreakdowns = instance.mBreakdowns;
        this.mBuiltinColumnSet = instance.mBuiltinColumnSet;
        this.mCreationSource = instance.mCreationSource;
        this.mDateInterval = instance.mDateInterval;
        this.mDatePreset = instance.mDatePreset;
        this.mFormatVersion = instance.mFormatVersion;
        this.mId = instance.mId;
        this.mInsightsSection = instance.mInsightsSection;
        this.mIsSharedUnread = instance.mIsSharedUnread;
        this.mLevel = instance.mLevel;
        this.mName = instance.mName;
        this.mNormalizedFilter = instance.mNormalizedFilter;
        this.mSort = instance.mSort;
        this.mUserAttributionWindows = instance.mUserAttributionWindows;
        this.mUserColumns = instance.mUserColumns;
        this.mUserFilter = instance.mUserFilter;
        this.mUserOwner = instance.mUserOwner;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdSavedReport> getParser() {
        return new APIRequest.ResponseParser<AdSavedReport>(){

            @Override
            public APINodeList<AdSavedReport> parseResponse(String response, APIContext context, APIRequest<AdSavedReport> request, String header) throws APIException.MalformedResponseException {
                return AdSavedReport.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdSavedReport> {
        AdSavedReport lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"app_owner", "breakdowns", "builtin_column_set", "creation_source", "date_interval", "date_preset", "format_version", "id", "insights_section", "is_shared_unread", "level", "name", "normalized_filter", "sort", "user_attribution_windows", "user_columns", "user_filter", "user_owner"};

        @Override
        public AdSavedReport getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdSavedReport parseResponse(String response, String header) throws APIException {
            return AdSavedReport.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdSavedReport execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdSavedReport execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdSavedReport> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdSavedReport> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdSavedReport>(){

                public AdSavedReport apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAppOwnerField() {
            return this.requestAppOwnerField(true);
        }

        public APIRequestGet requestAppOwnerField(boolean value) {
            this.requestField("app_owner", value);
            return this;
        }

        public APIRequestGet requestBreakdownsField() {
            return this.requestBreakdownsField(true);
        }

        public APIRequestGet requestBreakdownsField(boolean value) {
            this.requestField("breakdowns", value);
            return this;
        }

        public APIRequestGet requestBuiltinColumnSetField() {
            return this.requestBuiltinColumnSetField(true);
        }

        public APIRequestGet requestBuiltinColumnSetField(boolean value) {
            this.requestField("builtin_column_set", value);
            return this;
        }

        public APIRequestGet requestCreationSourceField() {
            return this.requestCreationSourceField(true);
        }

        public APIRequestGet requestCreationSourceField(boolean value) {
            this.requestField("creation_source", value);
            return this;
        }

        public APIRequestGet requestDateIntervalField() {
            return this.requestDateIntervalField(true);
        }

        public APIRequestGet requestDateIntervalField(boolean value) {
            this.requestField("date_interval", value);
            return this;
        }

        public APIRequestGet requestDatePresetField() {
            return this.requestDatePresetField(true);
        }

        public APIRequestGet requestDatePresetField(boolean value) {
            this.requestField("date_preset", value);
            return this;
        }

        public APIRequestGet requestFormatVersionField() {
            return this.requestFormatVersionField(true);
        }

        public APIRequestGet requestFormatVersionField(boolean value) {
            this.requestField("format_version", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInsightsSectionField() {
            return this.requestInsightsSectionField(true);
        }

        public APIRequestGet requestInsightsSectionField(boolean value) {
            this.requestField("insights_section", value);
            return this;
        }

        public APIRequestGet requestIsSharedUnreadField() {
            return this.requestIsSharedUnreadField(true);
        }

        public APIRequestGet requestIsSharedUnreadField(boolean value) {
            this.requestField("is_shared_unread", value);
            return this;
        }

        public APIRequestGet requestLevelField() {
            return this.requestLevelField(true);
        }

        public APIRequestGet requestLevelField(boolean value) {
            this.requestField("level", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNormalizedFilterField() {
            return this.requestNormalizedFilterField(true);
        }

        public APIRequestGet requestNormalizedFilterField(boolean value) {
            this.requestField("normalized_filter", value);
            return this;
        }

        public APIRequestGet requestSortField() {
            return this.requestSortField(true);
        }

        public APIRequestGet requestSortField(boolean value) {
            this.requestField("sort", value);
            return this;
        }

        public APIRequestGet requestUserAttributionWindowsField() {
            return this.requestUserAttributionWindowsField(true);
        }

        public APIRequestGet requestUserAttributionWindowsField(boolean value) {
            this.requestField("user_attribution_windows", value);
            return this;
        }

        public APIRequestGet requestUserColumnsField() {
            return this.requestUserColumnsField(true);
        }

        public APIRequestGet requestUserColumnsField(boolean value) {
            this.requestField("user_columns", value);
            return this;
        }

        public APIRequestGet requestUserFilterField() {
            return this.requestUserFilterField(true);
        }

        public APIRequestGet requestUserFilterField(boolean value) {
            this.requestField("user_filter", value);
            return this;
        }

        public APIRequestGet requestUserOwnerField() {
            return this.requestUserOwnerField(true);
        }

        public APIRequestGet requestUserOwnerField(boolean value) {
            this.requestField("user_owner", value);
            return this;
        }
    }
}

