/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdsCreationSavedState
extends APINode {
    @SerializedName(value="ad_account")
    private AdAccount mAdAccount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="serialized_store_data")
    private String mSerializedStoreData = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    @SerializedName(value="user")
    private Object mUser = null;
    protected static Gson gson = null;

    AdsCreationSavedState() {
    }

    public AdsCreationSavedState(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsCreationSavedState(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsCreationSavedState fetch() throws APIException {
        AdsCreationSavedState newInstance = AdsCreationSavedState.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsCreationSavedState fetchById(Long id, APIContext context) throws APIException {
        return AdsCreationSavedState.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsCreationSavedState> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsCreationSavedState.fetchByIdAsync(id.toString(), context);
    }

    public static AdsCreationSavedState fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsCreationSavedState> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsCreationSavedState> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsCreationSavedState>(context, "", "/", "GET", AdsCreationSavedState.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsCreationSavedState>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsCreationSavedState>(context, "", "/", "GET", AdsCreationSavedState.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsCreationSavedState loadJSON(String json, APIContext context, String header) {
        AdsCreationSavedState adsCreationSavedState = (AdsCreationSavedState)AdsCreationSavedState.getGson().fromJson(json, AdsCreationSavedState.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsCreationSavedState.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsCreationSavedState.context = context;
        adsCreationSavedState.rawValue = json;
        adsCreationSavedState.header = header;
        return adsCreationSavedState;
    }

    public static APINodeList<AdsCreationSavedState> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsCreationSavedState> adsCreationSavedStates = new APINodeList<AdsCreationSavedState>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsCreationSavedStates.add(AdsCreationSavedState.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsCreationSavedStates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsCreationSavedStates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsCreationSavedStates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsCreationSavedStates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsCreationSavedStates.add(AdsCreationSavedState.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsCreationSavedStates.add(AdsCreationSavedState.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsCreationSavedStates.add(AdsCreationSavedState.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsCreationSavedStates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsCreationSavedStates.add(AdsCreationSavedState.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsCreationSavedStates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsCreationSavedStates.add(AdsCreationSavedState.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsCreationSavedStates;
                }
                adsCreationSavedStates.clear();
                adsCreationSavedStates.add(AdsCreationSavedState.loadJSON(json, context, header));
                return adsCreationSavedStates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsCreationSavedState.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAccount getFieldAdAccount() {
        if (this.mAdAccount != null) {
            this.mAdAccount.context = this.getContext();
        }
        return this.mAdAccount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldSerializedStoreData() {
        return this.mSerializedStoreData;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    public Object getFieldUser() {
        return this.mUser;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsCreationSavedState copyFrom(AdsCreationSavedState instance) {
        this.mAdAccount = instance.mAdAccount;
        this.mId = instance.mId;
        this.mSerializedStoreData = instance.mSerializedStoreData;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.mUser = instance.mUser;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsCreationSavedState> getParser() {
        return new APIRequest.ResponseParser<AdsCreationSavedState>(){

            @Override
            public APINodeList<AdsCreationSavedState> parseResponse(String response, APIContext context, APIRequest<AdsCreationSavedState> request, String header) throws APIException.MalformedResponseException {
                return AdsCreationSavedState.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdsCreationSavedState> {
        AdsCreationSavedState lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account", "id", "serialized_store_data", "time_updated", "user"};

        @Override
        public AdsCreationSavedState getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsCreationSavedState parseResponse(String response, String header) throws APIException {
            return AdsCreationSavedState.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsCreationSavedState execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsCreationSavedState execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsCreationSavedState> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsCreationSavedState> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsCreationSavedState>(){

                public AdsCreationSavedState apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountField() {
            return this.requestAdAccountField(true);
        }

        public APIRequestGet requestAdAccountField(boolean value) {
            this.requestField("ad_account", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestSerializedStoreDataField() {
            return this.requestSerializedStoreDataField(true);
        }

        public APIRequestGet requestSerializedStoreDataField(boolean value) {
            this.requestField("serialized_store_data", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }

        public APIRequestGet requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGet requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }
    }
}

