/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdsPixel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class AdsSignalDiagnosticIssue
extends APINode {
    @SerializedName(value="data_source_id")
    private AdsPixel mDataSourceId = null;
    @SerializedName(value="data_source_type")
    private String mDataSourceType = null;
    @SerializedName(value="diagnostic_type")
    private String mDiagnosticType = null;
    @SerializedName(value="event_name")
    private String mEventName = null;
    @SerializedName(value="traffic_anomaly_drop_percentage")
    private Double mTrafficAnomalyDropPercentage = null;
    @SerializedName(value="traffic_anomaly_drop_timestamp")
    private String mTrafficAnomalyDropTimestamp = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdsSignalDiagnosticIssue loadJSON(String json, APIContext context, String header) {
        AdsSignalDiagnosticIssue adsSignalDiagnosticIssue = (AdsSignalDiagnosticIssue)AdsSignalDiagnosticIssue.getGson().fromJson(json, AdsSignalDiagnosticIssue.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsSignalDiagnosticIssue.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsSignalDiagnosticIssue.context = context;
        adsSignalDiagnosticIssue.rawValue = json;
        adsSignalDiagnosticIssue.header = header;
        return adsSignalDiagnosticIssue;
    }

    public static APINodeList<AdsSignalDiagnosticIssue> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsSignalDiagnosticIssue> adsSignalDiagnosticIssues = new APINodeList<AdsSignalDiagnosticIssue>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsSignalDiagnosticIssues.add(AdsSignalDiagnosticIssue.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsSignalDiagnosticIssues;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsSignalDiagnosticIssues.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsSignalDiagnosticIssues.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsSignalDiagnosticIssues.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsSignalDiagnosticIssues.add(AdsSignalDiagnosticIssue.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsSignalDiagnosticIssues.add(AdsSignalDiagnosticIssue.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsSignalDiagnosticIssues.add(AdsSignalDiagnosticIssue.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsSignalDiagnosticIssues;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsSignalDiagnosticIssues.add(AdsSignalDiagnosticIssue.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsSignalDiagnosticIssues;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsSignalDiagnosticIssues.add(AdsSignalDiagnosticIssue.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsSignalDiagnosticIssues;
                }
                adsSignalDiagnosticIssues.clear();
                adsSignalDiagnosticIssues.add(AdsSignalDiagnosticIssue.loadJSON(json, context, header));
                return adsSignalDiagnosticIssues;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsSignalDiagnosticIssue.getGson().toJson((Object)this);
    }

    public AdsPixel getFieldDataSourceId() {
        if (this.mDataSourceId != null) {
            this.mDataSourceId.context = this.getContext();
        }
        return this.mDataSourceId;
    }

    public AdsSignalDiagnosticIssue setFieldDataSourceId(AdsPixel value) {
        this.mDataSourceId = value;
        return this;
    }

    public AdsSignalDiagnosticIssue setFieldDataSourceId(String value) {
        Type type = new TypeToken<AdsPixel>(){}.getType();
        this.mDataSourceId = (AdsPixel)AdsPixel.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldDataSourceType() {
        return this.mDataSourceType;
    }

    public AdsSignalDiagnosticIssue setFieldDataSourceType(String value) {
        this.mDataSourceType = value;
        return this;
    }

    public String getFieldDiagnosticType() {
        return this.mDiagnosticType;
    }

    public AdsSignalDiagnosticIssue setFieldDiagnosticType(String value) {
        this.mDiagnosticType = value;
        return this;
    }

    public String getFieldEventName() {
        return this.mEventName;
    }

    public AdsSignalDiagnosticIssue setFieldEventName(String value) {
        this.mEventName = value;
        return this;
    }

    public Double getFieldTrafficAnomalyDropPercentage() {
        return this.mTrafficAnomalyDropPercentage;
    }

    public AdsSignalDiagnosticIssue setFieldTrafficAnomalyDropPercentage(Double value) {
        this.mTrafficAnomalyDropPercentage = value;
        return this;
    }

    public String getFieldTrafficAnomalyDropTimestamp() {
        return this.mTrafficAnomalyDropTimestamp;
    }

    public AdsSignalDiagnosticIssue setFieldTrafficAnomalyDropTimestamp(String value) {
        this.mTrafficAnomalyDropTimestamp = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsSignalDiagnosticIssue copyFrom(AdsSignalDiagnosticIssue instance) {
        this.mDataSourceId = instance.mDataSourceId;
        this.mDataSourceType = instance.mDataSourceType;
        this.mDiagnosticType = instance.mDiagnosticType;
        this.mEventName = instance.mEventName;
        this.mTrafficAnomalyDropPercentage = instance.mTrafficAnomalyDropPercentage;
        this.mTrafficAnomalyDropTimestamp = instance.mTrafficAnomalyDropTimestamp;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsSignalDiagnosticIssue> getParser() {
        return new APIRequest.ResponseParser<AdsSignalDiagnosticIssue>(){

            @Override
            public APINodeList<AdsSignalDiagnosticIssue> parseResponse(String response, APIContext context, APIRequest<AdsSignalDiagnosticIssue> request, String header) throws APIException.MalformedResponseException {
                return AdsSignalDiagnosticIssue.parseResponse(response, context, request, header);
            }
        };
    }
}

