/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class BAPIDomain
extends APINode {
    @SerializedName(value="domain")
    private String mDomain = null;
    @SerializedName(value="in_cool_down_until")
    private Long mInCoolDownUntil = null;
    @SerializedName(value="is_eligible_for_vo")
    private Boolean mIsEligibleForVo = null;
    @SerializedName(value="is_in_cool_down")
    private Boolean mIsInCoolDown = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static BAPIDomain loadJSON(String json, APIContext context, String header) {
        BAPIDomain bapiDomain = (BAPIDomain)BAPIDomain.getGson().fromJson(json, BAPIDomain.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(bapiDomain.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        bapiDomain.context = context;
        bapiDomain.rawValue = json;
        bapiDomain.header = header;
        return bapiDomain;
    }

    public static APINodeList<BAPIDomain> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BAPIDomain> bapiDomains = new APINodeList<BAPIDomain>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        bapiDomains.add(BAPIDomain.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return bapiDomains;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            bapiDomains.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        bapiDomains.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            bapiDomains.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            bapiDomains.add(BAPIDomain.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                bapiDomains.add(BAPIDomain.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            bapiDomains.add(BAPIDomain.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return bapiDomains;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        bapiDomains.add(BAPIDomain.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return bapiDomains;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        bapiDomains.add(BAPIDomain.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return bapiDomains;
                }
                bapiDomains.clear();
                bapiDomains.add(BAPIDomain.loadJSON(json, context, header));
                return bapiDomains;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BAPIDomain.getGson().toJson((Object)this);
    }

    public String getFieldDomain() {
        return this.mDomain;
    }

    public BAPIDomain setFieldDomain(String value) {
        this.mDomain = value;
        return this;
    }

    public Long getFieldInCoolDownUntil() {
        return this.mInCoolDownUntil;
    }

    public BAPIDomain setFieldInCoolDownUntil(Long value) {
        this.mInCoolDownUntil = value;
        return this;
    }

    public Boolean getFieldIsEligibleForVo() {
        return this.mIsEligibleForVo;
    }

    public BAPIDomain setFieldIsEligibleForVo(Boolean value) {
        this.mIsEligibleForVo = value;
        return this;
    }

    public Boolean getFieldIsInCoolDown() {
        return this.mIsInCoolDown;
    }

    public BAPIDomain setFieldIsInCoolDown(Boolean value) {
        this.mIsInCoolDown = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BAPIDomain copyFrom(BAPIDomain instance) {
        this.mDomain = instance.mDomain;
        this.mInCoolDownUntil = instance.mInCoolDownUntil;
        this.mIsEligibleForVo = instance.mIsEligibleForVo;
        this.mIsInCoolDown = instance.mIsInCoolDown;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BAPIDomain> getParser() {
        return new APIRequest.ResponseParser<BAPIDomain>(){

            @Override
            public APINodeList<BAPIDomain> parseResponse(String response, APIContext context, APIRequest<BAPIDomain> request, String header) throws APIException.MalformedResponseException {
                return BAPIDomain.parseResponse(response, context, request, header);
            }
        };
    }
}

