/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.BusinessAssetGroup;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class BusinessFranchiseConfig
extends APINode {
    @SerializedName(value="active_partner_count")
    private Long mActivePartnerCount = null;
    @SerializedName(value="agency_business")
    private Business mAgencyBusiness = null;
    @SerializedName(value="agency_business_asset_group")
    private BusinessAssetGroup mAgencyBusinessAssetGroup = null;
    @SerializedName(value="brand_name")
    private String mBrandName = null;
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="business_vertical")
    private String mBusinessVertical = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="partner_count")
    private Long mPartnerCount = null;
    @SerializedName(value="pending_agency_business")
    private String mPendingAgencyBusiness = null;
    @SerializedName(value="program_count")
    private Long mProgramCount = null;
    @SerializedName(value="shared_business_asset_group")
    private BusinessAssetGroup mSharedBusinessAssetGroup = null;
    @SerializedName(value="shared_creative_folder_count")
    private Long mSharedCreativeFolderCount = null;
    @SerializedName(value="shared_custom_audience_count")
    private Long mSharedCustomAudienceCount = null;
    protected static Gson gson = null;

    BusinessFranchiseConfig() {
    }

    public BusinessFranchiseConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessFranchiseConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessFranchiseConfig fetch() throws APIException {
        BusinessFranchiseConfig newInstance = BusinessFranchiseConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessFranchiseConfig fetchById(Long id, APIContext context) throws APIException {
        return BusinessFranchiseConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessFranchiseConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessFranchiseConfig.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessFranchiseConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessFranchiseConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessFranchiseConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessFranchiseConfig>(context, "", "/", "GET", BusinessFranchiseConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessFranchiseConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessFranchiseConfig>(context, "", "/", "GET", BusinessFranchiseConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessFranchiseConfig loadJSON(String json, APIContext context, String header) {
        BusinessFranchiseConfig businessFranchiseConfig = (BusinessFranchiseConfig)BusinessFranchiseConfig.getGson().fromJson(json, BusinessFranchiseConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessFranchiseConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessFranchiseConfig.context = context;
        businessFranchiseConfig.rawValue = json;
        businessFranchiseConfig.header = header;
        return businessFranchiseConfig;
    }

    public static APINodeList<BusinessFranchiseConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessFranchiseConfig> businessFranchiseConfigs = new APINodeList<BusinessFranchiseConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessFranchiseConfigs.add(BusinessFranchiseConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessFranchiseConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessFranchiseConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessFranchiseConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessFranchiseConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessFranchiseConfigs.add(BusinessFranchiseConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessFranchiseConfigs.add(BusinessFranchiseConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessFranchiseConfigs.add(BusinessFranchiseConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessFranchiseConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessFranchiseConfigs.add(BusinessFranchiseConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessFranchiseConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessFranchiseConfigs.add(BusinessFranchiseConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessFranchiseConfigs;
                }
                businessFranchiseConfigs.clear();
                businessFranchiseConfigs.add(BusinessFranchiseConfig.loadJSON(json, context, header));
                return businessFranchiseConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessFranchiseConfig.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldActivePartnerCount() {
        return this.mActivePartnerCount;
    }

    public Business getFieldAgencyBusiness() {
        if (this.mAgencyBusiness != null) {
            this.mAgencyBusiness.context = this.getContext();
        }
        return this.mAgencyBusiness;
    }

    public BusinessAssetGroup getFieldAgencyBusinessAssetGroup() {
        if (this.mAgencyBusinessAssetGroup != null) {
            this.mAgencyBusinessAssetGroup.context = this.getContext();
        }
        return this.mAgencyBusinessAssetGroup;
    }

    public String getFieldBrandName() {
        return this.mBrandName;
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldBusinessVertical() {
        return this.mBusinessVertical;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldPartnerCount() {
        return this.mPartnerCount;
    }

    public String getFieldPendingAgencyBusiness() {
        return this.mPendingAgencyBusiness;
    }

    public Long getFieldProgramCount() {
        return this.mProgramCount;
    }

    public BusinessAssetGroup getFieldSharedBusinessAssetGroup() {
        if (this.mSharedBusinessAssetGroup != null) {
            this.mSharedBusinessAssetGroup.context = this.getContext();
        }
        return this.mSharedBusinessAssetGroup;
    }

    public Long getFieldSharedCreativeFolderCount() {
        return this.mSharedCreativeFolderCount;
    }

    public Long getFieldSharedCustomAudienceCount() {
        return this.mSharedCustomAudienceCount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessFranchiseConfig copyFrom(BusinessFranchiseConfig instance) {
        this.mActivePartnerCount = instance.mActivePartnerCount;
        this.mAgencyBusiness = instance.mAgencyBusiness;
        this.mAgencyBusinessAssetGroup = instance.mAgencyBusinessAssetGroup;
        this.mBrandName = instance.mBrandName;
        this.mBusiness = instance.mBusiness;
        this.mBusinessVertical = instance.mBusinessVertical;
        this.mId = instance.mId;
        this.mPartnerCount = instance.mPartnerCount;
        this.mPendingAgencyBusiness = instance.mPendingAgencyBusiness;
        this.mProgramCount = instance.mProgramCount;
        this.mSharedBusinessAssetGroup = instance.mSharedBusinessAssetGroup;
        this.mSharedCreativeFolderCount = instance.mSharedCreativeFolderCount;
        this.mSharedCustomAudienceCount = instance.mSharedCustomAudienceCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessFranchiseConfig> getParser() {
        return new APIRequest.ResponseParser<BusinessFranchiseConfig>(){

            @Override
            public APINodeList<BusinessFranchiseConfig> parseResponse(String response, APIContext context, APIRequest<BusinessFranchiseConfig> request, String header) throws APIException.MalformedResponseException {
                return BusinessFranchiseConfig.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<BusinessFranchiseConfig> {
        BusinessFranchiseConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"active_partner_count", "agency_business", "agency_business_asset_group", "brand_name", "business", "business_vertical", "id", "partner_count", "pending_agency_business", "program_count", "shared_business_asset_group", "shared_creative_folder_count", "shared_custom_audience_count"};

        @Override
        public BusinessFranchiseConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessFranchiseConfig parseResponse(String response, String header) throws APIException {
            return BusinessFranchiseConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessFranchiseConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessFranchiseConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessFranchiseConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessFranchiseConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessFranchiseConfig>(){

                public BusinessFranchiseConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActivePartnerCountField() {
            return this.requestActivePartnerCountField(true);
        }

        public APIRequestGet requestActivePartnerCountField(boolean value) {
            this.requestField("active_partner_count", value);
            return this;
        }

        public APIRequestGet requestAgencyBusinessField() {
            return this.requestAgencyBusinessField(true);
        }

        public APIRequestGet requestAgencyBusinessField(boolean value) {
            this.requestField("agency_business", value);
            return this;
        }

        public APIRequestGet requestAgencyBusinessAssetGroupField() {
            return this.requestAgencyBusinessAssetGroupField(true);
        }

        public APIRequestGet requestAgencyBusinessAssetGroupField(boolean value) {
            this.requestField("agency_business_asset_group", value);
            return this;
        }

        public APIRequestGet requestBrandNameField() {
            return this.requestBrandNameField(true);
        }

        public APIRequestGet requestBrandNameField(boolean value) {
            this.requestField("brand_name", value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestBusinessVerticalField() {
            return this.requestBusinessVerticalField(true);
        }

        public APIRequestGet requestBusinessVerticalField(boolean value) {
            this.requestField("business_vertical", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPartnerCountField() {
            return this.requestPartnerCountField(true);
        }

        public APIRequestGet requestPartnerCountField(boolean value) {
            this.requestField("partner_count", value);
            return this;
        }

        public APIRequestGet requestPendingAgencyBusinessField() {
            return this.requestPendingAgencyBusinessField(true);
        }

        public APIRequestGet requestPendingAgencyBusinessField(boolean value) {
            this.requestField("pending_agency_business", value);
            return this;
        }

        public APIRequestGet requestProgramCountField() {
            return this.requestProgramCountField(true);
        }

        public APIRequestGet requestProgramCountField(boolean value) {
            this.requestField("program_count", value);
            return this;
        }

        public APIRequestGet requestSharedBusinessAssetGroupField() {
            return this.requestSharedBusinessAssetGroupField(true);
        }

        public APIRequestGet requestSharedBusinessAssetGroupField(boolean value) {
            this.requestField("shared_business_asset_group", value);
            return this;
        }

        public APIRequestGet requestSharedCreativeFolderCountField() {
            return this.requestSharedCreativeFolderCountField(true);
        }

        public APIRequestGet requestSharedCreativeFolderCountField(boolean value) {
            this.requestField("shared_creative_folder_count", value);
            return this;
        }

        public APIRequestGet requestSharedCustomAudienceCountField() {
            return this.requestSharedCustomAudienceCountField(true);
        }

        public APIRequestGet requestSharedCustomAudienceCountField(boolean value) {
            this.requestField("shared_custom_audience_count", value);
            return this;
        }
    }
}

