/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class BusinessRequest
extends APINode {
    @SerializedName(value="accessor")
    private Business mAccessor = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="object_id")
    private String mObjectId = null;
    @SerializedName(value="object_type")
    private String mObjectType = null;
    @SerializedName(value="permitted_tasks")
    private List<String> mPermittedTasks = null;
    @SerializedName(value="request_status")
    private String mRequestStatus = null;
    @SerializedName(value="request_type")
    private String mRequestType = null;
    @SerializedName(value="requestor")
    private String mRequestor = null;
    protected static Gson gson = null;

    BusinessRequest() {
    }

    public BusinessRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessRequest fetch() throws APIException {
        BusinessRequest newInstance = BusinessRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessRequest fetchById(Long id, APIContext context) throws APIException {
        return BusinessRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessRequest.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessRequest>(context, "", "/", "GET", BusinessRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessRequest>(context, "", "/", "GET", BusinessRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessRequest loadJSON(String json, APIContext context, String header) {
        BusinessRequest businessRequest = (BusinessRequest)BusinessRequest.getGson().fromJson(json, BusinessRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessRequest.context = context;
        businessRequest.rawValue = json;
        businessRequest.header = header;
        return businessRequest;
    }

    public static APINodeList<BusinessRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessRequest> businessRequests = new APINodeList<BusinessRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessRequests.add(BusinessRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessRequests.add(BusinessRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessRequests.add(BusinessRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessRequests.add(BusinessRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessRequests.add(BusinessRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessRequests.add(BusinessRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessRequests;
                }
                businessRequests.clear();
                businessRequests.add(BusinessRequest.loadJSON(json, context, header));
                return businessRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessRequest.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldAccessor() {
        if (this.mAccessor != null) {
            this.mAccessor.context = this.getContext();
        }
        return this.mAccessor;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldObjectId() {
        return this.mObjectId;
    }

    public String getFieldObjectType() {
        return this.mObjectType;
    }

    public List<String> getFieldPermittedTasks() {
        return this.mPermittedTasks;
    }

    public String getFieldRequestStatus() {
        return this.mRequestStatus;
    }

    public String getFieldRequestType() {
        return this.mRequestType;
    }

    public String getFieldRequestor() {
        return this.mRequestor;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessRequest copyFrom(BusinessRequest instance) {
        this.mAccessor = instance.mAccessor;
        this.mCreationTime = instance.mCreationTime;
        this.mId = instance.mId;
        this.mObjectId = instance.mObjectId;
        this.mObjectType = instance.mObjectType;
        this.mPermittedTasks = instance.mPermittedTasks;
        this.mRequestStatus = instance.mRequestStatus;
        this.mRequestType = instance.mRequestType;
        this.mRequestor = instance.mRequestor;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessRequest> getParser() {
        return new APIRequest.ResponseParser<BusinessRequest>(){

            @Override
            public APINodeList<BusinessRequest> parseResponse(String response, APIContext context, APIRequest<BusinessRequest> request, String header) throws APIException.MalformedResponseException {
                return BusinessRequest.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<BusinessRequest> {
        BusinessRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"accessor", "creation_time", "id", "object_id", "object_type", "permitted_tasks", "request_status", "request_type", "requestor"};

        @Override
        public BusinessRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessRequest parseResponse(String response, String header) throws APIException {
            return BusinessRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessRequest>(){

                public BusinessRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccessorField() {
            return this.requestAccessorField(true);
        }

        public APIRequestGet requestAccessorField(boolean value) {
            this.requestField("accessor", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestObjectIdField() {
            return this.requestObjectIdField(true);
        }

        public APIRequestGet requestObjectIdField(boolean value) {
            this.requestField("object_id", value);
            return this;
        }

        public APIRequestGet requestObjectTypeField() {
            return this.requestObjectTypeField(true);
        }

        public APIRequestGet requestObjectTypeField(boolean value) {
            this.requestField("object_type", value);
            return this;
        }

        public APIRequestGet requestPermittedTasksField() {
            return this.requestPermittedTasksField(true);
        }

        public APIRequestGet requestPermittedTasksField(boolean value) {
            this.requestField("permitted_tasks", value);
            return this;
        }

        public APIRequestGet requestRequestStatusField() {
            return this.requestRequestStatusField(true);
        }

        public APIRequestGet requestRequestStatusField(boolean value) {
            this.requestField("request_status", value);
            return this;
        }

        public APIRequestGet requestRequestTypeField() {
            return this.requestRequestTypeField(true);
        }

        public APIRequestGet requestRequestTypeField(boolean value) {
            this.requestField("request_type", value);
            return this;
        }

        public APIRequestGet requestRequestorField() {
            return this.requestRequestorField(true);
        }

        public APIRequestGet requestRequestorField(boolean value) {
            this.requestField("requestor", value);
            return this;
        }
    }
}

