/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogItemChannelsToIntegrityStatus;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.facebook.ads.sdk.DynamicVideoMetadata;
import com.facebook.ads.sdk.OverrideDetails;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class Flight
extends APINode {
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="custom_label_0")
    private String mCustomLabel0 = null;
    @SerializedName(value="custom_label_1")
    private String mCustomLabel1 = null;
    @SerializedName(value="custom_label_2")
    private String mCustomLabel2 = null;
    @SerializedName(value="custom_label_3")
    private String mCustomLabel3 = null;
    @SerializedName(value="custom_label_4")
    private String mCustomLabel4 = null;
    @SerializedName(value="custom_number_0")
    private Long mCustomNumber0 = null;
    @SerializedName(value="custom_number_1")
    private Long mCustomNumber1 = null;
    @SerializedName(value="custom_number_2")
    private Long mCustomNumber2 = null;
    @SerializedName(value="custom_number_3")
    private Long mCustomNumber3 = null;
    @SerializedName(value="custom_number_4")
    private Long mCustomNumber4 = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="destination_airport")
    private String mDestinationAirport = null;
    @SerializedName(value="destination_city")
    private String mDestinationCity = null;
    @SerializedName(value="flight_id")
    private String mFlightId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="oneway_currency")
    private String mOnewayCurrency = null;
    @SerializedName(value="oneway_price")
    private String mOnewayPrice = null;
    @SerializedName(value="origin_airport")
    private String mOriginAirport = null;
    @SerializedName(value="origin_city")
    private String mOriginCity = null;
    @SerializedName(value="price")
    private String mPrice = null;
    @SerializedName(value="product_priority_0")
    private Double mProductPriority0 = null;
    @SerializedName(value="product_priority_1")
    private Double mProductPriority1 = null;
    @SerializedName(value="product_priority_2")
    private Double mProductPriority2 = null;
    @SerializedName(value="product_priority_3")
    private Double mProductPriority3 = null;
    @SerializedName(value="product_priority_4")
    private Double mProductPriority4 = null;
    @SerializedName(value="sanitized_images")
    private List<String> mSanitizedImages = null;
    @SerializedName(value="tags")
    private List<String> mTags = null;
    @SerializedName(value="unit_price")
    private Object mUnitPrice = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="visibility")
    private EnumVisibility mVisibility = null;
    protected static Gson gson = null;

    Flight() {
    }

    public Flight(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Flight(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Flight fetch() throws APIException {
        Flight newInstance = Flight.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Flight fetchById(Long id, APIContext context) throws APIException {
        return Flight.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Flight> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Flight.fetchByIdAsync(id.toString(), context);
    }

    public static Flight fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Flight> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Flight> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Flight>(context, "", "/", "GET", Flight.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Flight>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Flight>(context, "", "/", "GET", Flight.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Flight loadJSON(String json, APIContext context, String header) {
        Flight flight = (Flight)Flight.getGson().fromJson(json, Flight.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(flight.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        flight.context = context;
        flight.rawValue = json;
        flight.header = header;
        return flight;
    }

    public static APINodeList<Flight> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Flight> flights = new APINodeList<Flight>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        flights.add(Flight.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return flights;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            flights.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        flights.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            flights.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            flights.add(Flight.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                flights.add(Flight.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            flights.add(Flight.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return flights;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        flights.add(Flight.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return flights;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        flights.add(Flight.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return flights;
                }
                flights.clear();
                flights.add(Flight.loadJSON(json, context, header));
                return flights;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Flight.getGson().toJson((Object)this);
    }

    public APIRequestGetChannelsToIntegrityStatus getChannelsToIntegrityStatus() {
        return new APIRequestGetChannelsToIntegrityStatus(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOverrideDetails getOverrideDetails() {
        return new APIRequestGetOverrideDetails(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideosMetadata getVideosMetadata() {
        return new APIRequestGetVideosMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldCustomLabel0() {
        return this.mCustomLabel0;
    }

    public String getFieldCustomLabel1() {
        return this.mCustomLabel1;
    }

    public String getFieldCustomLabel2() {
        return this.mCustomLabel2;
    }

    public String getFieldCustomLabel3() {
        return this.mCustomLabel3;
    }

    public String getFieldCustomLabel4() {
        return this.mCustomLabel4;
    }

    public Long getFieldCustomNumber0() {
        return this.mCustomNumber0;
    }

    public Long getFieldCustomNumber1() {
        return this.mCustomNumber1;
    }

    public Long getFieldCustomNumber2() {
        return this.mCustomNumber2;
    }

    public Long getFieldCustomNumber3() {
        return this.mCustomNumber3;
    }

    public Long getFieldCustomNumber4() {
        return this.mCustomNumber4;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldDestinationAirport() {
        return this.mDestinationAirport;
    }

    public String getFieldDestinationCity() {
        return this.mDestinationCity;
    }

    public String getFieldFlightId() {
        return this.mFlightId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldOnewayCurrency() {
        return this.mOnewayCurrency;
    }

    public String getFieldOnewayPrice() {
        return this.mOnewayPrice;
    }

    public String getFieldOriginAirport() {
        return this.mOriginAirport;
    }

    public String getFieldOriginCity() {
        return this.mOriginCity;
    }

    public String getFieldPrice() {
        return this.mPrice;
    }

    public Double getFieldProductPriority0() {
        return this.mProductPriority0;
    }

    public Double getFieldProductPriority1() {
        return this.mProductPriority1;
    }

    public Double getFieldProductPriority2() {
        return this.mProductPriority2;
    }

    public Double getFieldProductPriority3() {
        return this.mProductPriority3;
    }

    public Double getFieldProductPriority4() {
        return this.mProductPriority4;
    }

    public List<String> getFieldSanitizedImages() {
        return this.mSanitizedImages;
    }

    public List<String> getFieldTags() {
        return this.mTags;
    }

    public Object getFieldUnitPrice() {
        return this.mUnitPrice;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public EnumVisibility getFieldVisibility() {
        return this.mVisibility;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Flight copyFrom(Flight instance) {
        this.mApplinks = instance.mApplinks;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mCurrency = instance.mCurrency;
        this.mCustomLabel0 = instance.mCustomLabel0;
        this.mCustomLabel1 = instance.mCustomLabel1;
        this.mCustomLabel2 = instance.mCustomLabel2;
        this.mCustomLabel3 = instance.mCustomLabel3;
        this.mCustomLabel4 = instance.mCustomLabel4;
        this.mCustomNumber0 = instance.mCustomNumber0;
        this.mCustomNumber1 = instance.mCustomNumber1;
        this.mCustomNumber2 = instance.mCustomNumber2;
        this.mCustomNumber3 = instance.mCustomNumber3;
        this.mCustomNumber4 = instance.mCustomNumber4;
        this.mDescription = instance.mDescription;
        this.mDestinationAirport = instance.mDestinationAirport;
        this.mDestinationCity = instance.mDestinationCity;
        this.mFlightId = instance.mFlightId;
        this.mId = instance.mId;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImages = instance.mImages;
        this.mOnewayCurrency = instance.mOnewayCurrency;
        this.mOnewayPrice = instance.mOnewayPrice;
        this.mOriginAirport = instance.mOriginAirport;
        this.mOriginCity = instance.mOriginCity;
        this.mPrice = instance.mPrice;
        this.mProductPriority0 = instance.mProductPriority0;
        this.mProductPriority1 = instance.mProductPriority1;
        this.mProductPriority2 = instance.mProductPriority2;
        this.mProductPriority3 = instance.mProductPriority3;
        this.mProductPriority4 = instance.mProductPriority4;
        this.mSanitizedImages = instance.mSanitizedImages;
        this.mTags = instance.mTags;
        this.mUnitPrice = instance.mUnitPrice;
        this.mUrl = instance.mUrl;
        this.mVisibility = instance.mVisibility;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Flight> getParser() {
        return new APIRequest.ResponseParser<Flight>(){

            @Override
            public APINodeList<Flight> parseResponse(String response, APIContext context, APIRequest<Flight> request, String header) throws APIException.MalformedResponseException {
                return Flight.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumVisibility {
        VALUE_PUBLISHED("PUBLISHED"),
        VALUE_STAGING("STAGING");

        private String value;

        private EnumVisibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<Flight> {
        Flight lastResponse = null;
        public static final String[] PARAMS = new String[]{"currency", "description", "destination_airport", "destination_city", "images", "origin_airport", "origin_city", "price", "url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Flight getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Flight parseResponse(String response, String header) throws APIException {
            return Flight.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Flight execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Flight execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Flight> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Flight> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Flight>(){

                public Flight apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setDestinationAirport(String destinationAirport) {
            this.setParam("destination_airport", destinationAirport);
            return this;
        }

        public APIRequestUpdate setDestinationCity(String destinationCity) {
            this.setParam("destination_city", destinationCity);
            return this;
        }

        public APIRequestUpdate setImages(List<Object> images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setImages(String images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setOriginAirport(String originAirport) {
            this.setParam("origin_airport", originAirport);
            return this;
        }

        public APIRequestUpdate setOriginCity(String originCity) {
            this.setParam("origin_city", originCity);
            return this;
        }

        public APIRequestUpdate setPrice(Long price) {
            this.setParam("price", price);
            return this;
        }

        public APIRequestUpdate setPrice(String price) {
            this.setParam("price", price);
            return this;
        }

        public APIRequestUpdate setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<Flight> {
        Flight lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"applinks", "category_specific_fields", "currency", "custom_label_0", "custom_label_1", "custom_label_2", "custom_label_3", "custom_label_4", "custom_number_0", "custom_number_1", "custom_number_2", "custom_number_3", "custom_number_4", "description", "destination_airport", "destination_city", "flight_id", "id", "image_fetch_status", "images", "oneway_currency", "oneway_price", "origin_airport", "origin_city", "price", "product_priority_0", "product_priority_1", "product_priority_2", "product_priority_3", "product_priority_4", "sanitized_images", "tags", "unit_price", "url", "visibility"};

        @Override
        public Flight getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Flight parseResponse(String response, String header) throws APIException {
            return Flight.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Flight execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Flight execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Flight> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Flight> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Flight>(){

                public Flight apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestCustomLabel0Field() {
            return this.requestCustomLabel0Field(true);
        }

        public APIRequestGet requestCustomLabel0Field(boolean value) {
            this.requestField("custom_label_0", value);
            return this;
        }

        public APIRequestGet requestCustomLabel1Field() {
            return this.requestCustomLabel1Field(true);
        }

        public APIRequestGet requestCustomLabel1Field(boolean value) {
            this.requestField("custom_label_1", value);
            return this;
        }

        public APIRequestGet requestCustomLabel2Field() {
            return this.requestCustomLabel2Field(true);
        }

        public APIRequestGet requestCustomLabel2Field(boolean value) {
            this.requestField("custom_label_2", value);
            return this;
        }

        public APIRequestGet requestCustomLabel3Field() {
            return this.requestCustomLabel3Field(true);
        }

        public APIRequestGet requestCustomLabel3Field(boolean value) {
            this.requestField("custom_label_3", value);
            return this;
        }

        public APIRequestGet requestCustomLabel4Field() {
            return this.requestCustomLabel4Field(true);
        }

        public APIRequestGet requestCustomLabel4Field(boolean value) {
            this.requestField("custom_label_4", value);
            return this;
        }

        public APIRequestGet requestCustomNumber0Field() {
            return this.requestCustomNumber0Field(true);
        }

        public APIRequestGet requestCustomNumber0Field(boolean value) {
            this.requestField("custom_number_0", value);
            return this;
        }

        public APIRequestGet requestCustomNumber1Field() {
            return this.requestCustomNumber1Field(true);
        }

        public APIRequestGet requestCustomNumber1Field(boolean value) {
            this.requestField("custom_number_1", value);
            return this;
        }

        public APIRequestGet requestCustomNumber2Field() {
            return this.requestCustomNumber2Field(true);
        }

        public APIRequestGet requestCustomNumber2Field(boolean value) {
            this.requestField("custom_number_2", value);
            return this;
        }

        public APIRequestGet requestCustomNumber3Field() {
            return this.requestCustomNumber3Field(true);
        }

        public APIRequestGet requestCustomNumber3Field(boolean value) {
            this.requestField("custom_number_3", value);
            return this;
        }

        public APIRequestGet requestCustomNumber4Field() {
            return this.requestCustomNumber4Field(true);
        }

        public APIRequestGet requestCustomNumber4Field(boolean value) {
            this.requestField("custom_number_4", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDestinationAirportField() {
            return this.requestDestinationAirportField(true);
        }

        public APIRequestGet requestDestinationAirportField(boolean value) {
            this.requestField("destination_airport", value);
            return this;
        }

        public APIRequestGet requestDestinationCityField() {
            return this.requestDestinationCityField(true);
        }

        public APIRequestGet requestDestinationCityField(boolean value) {
            this.requestField("destination_city", value);
            return this;
        }

        public APIRequestGet requestFlightIdField() {
            return this.requestFlightIdField(true);
        }

        public APIRequestGet requestFlightIdField(boolean value) {
            this.requestField("flight_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestOnewayCurrencyField() {
            return this.requestOnewayCurrencyField(true);
        }

        public APIRequestGet requestOnewayCurrencyField(boolean value) {
            this.requestField("oneway_currency", value);
            return this;
        }

        public APIRequestGet requestOnewayPriceField() {
            return this.requestOnewayPriceField(true);
        }

        public APIRequestGet requestOnewayPriceField(boolean value) {
            this.requestField("oneway_price", value);
            return this;
        }

        public APIRequestGet requestOriginAirportField() {
            return this.requestOriginAirportField(true);
        }

        public APIRequestGet requestOriginAirportField(boolean value) {
            this.requestField("origin_airport", value);
            return this;
        }

        public APIRequestGet requestOriginCityField() {
            return this.requestOriginCityField(true);
        }

        public APIRequestGet requestOriginCityField(boolean value) {
            this.requestField("origin_city", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestProductPriority0Field() {
            return this.requestProductPriority0Field(true);
        }

        public APIRequestGet requestProductPriority0Field(boolean value) {
            this.requestField("product_priority_0", value);
            return this;
        }

        public APIRequestGet requestProductPriority1Field() {
            return this.requestProductPriority1Field(true);
        }

        public APIRequestGet requestProductPriority1Field(boolean value) {
            this.requestField("product_priority_1", value);
            return this;
        }

        public APIRequestGet requestProductPriority2Field() {
            return this.requestProductPriority2Field(true);
        }

        public APIRequestGet requestProductPriority2Field(boolean value) {
            this.requestField("product_priority_2", value);
            return this;
        }

        public APIRequestGet requestProductPriority3Field() {
            return this.requestProductPriority3Field(true);
        }

        public APIRequestGet requestProductPriority3Field(boolean value) {
            this.requestField("product_priority_3", value);
            return this;
        }

        public APIRequestGet requestProductPriority4Field() {
            return this.requestProductPriority4Field(true);
        }

        public APIRequestGet requestProductPriority4Field(boolean value) {
            this.requestField("product_priority_4", value);
            return this;
        }

        public APIRequestGet requestSanitizedImagesField() {
            return this.requestSanitizedImagesField(true);
        }

        public APIRequestGet requestSanitizedImagesField(boolean value) {
            this.requestField("sanitized_images", value);
            return this;
        }

        public APIRequestGet requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGet requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGet requestUnitPriceField() {
            return this.requestUnitPriceField(true);
        }

        public APIRequestGet requestUnitPriceField(boolean value) {
            this.requestField("unit_price", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestVisibilityField() {
            return this.requestVisibilityField(true);
        }

        public APIRequestGet requestVisibilityField(boolean value) {
            this.requestField("visibility", value);
            return this;
        }
    }

    public static class APIRequestGetVideosMetadata
    extends APIRequest<DynamicVideoMetadata> {
        APINodeList<DynamicVideoMetadata> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "tags", "url", "video"};

        @Override
        public APINodeList<DynamicVideoMetadata> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<DynamicVideoMetadata> parseResponse(String response, String header) throws APIException {
            return DynamicVideoMetadata.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<DynamicVideoMetadata> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<DynamicVideoMetadata> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<DynamicVideoMetadata>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<DynamicVideoMetadata>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<DynamicVideoMetadata>>(){

                public APINodeList<DynamicVideoMetadata> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetVideosMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/videos_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideosMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideosMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideosMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetVideosMetadata requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetVideosMetadata requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetVideosMetadata requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGetVideosMetadata requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGetVideosMetadata requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetVideosMetadata requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetVideosMetadata requestVideoField() {
            return this.requestVideoField(true);
        }

        public APIRequestGetVideosMetadata requestVideoField(boolean value) {
            this.requestField("video", value);
            return this;
        }
    }

    public static class APIRequestGetOverrideDetails
    extends APIRequest<OverrideDetails> {
        APINodeList<OverrideDetails> lastResponse = null;
        public static final String[] PARAMS = new String[]{"keys", "type"};
        public static final String[] FIELDS = new String[]{"key", "type", "values"};

        @Override
        public APINodeList<OverrideDetails> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OverrideDetails> parseResponse(String response, String header) throws APIException {
            return OverrideDetails.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<OverrideDetails> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OverrideDetails> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OverrideDetails>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OverrideDetails>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<OverrideDetails>>(){

                public APINodeList<OverrideDetails> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetOverrideDetails(String nodeId, APIContext context) {
            super(context, nodeId, "/override_details", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOverrideDetails setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOverrideDetails setKeys(List<String> keys) {
            this.setParam("keys", keys);
            return this;
        }

        public APIRequestGetOverrideDetails setKeys(String keys) {
            this.setParam("keys", keys);
            return this;
        }

        public APIRequestGetOverrideDetails setType(OverrideDetails.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetOverrideDetails setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetOverrideDetails requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOverrideDetails requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOverrideDetails requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOverrideDetails requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetOverrideDetails requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetOverrideDetails requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetOverrideDetails requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetOverrideDetails requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetOverrideDetails requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }

    public static class APIRequestGetChannelsToIntegrityStatus
    extends APIRequest<CatalogItemChannelsToIntegrityStatus> {
        APINodeList<CatalogItemChannelsToIntegrityStatus> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"channels", "rejection_information"};

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> parseResponse(String response, String header) throws APIException {
            return CatalogItemChannelsToIntegrityStatus.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CatalogItemChannelsToIntegrityStatus>>(){

                public APINodeList<CatalogItemChannelsToIntegrityStatus> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetChannelsToIntegrityStatus(String nodeId, APIContext context) {
            super(context, nodeId, "/channels_to_integrity_status", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetChannelsToIntegrityStatus setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField() {
            return this.requestChannelsField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField(boolean value) {
            this.requestField("channels", value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField() {
            return this.requestRejectionInformationField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField(boolean value) {
            this.requestField("rejection_information", value);
            return this;
        }
    }
}

