/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class KeywordDeliveryReport
extends APINode {
    @SerializedName(value="estimated_clicks")
    private Long mEstimatedClicks = null;
    @SerializedName(value="estimated_conversions")
    private Long mEstimatedConversions = null;
    @SerializedName(value="estimated_cost")
    private Double mEstimatedCost = null;
    @SerializedName(value="estimated_cpc")
    private Double mEstimatedCpc = null;
    @SerializedName(value="estimated_ctr")
    private Double mEstimatedCtr = null;
    @SerializedName(value="estimated_cvr")
    private Double mEstimatedCvr = null;
    @SerializedName(value="estimated_impressions")
    private Long mEstimatedImpressions = null;
    @SerializedName(value="estimated_returns")
    private Double mEstimatedReturns = null;
    @SerializedName(value="keyword")
    private String mKeyword = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static KeywordDeliveryReport loadJSON(String json, APIContext context, String header) {
        KeywordDeliveryReport keywordDeliveryReport = (KeywordDeliveryReport)KeywordDeliveryReport.getGson().fromJson(json, KeywordDeliveryReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(keywordDeliveryReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        keywordDeliveryReport.context = context;
        keywordDeliveryReport.rawValue = json;
        keywordDeliveryReport.header = header;
        return keywordDeliveryReport;
    }

    public static APINodeList<KeywordDeliveryReport> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<KeywordDeliveryReport> keywordDeliveryReports = new APINodeList<KeywordDeliveryReport>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        keywordDeliveryReports.add(KeywordDeliveryReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return keywordDeliveryReports;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            keywordDeliveryReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        keywordDeliveryReports.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            keywordDeliveryReports.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            keywordDeliveryReports.add(KeywordDeliveryReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                keywordDeliveryReports.add(KeywordDeliveryReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            keywordDeliveryReports.add(KeywordDeliveryReport.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return keywordDeliveryReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        keywordDeliveryReports.add(KeywordDeliveryReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return keywordDeliveryReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        keywordDeliveryReports.add(KeywordDeliveryReport.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return keywordDeliveryReports;
                }
                keywordDeliveryReports.clear();
                keywordDeliveryReports.add(KeywordDeliveryReport.loadJSON(json, context, header));
                return keywordDeliveryReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return KeywordDeliveryReport.getGson().toJson((Object)this);
    }

    public Long getFieldEstimatedClicks() {
        return this.mEstimatedClicks;
    }

    public KeywordDeliveryReport setFieldEstimatedClicks(Long value) {
        this.mEstimatedClicks = value;
        return this;
    }

    public Long getFieldEstimatedConversions() {
        return this.mEstimatedConversions;
    }

    public KeywordDeliveryReport setFieldEstimatedConversions(Long value) {
        this.mEstimatedConversions = value;
        return this;
    }

    public Double getFieldEstimatedCost() {
        return this.mEstimatedCost;
    }

    public KeywordDeliveryReport setFieldEstimatedCost(Double value) {
        this.mEstimatedCost = value;
        return this;
    }

    public Double getFieldEstimatedCpc() {
        return this.mEstimatedCpc;
    }

    public KeywordDeliveryReport setFieldEstimatedCpc(Double value) {
        this.mEstimatedCpc = value;
        return this;
    }

    public Double getFieldEstimatedCtr() {
        return this.mEstimatedCtr;
    }

    public KeywordDeliveryReport setFieldEstimatedCtr(Double value) {
        this.mEstimatedCtr = value;
        return this;
    }

    public Double getFieldEstimatedCvr() {
        return this.mEstimatedCvr;
    }

    public KeywordDeliveryReport setFieldEstimatedCvr(Double value) {
        this.mEstimatedCvr = value;
        return this;
    }

    public Long getFieldEstimatedImpressions() {
        return this.mEstimatedImpressions;
    }

    public KeywordDeliveryReport setFieldEstimatedImpressions(Long value) {
        this.mEstimatedImpressions = value;
        return this;
    }

    public Double getFieldEstimatedReturns() {
        return this.mEstimatedReturns;
    }

    public KeywordDeliveryReport setFieldEstimatedReturns(Double value) {
        this.mEstimatedReturns = value;
        return this;
    }

    public String getFieldKeyword() {
        return this.mKeyword;
    }

    public KeywordDeliveryReport setFieldKeyword(String value) {
        this.mKeyword = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public KeywordDeliveryReport copyFrom(KeywordDeliveryReport instance) {
        this.mEstimatedClicks = instance.mEstimatedClicks;
        this.mEstimatedConversions = instance.mEstimatedConversions;
        this.mEstimatedCost = instance.mEstimatedCost;
        this.mEstimatedCpc = instance.mEstimatedCpc;
        this.mEstimatedCtr = instance.mEstimatedCtr;
        this.mEstimatedCvr = instance.mEstimatedCvr;
        this.mEstimatedImpressions = instance.mEstimatedImpressions;
        this.mEstimatedReturns = instance.mEstimatedReturns;
        this.mKeyword = instance.mKeyword;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<KeywordDeliveryReport> getParser() {
        return new APIRequest.ResponseParser<KeywordDeliveryReport>(){

            @Override
            public APINodeList<KeywordDeliveryReport> parseResponse(String response, APIContext context, APIRequest<KeywordDeliveryReport> request, String header) throws APIException.MalformedResponseException {
                return KeywordDeliveryReport.parseResponse(response, context, request, header);
            }
        };
    }
}

