/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.utils;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;

public class VideoUtils {
    private static String READY = "ready";
    private static String PROCESSING = "processing";
    private static String ERROR = "error";
    public static int defaultWaitForEncodingCheckInterval = 10;
    public static int defaultWaitForEncodingCheckTries = 20;
    public static int defaultChunkUploadRetries = 5;

    public static String uploadSmallVideoFile(AdAccount account, File videoFile) throws APIException {
        return VideoUtils.uploadSmallVideoFile(account, videoFile, true, null);
    }

    public static String uploadSmallVideoFile(AdAccount account, File videoFile, boolean waitForEncoding, ProgressCallback callback) throws APIException {
        String videoId = account.createAdVideo().addUploadFile("videoFile", videoFile).execute().getId();
        if (callback != null) {
            callback.onProgressUpdate(1, 100);
        }
        if (waitForEncoding && !VideoUtils.waitForVideoEncoding(videoId, account.getContext(), callback)) {
            throw new APIException("Video encoding failed. videoId=" + videoId);
        }
        return videoId;
    }

    public static String uploadVideoFileInChunks(AdAccount account, File videoFile) throws APIException, IOException {
        return VideoUtils.uploadVideoFileInChunks(account, videoFile, defaultChunkUploadRetries, true, null);
    }

    /*
     * Exception decompiling
     */
    public static String uploadVideoFileInChunks(AdAccount account, File videoFile, int maxRetry, boolean waitForEncoding, ProgressCallback callback) throws APIException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean waitForVideoEncoding(String videoId, APIContext context, ProgressCallback callback) throws APIException {
        return VideoUtils.waitForVideoEncoding(videoId, context, defaultWaitForEncodingCheckInterval, defaultWaitForEncodingCheckTries, callback);
    }

    public static boolean waitForVideoEncoding(String videoId, APIContext context, int checkIntervalInSec, int retries, ProgressCallback callback) throws APIException {
        for (int retry = 0; retry < retries; ++retry) {
            String status = VideoUtils.getVideoStatus(videoId, context, callback);
            if (status.equals(READY)) {
                return true;
            }
            if (status.equals(ERROR)) {
                return false;
            }
            try {
                Thread.sleep(checkIntervalInSec * 1000);
                continue;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return false;
    }

    public static String getVideoStatus(String videoId, APIContext context, ProgressCallback callback) throws APIException {
        JsonObject response = new APIRequest(context, videoId, "/", "GET").requestField("status").execute().getRawResponseAsJsonObject();
        String status = response.get("status").getAsJsonObject().get("video_status").getAsString();
        int progress = 0;
        if (response.get("status").getAsJsonObject().has("processing_progress")) {
            progress = response.get("status").getAsJsonObject().get("processing_progress").getAsInt();
        }
        if (callback != null) {
            if (status.equals(PROCESSING)) {
                callback.onProgressUpdate(2, progress);
            } else if (status.equals(READY)) {
                callback.onProgressUpdate(3, 100);
            }
        }
        return status;
    }

    public static interface ProgressCallback {
        public static final int EVENT_UPLOAD_PROGRESS = 0;
        public static final int EVENT_UPLOAD_COMPLETE = 1;
        public static final int EVENT_SERVER_ENCODING_PROGRESS = 2;
        public static final int EVENT_SERVER_ENCODING_COMPLETE = 3;

        public void onProgressUpdate(int var1, int var2);
    }
}

