/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

public class ResponseStatusExceptionHandler
implements WebExceptionHandler {
    private static final Log logger = LogFactory.getLog(ResponseStatusExceptionHandler.class);
    @Nullable
    private Log warnLogger;

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = LogFactory.getLog(loggerName);
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange2, Throwable ex) {
        HttpStatus status = this.resolveStatus(ex);
        if (status == null || !exchange2.getResponse().setStatusCode(status)) {
            return Mono.error((Throwable)ex);
        }
        String logPrefix = exchange2.getLogPrefix();
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn(logPrefix + this.formatError(ex, exchange2.getRequest()), ex);
        } else if (logger.isDebugEnabled()) {
            logger.debug(logPrefix + this.formatError(ex, exchange2.getRequest()));
        }
        return exchange2.getResponse().setComplete();
    }

    private String formatError(Throwable ex, ServerHttpRequest request) {
        String reason = ex.getClass().getSimpleName() + ": " + ex.getMessage();
        String path = request.getURI().getRawPath();
        return "Resolved [" + reason + "] for HTTP " + (Object)((Object)request.getMethod()) + " " + path;
    }

    @Nullable
    private HttpStatus resolveStatus(Throwable ex) {
        Throwable cause;
        HttpStatus status = this.determineStatus(ex);
        if (status == null && (cause = ex.getCause()) != null) {
            status = this.resolveStatus(cause);
        }
        return status;
    }

    @Nullable
    protected HttpStatus determineStatus(Throwable ex) {
        if (ex instanceof ResponseStatusException) {
            return ((ResponseStatusException)ex).getStatus();
        }
        return null;
    }
}

