/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.everit.json.schema.loader.SpecificationVersion;
import org.json.JSONArray;
import org.json.JSONObject;

class JsonValue {
    private static final Function<?, ?> IDENTITY = e -> e;
    private final Object obj;
    protected LoadingState ls;

    static final <T, R> Function<T, R> identity() {
        return IDENTITY;
    }

    static JsonValue of(Object obj) {
        if (obj instanceof JsonValue) {
            return (JsonValue)obj;
        }
        if (obj instanceof Map) {
            return new JsonObject((Map)obj);
        }
        if (obj instanceof List) {
            return new JsonArray((List)obj);
        }
        if (obj instanceof JSONObject) {
            return new JsonObject(OrgJsonUtil.toMap((JSONObject)obj));
        }
        if (obj instanceof JSONArray) {
            return new JsonArray(OrgJsonUtil.toList((JSONArray)obj));
        }
        return new JsonValue(obj);
    }

    protected Object value() {
        return this.obj;
    }

    protected Object unwrap() {
        return this.value();
    }

    protected JsonValue(Object obj) {
        this.obj = obj;
    }

    public <T> VoidMultiplexer canBe(Class<T> expectedType, Consumer<T> consumer) {
        return new VoidMultiplexer(expectedType, consumer);
    }

    public VoidMultiplexer canBeSchema(Consumer<JsonValue> consumer) {
        if (SpecificationVersion.DRAFT_4.equals((Object)this.ls.specVersion())) {
            return new VoidMultiplexer(JsonObject.class, consumer);
        }
        return new VoidMultiplexerWithSchemaPredicate(consumer);
    }

    public <T, R> Multiplexer<R> canBeMappedTo(Class<T> expectedType, Function<T, R> mapper) {
        return new Multiplexer<R>(expectedType, mapper);
    }

    protected Class<?> typeOfValue() {
        return this.obj == null ? null : this.obj.getClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonValue that = (JsonValue)o;
        return Objects.equals(this.obj, that.obj);
    }

    public int hashCode() {
        return this.obj != null ? this.obj.hashCode() : 0;
    }

    public String toString() {
        return "JsonValue{obj=" + this.obj + '}';
    }

    public String requireString() {
        return (String)this.requireString(JsonValue.identity());
    }

    public <R> R requireString(Function<String, R> mapper) {
        if (this.obj instanceof String) {
            return mapper.apply((String)this.obj);
        }
        throw this.ls.createSchemaException(this.typeOfValue(), String.class, new Class[0]);
    }

    public Boolean requireBoolean() {
        return (Boolean)this.requireBoolean(JsonValue.identity());
    }

    public <R> R requireBoolean(Function<Boolean, R> mapper) {
        if (this.obj instanceof Boolean) {
            return mapper.apply((Boolean)this.obj);
        }
        throw this.ls.createSchemaException(this.typeOfValue(), Boolean.class, new Class[0]);
    }

    public JsonObject requireObject() {
        return (JsonObject)this.requireObject(JsonValue.identity());
    }

    public <R> R requireObject(Function<JsonObject, R> mapper) {
        throw this.ls.createSchemaException(this.typeOfValue(), JsonObject.class, new Class[0]);
    }

    public JsonArray requireArray() {
        return (JsonArray)this.requireArray(JsonValue.identity());
    }

    public <R> R requireArray(Function<JsonArray, R> mapper) {
        throw this.ls.createSchemaException(this.typeOfValue(), JsonArray.class, new Class[0]);
    }

    public Number requireNumber() {
        return (Number)this.requireNumber(JsonValue.identity());
    }

    public <R> R requireNumber(Function<Number, R> mapper) {
        if (this.obj instanceof Number) {
            return mapper.apply((Number)this.obj);
        }
        throw this.ls.createSchemaException(this.typeOfValue(), Number.class, new Class[0]);
    }

    public Integer requireInteger() {
        return (Integer)this.requireInteger(JsonValue.identity());
    }

    public <R> R requireInteger(Function<Integer, R> mapper) {
        if (this.obj instanceof Integer) {
            return mapper.apply((Integer)this.obj);
        }
        throw this.ls.createSchemaException(this.typeOfValue(), Integer.class, new Class[0]);
    }

    protected static Object deepToOrgJson(JsonValue v) {
        if (v.unwrap() == null) {
            return JSONObject.NULL;
        }
        if (v instanceof JsonObject) {
            JSONObject obj = new JSONObject();
            ((JsonObject)v).forEach((key, value) -> obj.put(key, JsonValue.deepToOrgJson(value)));
            return obj;
        }
        if (v instanceof JsonArray) {
            JSONArray array = new JSONArray();
            ((JsonArray)v).forEach((index, value) -> array.put(JsonValue.deepToOrgJson(value)));
            return array;
        }
        return v.unwrap();
    }

    private class VoidMultiplexerWithSchemaPredicate
    extends VoidMultiplexer {
        private Consumer<JsonValue> action;

        VoidMultiplexerWithSchemaPredicate(Consumer<JsonValue> action) {
            super(JsonObject.class, action);
            this.action = action;
        }

        @Override
        Void requireAny() {
            if (JsonValue.this.typeOfValue() == Boolean.class) {
                this.action.accept(JsonValue.this);
                return null;
            }
            return (Void)super.requireAny();
        }

        @Override
        protected SchemaException multiplexFailure() {
            HashSet expectedTypes = new HashSet(this.actions.keySet());
            expectedTypes.add(Boolean.class);
            return JsonValue.this.ls.createSchemaException(JsonValue.this.typeOfValue(), expectedTypes);
        }
    }

    class VoidMultiplexer
    extends Multiplexer<Void> {
        VoidMultiplexer(Class<?> expectedType, Consumer<?> consumer) {
            super(expectedType, (? obj) -> {
                consumer.accept(obj);
                return null;
            });
        }

        <T> VoidMultiplexer or(Class<T> expectedType, Consumer<T> consumer) {
            this.actions.put(expectedType, obj -> {
                consumer.accept(obj);
                return null;
            });
            return this;
        }
    }

    class Multiplexer<R> {
        protected Map<Class<?>, Function<?, R>> actions = new HashMap();

        Multiplexer(Class<?> expectedType, Function<?, R> mapper) {
            this.actions.put(expectedType, mapper);
        }

        <T> Multiplexer<R> orMappedTo(Class<T> expectedType, Function<T, R> mapper) {
            this.actions.put(expectedType, mapper);
            return this;
        }

        R requireAny() {
            if (JsonValue.this.typeOfValue() == null) {
                throw this.multiplexFailure();
            }
            Function consumer = this.actions.keySet().stream().filter(clazz -> clazz.isAssignableFrom(JsonValue.this.typeOfValue())).findFirst().map(this.actions::get).orElseThrow(() -> this.multiplexFailure());
            return consumer.apply(JsonValue.this.value());
        }

        protected SchemaException multiplexFailure() {
            return JsonValue.this.ls.createSchemaException(JsonValue.this.typeOfValue(), this.actions.keySet());
        }
    }
}

