/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.common.xml.XPathException;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.common.xml.XmlDocument;
import com.github.tomakehurst.wiremock.common.xml.XmlException;
import com.github.tomakehurst.wiremock.common.xml.XmlNode;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.XPathPatternJsonSerializer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import wiremock.com.fasterxml.jackson.annotation.JsonGetter;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.collect.Sets;

@JsonSerialize(using=XPathPatternJsonSerializer.class)
public class MatchesXPathPattern
extends PathPattern {
    private final Map<String, String> xpathNamespaces;

    public MatchesXPathPattern(String xpath) {
        this(xpath, null, null);
    }

    public MatchesXPathPattern(String xpath, StringValuePattern valuePattern) {
        this(xpath, null, valuePattern);
    }

    public MatchesXPathPattern(String xpath, Map<String, String> namespaces) {
        this(xpath, namespaces, null);
    }

    public MatchesXPathPattern(@JsonProperty(value="matchesXPath") String xpath, @JsonProperty(value="namespaces") Map<String, String> namespaces, @JsonProperty(value="valuePattern") StringValuePattern valuePattern) {
        super(xpath, valuePattern);
        this.xpathNamespaces = namespaces == null || namespaces.isEmpty() ? null : namespaces;
    }

    public MatchesXPathPattern withXPathNamespace(String name, String namespaceUri) {
        ImmutableMap<String, String> namespaceMap = ImmutableMap.builder().putAll(MoreObjects.firstNonNull(this.xpathNamespaces, Collections.emptyMap())).put(name, namespaceUri).build();
        return new MatchesXPathPattern((String)this.expectedValue, namespaceMap);
    }

    public String getMatchesXPath() {
        return (String)this.expectedValue;
    }

    @JsonGetter(value="xPathNamespaces")
    public Map<String, String> getXPathNamespaces() {
        return this.xpathNamespaces;
    }

    @Override
    protected MatchResult isSimpleMatch(String value) {
        ListOrSingle<XmlNode> nodeList = this.findXmlNodes(value);
        return MatchResult.of(nodeList != null && nodeList.size() > 0);
    }

    @Override
    protected MatchResult isAdvancedMatch(String value) {
        ListOrSingle<XmlNode> nodeList = this.findXmlNodes(value);
        if (nodeList == null || nodeList.size() == 0) {
            return MatchResult.noMatch();
        }
        TreeSet<MatchResult> results = Sets.newTreeSet();
        for (XmlNode node : nodeList) {
            results.add(this.valuePattern.match(node.toString()));
        }
        return (MatchResult)results.last();
    }

    @Override
    public String getExpressionResult(String value) {
        ListOrSingle<XmlNode> nodeList = this.findXmlNodes(value);
        if (nodeList == null || nodeList.size() == 0) {
            return null;
        }
        TreeSet<Pair<XmlNode, MatchResult>> results = Sets.newTreeSet(new Comparator<Pair<XmlNode, MatchResult>>(){

            @Override
            public int compare(Pair<XmlNode, MatchResult> one, Pair<XmlNode, MatchResult> two) {
                return ((MatchResult)one.b).compareTo((MatchResult)two.b);
            }
        });
        for (XmlNode node : nodeList) {
            results.add(new Pair<XmlNode, MatchResult>(node, this.valuePattern.match(node.toString())));
        }
        return ((XmlNode)((Pair)results.last()).a).toString();
    }

    private ListOrSingle<XmlNode> findXmlNodes(String value) {
        if (value == null || !value.trim().startsWith("<")) {
            LocalNotifier.notifier().info(String.format("Warning: failed to parse the XML document\nXML: %s", value));
            return null;
        }
        try {
            XmlDocument xmlDocument = Xml.parse(value);
            return xmlDocument.findNodes((String)this.expectedValue, this.xpathNamespaces);
        }
        catch (XmlException e) {
            LocalNotifier.notifier().info(String.format("Warning: failed to parse the XML document. Reason: %s\nXML: %s", e.getMessage(), value));
            return null;
        }
        catch (XPathException e) {
            LocalNotifier.notifier().info("Warning: failed to evaluate the XPath expression " + (String)this.expectedValue);
            return null;
        }
    }
}

