/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import wiremock.org.eclipse.jetty.client.HttpClient;
import wiremock.org.eclipse.jetty.client.HttpRedirector;
import wiremock.org.eclipse.jetty.client.ProtocolHandler;
import wiremock.org.eclipse.jetty.client.api.Request;
import wiremock.org.eclipse.jetty.client.api.Response;
import wiremock.org.eclipse.jetty.client.api.Result;

public class RedirectProtocolHandler
extends Response.Listener.Adapter
implements ProtocolHandler {
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public boolean accept(Request request, Response response) {
        return this.redirector.isRedirect(response) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public void onComplete(Result result) {
        Request request = result.getRequest();
        Response response = result.getResponse();
        if (result.isSucceeded()) {
            this.redirector.redirect(request, response, null);
        } else {
            this.redirector.fail(request, response, result.getFailure());
        }
    }
}

