/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoExtendedFieldMetaData;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.JCoRuntime;

public class DefaultListMetaData
extends AbstractMetaData
implements JCoListMetaData {
    static final long serialVersionUID = 3001520160615L;
    protected byte[] flags = JCoRuntime.EMPTY_BYTE_ARRAY;
    protected String[] defaults = JCoRuntime.EMPTY_STR_ARRAY;
    protected String[] recordFieldNames = JCoRuntime.EMPTY_STR_ARRAY;
    protected char[] abapTypes = JCoRuntime.EMPTY_CHAR_ARRAY;

    DefaultListMetaData(String name) {
        this(name, 0);
    }

    DefaultListMetaData(String name, int capacity) {
        super(name);
        this.ensureCapacity(capacity);
    }

    DefaultListMetaData(JCoListMetaData obj) {
        super(obj.getName());
        this.copy(obj);
    }

    public Object clone() {
        try {
            DefaultListMetaData clone = (DefaultListMetaData)super.clone();
            clone.flags = new byte[this.flags.length];
            System.arraycopy(this.flags, 0, clone.flags, 0, this.flags.length);
            clone.abapTypes = new char[this.abapTypes.length];
            System.arraycopy(this.abapTypes, 0, clone.abapTypes, 0, this.abapTypes.length);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    protected void copy(JCoListMetaData obj) {
        if (obj == null) {
            return;
        }
        super.copy(obj);
        if (obj instanceof DefaultListMetaData) {
            DefaultListMetaData meta = (DefaultListMetaData)obj;
            this.fastCopy(meta);
            System.arraycopy(meta.flags, 0, this.flags, 0, this.numFields);
            if (meta.defaults != null) {
                this.defaults = (String[])meta.defaults.clone();
            }
            if (meta.recordFieldNames != null) {
                this.recordFieldNames = (String[])meta.recordFieldNames.clone();
            }
            System.arraycopy(meta.abapTypes, 0, this.abapTypes, 0, this.numFields);
        } else {
            int n = obj.getFieldCount();
            for (int i = 0; i < n; ++i) {
                int flags = (obj.isOptional(i) ? 1 : 0) | (obj.isChanging(i) ? 8 : 0) | (obj.isExport(i) ? 4 : 0) | (obj.isImport(i) ? 2 : 0);
                this.add(obj.getName(i), obj.getType(i), obj.getByteLength(i), obj.getUnicodeByteLength(i), obj.getDecimals(i), obj.getDefault(i), obj.getDescription(i), flags, obj.getRecordTypeName(i), obj.getRecordFieldName(i), obj.getExtendedFieldMetaData(i));
            }
        }
    }

    public void add(String name, int type, int byteLength, int unicodeByteLength, int flags) {
        this.add(name, type, byteLength, unicodeByteLength, 0, null, null, flags, null, null, null);
    }

    public void add(String name, int type, JCoRecordMetaData recordMetaData, int flags) {
        this.add(name, type, recordMetaData.getRecordLength(), recordMetaData.getUnicodeRecordLength(), 0, null, null, flags, recordMetaData, null, null);
    }

    public void add(String name, int type, int nucByteLength, int ucByteLength, int decimals, String defaultValue, String description, int flags, Object recordMetaData, JCoExtendedFieldMetaData extended) {
        this.add(name, type, nucByteLength, ucByteLength, decimals, defaultValue, description, flags, recordMetaData, null, extended);
    }

    public void add(String name, int type, int nucByteLength, int ucByteLength, int decimals, String defaultValue, String description, int flags, Object recordMetaData, String recordFieldName, JCoExtendedFieldMetaData extended) {
        if ((flags & 0xE) == 0 && type != 98 && type >= 0) {
            super.add(name, 99, nucByteLength, ucByteLength, decimals, description, recordMetaData, extended);
        } else {
            super.add(name, type, nucByteLength, ucByteLength, decimals, description, recordMetaData, extended);
        }
        this.flags[this.numFields - 1] = (byte)flags;
        this.abapTypes[this.numFields - 1] = DefaultListMetaData.getJCOTypeChar(type);
        if (recordFieldName != null) {
            this.recordFieldNames[this.numFields - 1] = recordFieldName;
        }
        if (defaultValue != null || this.defaults.length > 0 && this.defaults.length < this.numFields) {
            String[] old_defaults = this.defaults;
            this.defaults = new String[this.numFields];
            System.arraycopy(old_defaults, 0, this.defaults, 0, old_defaults.length);
        }
        if (defaultValue != null) {
            this.defaults[this.numFields - 1] = defaultValue;
        }
    }

    public void ensureCapacity(int capacity) {
        if (this.name.length >= capacity) {
            return;
        }
        super.ensureCapacity(capacity);
        byte[] oldFlags = this.flags;
        this.flags = new byte[capacity];
        System.arraycopy(oldFlags, 0, this.flags, 0, oldFlags.length);
        String[] oldRecordFieldNames = this.recordFieldNames;
        this.recordFieldNames = new String[capacity];
        System.arraycopy(oldRecordFieldNames, 0, this.recordFieldNames, 0, this.numFields);
        char[] oldAbapTypes = this.abapTypes;
        this.abapTypes = new char[capacity];
        System.arraycopy(oldAbapTypes, 0, this.abapTypes, 0, this.numFields);
    }

    public boolean isException(int index) {
        return this.type[index] == 98;
    }

    public boolean isException(String field_name) {
        return this.type[this.indexOf(field_name)] == 98;
    }

    public boolean isOptional(int index) {
        return (this.flags[index] & 1) != 0;
    }

    public boolean isOptional(String field_name) {
        return (this.flags[this.indexOf(field_name)] & 1) != 0;
    }

    public boolean isImport(int index) {
        return (this.flags[index] & 2) != 0;
    }

    public boolean isImport(String field_name) {
        return (this.flags[this.indexOf(field_name)] & 2) != 0;
    }

    public boolean isChanging(int index) {
        return (this.flags[index] & 8) != 0;
    }

    public boolean isChanging(String fieldName) {
        return (this.flags[this.indexOf(fieldName)] & 8) != 0;
    }

    public boolean isExport(int index) {
        return (this.flags[index] & 4) != 0;
    }

    public boolean isExport(String field_name) {
        return (this.flags[this.indexOf(field_name)] & 4) != 0;
    }

    public char getAbapType(int index) {
        this.checkIndex(index);
        if (index < this.abapTypes.length) {
            return this.abapTypes[index];
        }
        return DefaultListMetaData.getJCOTypeChar(this.type[index]);
    }

    public String getDefault(int index) {
        this.checkIndex(index);
        if (index < this.defaults.length) {
            return this.defaults[index];
        }
        return null;
    }

    public String getDefault(String fieldName) {
        return this.getDefault(this.indexOf(fieldName));
    }

    public String getRecordFieldName(int index) {
        this.checkIndex(index);
        return this.recordFieldNames[index];
    }

    public String getRecordFieldName(String fieldName) {
        return this.getRecordFieldName(this.indexOf(fieldName));
    }

    protected String toString(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numFields; ++i) {
            this.appendBlanks(sb, level * 10);
            String tmp = this.name[i];
            sb.append(tmp);
            this.appendBlanks(sb, 30 - tmp.length());
            sb.append(',');
            if (this.tabMeta[i] instanceof String) {
                tmp = (String)((Object)this.tabMeta[i]);
                sb.append(tmp);
                this.appendBlanks(sb, 30 - tmp.length());
            } else if (this.tabMeta[i] instanceof JCoMetaData) {
                tmp = ((JCoMetaData)this.tabMeta[i]).getName();
                sb.append(tmp);
                this.appendBlanks(sb, 30 - tmp.length());
            } else {
                this.appendBlanks(sb, 30);
            }
            sb.append(',');
            tmp = DefaultListMetaData.getJCOTypeString(this.type[i]);
            sb.append(tmp);
            this.appendBlanks(sb, 11 - tmp.length());
            sb.append(',');
            sb.append(this.abapTypes[i]);
            sb.append(',');
            sb.append(this.blength[i]);
            sb.append(',');
            sb.append(this.boffset[i]);
            sb.append(',');
            sb.append(this.length[0][i]);
            sb.append(',');
            sb.append(this.length[1][i]);
            sb.append(',');
            sb.append(this.decimals[i]);
            if (this.defaults != null && this.defaults.length > i && this.defaults[i] != null) {
                sb.append(',').append(this.defaults[i]);
            }
            if (this.description != null && this.description.length > i && this.description[i] != null) {
                sb.append(',').append(this.description[i]);
            }
            if (this.isImport(i)) {
                sb.append(",IMPORT");
            }
            if (this.isExport(i)) {
                sb.append(",EXPORT");
            }
            if (this.isChanging(i)) {
                sb.append(",CHANGING");
            }
            if (this.isOptional(i)) {
                sb.append(",OPTIONAL");
            }
            if (this.tabMeta[i] != null && this.tabMeta[i] instanceof AbstractMetaData) {
                sb.append('\n');
                continue;
            }
            if (this.tabMeta[i] != null && this.tabMeta[i] instanceof String) {
                sb.append(',').append((String)((Object)this.tabMeta[i]));
                if (this.recordFieldNames[i] != null) {
                    sb.append(',').append(this.recordFieldNames[i]);
                }
                sb.append('\n');
                continue;
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    protected void onLock() {
    }
}

