/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionUnitState;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.RepositoryProvider;
import com.sap.conn.jco.rt.RfcCustomDestination;
import com.sap.conn.jco.rt.RfcDestinationMonitor;
import com.sap.conn.jco.rt.StaticFunctionTemplates;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.I18NConverters;
import com.sap.i18n.cp.ConvertXToC;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Properties;

public class RfcDestination
extends InternalDestination
implements JCoDestination,
Cloneable {
    static final long serialVersionUID = 3001020130730L;
    protected String name;
    private String destinationId = null;
    private String destinationRepositoryId = null;
    protected boolean isInitialized = false;
    protected Properties properties = null;
    protected ConnectionAttributes attributes = null;
    protected transient boolean updateSSOTicket = false;
    protected transient boolean updateX509Certificate = false;
    protected transient BasicRepository repository = null;
    protected int peakLimit;
    protected int capacity;
    protected long maxGetClientTime;
    protected long expirationTime;
    protected long expirationCheckPeriod;
    String scopeType = null;
    RfcDestination parentDestination = null;
    InternalDestination repositoryDestination = null;
    char type = (char)63;
    boolean withCurrentUser = false;
    volatile ArrayList<RfcDestination> scopeList = null;
    private ConfigurationState state = ConfigurationState.VALID;
    private transient RfcDestinationMonitor monitor = null;
    private transient RfcDestinationMonitor repoDestMonitor = null;

    protected RfcDestination(String destName, Properties properties, String propertiesProvider) {
        this.name = destName;
        this.setProperties(properties, propertiesProvider);
        if (Trace.isOn(32)) {
            Trace.fireTrace(32, "[JCoAPI] create destination with: " + this.getProperties().toString());
        }
    }

    protected RfcDestination(String destName, Properties properties, String propertiesProvider, RfcDestination parent) {
        this.name = destName;
        this.setProperties(properties, propertiesProvider);
        if (parent != null) {
            this.parentDestination = parent;
            this.repository = parent.repository;
            this.scopeType = parent.scopeType;
        }
        if (Trace.isOn(32)) {
            Trace.fireTrace(32, "[JCoAPI] create custom destination with: " + this.getProperties().toString());
        }
    }

    final void setProperties(Properties props, String propertiesProvider) {
        this.properties = props;
        this.expirationCheckPeriod = RfcDestination.getLongProperty(props, "jco.destination.expiration_check_period", 60000L);
        this.expirationTime = RfcDestination.getLongProperty(props, "jco.destination.expiration_time", 60000L);
        this.maxGetClientTime = RfcDestination.getLongProperty(props, "jco.destination.max_get_client_time", 30000L);
        this.capacity = RfcDestination.getIntProperty(props, "jco.destination.pool_capacity", Integer.MIN_VALUE);
        this.peakLimit = RfcDestination.getIntProperty(props, "jco.destination.peak_limit", this.capacity);
        if (this.capacity == Integer.MIN_VALUE) {
            this.capacity = 1;
        } else if (this.capacity < 0) {
            this.capacity = 0;
        }
        if (this.peakLimit == Integer.MIN_VALUE || this.peakLimit == 0) {
            this.peakLimit = Integer.MAX_VALUE;
        } else if (this.peakLimit < this.capacity) {
            this.peakLimit = this.capacity;
            if (this.peakLimit == 0) {
                this.peakLimit = Integer.MAX_VALUE;
            }
        }
        this.properties.put("jco.client.destination", this.name);
        this.properties.put("propertiesProvider", propertiesProvider);
        this.evaluateType();
        this.evaluateUserId();
        this.withCurrentUser = "CURRENT_USER".equals(props.get("jco.destination.auth_type"));
    }

    protected void evaluateType() {
        String typeString = JCoRuntime.findProperty("jco.client.type", this.properties);
        if (typeString != null && typeString.length() > 0) {
            this.type = typeString.charAt(0);
            if (this.type == 'E' && this.getTPHost() == null) {
                this.type = (char)82;
            }
            return;
        }
        this.type = this.getMessageServerHost() != null ? (char)66 : (this.getApplicationServerHost() != null ? (char)65 : (this.getTPHost() != null ? (char)69 : (this.getTPName() != null ? (char)82 : (char)51)));
    }

    protected void evaluateUserId() throws JCoRuntimeException {
        String userID = this.properties.getProperty("jco.client.user");
        if (userID == null && (userID = this.properties.getProperty("jco.client.alias_user")) == null) {
            userID = this.properties.getProperty("jco.client.mysapsso2");
            if (userID != null) {
                try {
                    userID = this.getUserIdFromSSOTicket(userID);
                }
                catch (RuntimeException ex) {
                    JCoRuntimeException jex = new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Invalid SSO ticket encountered on " + this.name + " [" + userID + "]", ex);
                    if (Trace.isOn(8)) {
                        Trace.fireTrace(8, "[JCoAPI] " + jex.getMessage(), jex);
                    }
                    throw jex;
                }
            }
            if (userID == null) {
                userID = this.properties.getProperty("jco.client.x509cert");
                if (userID != null) {
                    try {
                        userID = this.getUserIdFromX509Certificate(userID);
                    }
                    catch (CertificateException ex) {
                        JCoRuntimeException jex = new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Invalid X.509 certificate encountered on " + this.name + " [" + userID + "]", ex);
                        if (Trace.isOn(8)) {
                            Trace.fireTrace(8, "[JCoAPI] " + jex.getMessage(), jex);
                        }
                        throw jex;
                    }
                    catch (RuntimeException ex) {
                        JCoRuntimeException jex = new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Invalid X.509 certificate encountered on " + this.name + " [" + userID + "]", ex);
                        if (Trace.isOn(8)) {
                            Trace.fireTrace(8, "[JCoAPI] " + jex.getMessage(), jex);
                        }
                        throw jex;
                    }
                }
                if (userID == null) {
                    String prop = this.properties.getProperty("jco.client.extid_type");
                    if (prop != null && (userID = this.properties.getProperty("jco.client.extid_data")) != null) {
                        userID = userID.length() <= 40 ? new StringBuilder(userID.length() + 3).append(prop).append('=').append(userID).toString() : new StringBuilder(44).append(prop).append("=#").append(Codecs.MD5.getMD5HashAsString(userID)).toString();
                    }
                    if (userID == null) {
                        char destType;
                        prop = this.properties.getProperty("jco.client.snc_mode");
                        if ("1".equals(prop) && !"0".equals(prop = this.properties.getProperty("jco.client.snc_sso"))) {
                            userID = "SNCID";
                        }
                        if (userID == null && ((destType = this.getType()) == 'R' || destType == 'E')) {
                            userID = "EXTERN";
                        }
                    }
                }
            }
        }
        this.setUserId(userID);
        if (userID != null) {
            this.properties.put("jco.destination.userid", userID);
        } else {
            this.properties.remove("jco.destination.userid");
        }
    }

    private String getUserIdFromSSOTicket(String base64encodedTicket) {
        byte[] ticketBytes = Codecs.Base64.decode(base64encodedTicket);
        String cp = null;
        try {
            cp = new String(ticketBytes, 1, 4, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        ConvertXToC conv = I18NConverters.getConvertXToC(cp);
        String userID = null;
        byte id = 0;
        int len = 0;
        for (int off = 5; off < ticketBytes.length; off += len) {
            int idx;
            id = ticketBytes[off++];
            len = (ticketBytes[off++] & 0xFF) << 8 | ticketBytes[off++] & 0xFF;
            if (id != 1) continue;
            char[] buf = conv.ConvertArr(ticketBytes, off, off + len);
            for (idx = buf.length - 1; idx > 0 && buf[idx] == ' '; --idx) {
            }
            userID = new String(buf, 0, idx + 1);
            break;
        }
        if (userID == null || userID.length() == 0) {
            return null;
        }
        return userID;
    }

    private String getUserIdFromX509Certificate(String base64encodedCertificate) throws CertificateException {
        ByteArrayInputStream bais;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(bais = new ByteArrayInputStream(Codecs.Base64.decode(base64encodedCertificate)));
        String userID = certificate.getSubjectX500Principal().getName();
        if (userID == null || userID.length() == 0) {
            return null;
        }
        return userID;
    }

    public RfcDestination clone() {
        try {
            RfcDestination clone = (RfcDestination)super.clone();
            if (clone.parentDestination == null) {
                clone.parentDestination = this;
            }
            clone.scopeList = null;
            clone.state = ConfigurationState.CLONED;
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String getDestinationName() {
        return this.name;
    }

    public char getType() {
        return this.type;
    }

    public String getSAPRouterString() {
        return this.properties.getProperty("jco.client.saprouter");
    }

    public String getApplicationServerHost() {
        return this.properties.getProperty("jco.client.ashost");
    }

    public String getGatewayHost() {
        return this.properties.getProperty("jco.client.gwhost");
    }

    public String getGatewayService() {
        return this.properties.getProperty("jco.client.gwserv");
    }

    public String getSystemNumber() {
        return this.properties.getProperty("jco.client.sysnr");
    }

    public String getLogonGroup() {
        return this.properties.getProperty("jco.client.group");
    }

    public String getMessageServerHost() {
        return this.properties.getProperty("jco.client.mshost");
    }

    public String getMessageServerService() {
        return this.properties.getProperty("jco.client.msserv");
    }

    public String getR3Name() {
        return this.properties.getProperty("jco.client.r3name");
    }

    public String getTPHost() {
        return this.properties.getProperty("jco.client.tphost");
    }

    public String getTPName() {
        return this.properties.getProperty("jco.client.tpname");
    }

    public String getSncLibrary() {
        return this.properties.getProperty("jco.client.snc_lib");
    }

    public String getSncMode() {
        return this.properties.getProperty("jco.client.snc_mode");
    }

    public String getSncMyName() {
        return this.properties.getProperty("jco.client.snc_myname");
    }

    public String getSncPartnerName() {
        return this.properties.getProperty("jco.client.snc_partnername");
    }

    public String getSncQOP() {
        return this.properties.getProperty("jco.client.snc_qop");
    }

    public String getSncSSO() {
        return this.properties.getProperty("jco.client.snc_sso");
    }

    public String getAliasUser() {
        return this.properties.getProperty("jco.client.alias_user");
    }

    public String getClient() {
        return this.properties.getProperty("jco.client.client");
    }

    public String getLanguage() {
        return this.properties.getProperty("jco.client.lang");
    }

    public String getUser() {
        return this.properties.getProperty("jco.client.user");
    }

    public String getAuthType() {
        return this.properties.getProperty("jco.destination.auth_type");
    }

    public String getRepositoryDestinationName() {
        return this.properties.getProperty("jco.destination.repository_destination");
    }

    public String getRepositoryUser() {
        String repUser = this.properties.getProperty("jco.destination.repository.user");
        if (repUser != null) {
            return repUser;
        }
        repUser = this.properties.getProperty("jco.client.user");
        if (repUser != null) {
            return repUser;
        }
        return this.properties.getProperty("jco.client.alias_user");
    }

    public String getLogonCheck() {
        return this.properties.getProperty("jco.client.lcheck");
    }

    String getSSOTicket() {
        return this.properties.getProperty("jco.client.mysapsso2");
    }

    public boolean usesSSOTicket() {
        return this.properties.getProperty("jco.client.mysapsso2") != null;
    }

    String getX509Certificate() {
        return this.properties.getProperty("jco.client.x509cert");
    }

    public boolean usesX509Certificate() {
        return this.properties.getProperty("jco.client.x509cert") != null;
    }

    public String getExternalIDData() {
        return this.properties.getProperty("jco.client.extid_data");
    }

    public String getExternalIDType() {
        return this.properties.getProperty("jco.client.extid_type");
    }

    public long getExpirationCheckPeriod() {
        return this.expirationCheckPeriod;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getMaxGetClientTime() {
        return this.maxGetClientTime;
    }

    public int getPeakLimit() {
        return this.peakLimit;
    }

    public int getPoolCapacity() {
        return this.capacity;
    }

    public ConnectionAttributes getAttributes() throws JCoException {
        if (this.attributes == null) {
            this.initialize();
            if (this.attributes.getPartnerRelease() == null && "0".equals(this.getLogonCheck())) {
                ConnectionAttributes returnAttributes = this.attributes;
                this.isInitialized = false;
                this.attributes = null;
                return returnAttributes;
            }
        }
        return this.attributes;
    }

    private void appendUpper(StringBuilder buffer, String data) {
        int strlen = data.length();
        for (int i = 0; i < strlen; ++i) {
            buffer.append(Character.toUpperCase(data.charAt(i)));
        }
    }

    private String createDestinationID() throws JCoRuntimeException {
        char destType;
        boolean isUserDefined = false;
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.getDestinationName());
        buffer.append('|');
        buffer.append(this.withCurrentUser ? "CURRENT_USER" : "CONFIGURED_USER");
        buffer.append('&');
        String tmp = this.properties.getProperty("jco.client.client");
        if (tmp != null) {
            buffer.append(tmp);
        }
        if ((tmp = this.properties.getProperty("jco.client.user")) != null) {
            buffer.append('|');
            this.appendUpper(buffer, tmp);
            isUserDefined = true;
        }
        buffer.append('|');
        tmp = this.properties.getProperty("jco.client.lang");
        if (tmp != null) {
            this.appendUpper(buffer, tmp);
        }
        if ((tmp = this.properties.getProperty("jco.client.alias_user")) != null) {
            buffer.append('|').append(tmp);
            isUserDefined = true;
        }
        if ((destType = this.getType()) != 'R' && destType != 'E' && (tmp = this.properties.getProperty("jco.client.passwd")) != null) {
            buffer.append('|').append(Codecs.MD5.getMD5HashAsString(tmp));
        }
        if (!isUserDefined) {
            tmp = this.getUserId();
            if (tmp != null) {
                buffer.append('|').append(tmp);
            }
            if (this.properties.containsKey("jco.client.mysapsso2")) {
                buffer.append("|SSO2");
            } else if (this.properties.containsKey("jco.client.x509cert")) {
                buffer.append("|X509");
            } else if (this.properties.containsKey("jco.client.extid_type") && this.properties.containsKey("jco.client.extid_data")) {
                buffer.append("|EXTID");
            }
        }
        if ("1".equals(tmp = this.properties.getProperty("jco.client.snc_mode"))) {
            buffer.append("|SNC");
            tmp = this.properties.getProperty("jco.client.snc_qop");
            if (tmp != null) {
                buffer.append(tmp);
            }
            buffer.append('|');
            tmp = this.properties.getProperty("jco.client.snc_partnername");
            if (tmp != null) {
                buffer.append(tmp);
            }
            if ((tmp = this.properties.getProperty("jco.client.snc_myname")) != null) {
                buffer.append('|').append(tmp);
            }
            if ("0".equals(tmp = this.properties.getProperty("jco.client.snc_sso"))) {
                buffer.append("|WOSSO");
            }
        }
        if ((tmp = this.properties.getProperty("jco.client.codepage")) != null) {
            buffer.append("|CP").append(tmp);
        }
        if ((tmp = this.properties.getProperty("jco.client.pcs")) != null) {
            buffer.append("|PCS").append(tmp);
        }
        if ("0".equals(tmp = this.properties.getProperty("jco.client.delta"))) {
            buffer.append("|DM0");
        }
        if ((tmp = this.properties.getProperty("jco.client.use_sapgui")) != null && !tmp.equals("0")) {
            buffer.append("|GUI").append(tmp);
        }
        if ("1".equals(tmp = this.properties.getProperty("jco.client.abap_debug"))) {
            buffer.append("|DBG");
        }
        if ("1".equals(tmp = this.properties.getProperty("jco.client.trace"))) {
            buffer.append("|TRC");
        }
        if ((tmp = this.properties.getProperty("jco.client.cpic_trace")) != null && !tmp.equals("-1")) {
            buffer.append("|CPIC").append(tmp);
        }
        return buffer.toString();
    }

    private String createDestinationRepositoryID() {
        boolean isUserDefined = false;
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.getDestinationName());
        String repUser = this.properties.getProperty("jco.destination.repository.user");
        buffer.append('|');
        buffer.append(repUser == null && this.withCurrentUser ? "CURRENT_USER" : "CONFIGURED_USER");
        buffer.append('&');
        String tmp = this.properties.getProperty("jco.client.client");
        if (tmp != null) {
            buffer.append(tmp);
        }
        if ((tmp = repUser == null ? this.properties.getProperty("jco.client.user") : repUser) != null) {
            buffer.append('|');
            this.appendUpper(buffer, tmp);
            isUserDefined = true;
        }
        buffer.append('|');
        tmp = this.properties.getProperty("jco.client.lang");
        if (tmp != null) {
            this.appendUpper(buffer, tmp);
        }
        if (repUser == null) {
            tmp = this.properties.getProperty("jco.client.alias_user");
            if (tmp != null) {
                buffer.append('|').append(tmp);
                isUserDefined = true;
            }
            if ((tmp = this.properties.getProperty("jco.client.passwd")) != null) {
                buffer.append('|').append(Codecs.MD5.getMD5HashAsString(tmp));
            }
            if (!isUserDefined) {
                tmp = this.getUserId();
                if (tmp != null) {
                    buffer.append('|').append(tmp);
                }
                if (this.properties.containsKey("jco.client.mysapsso2")) {
                    buffer.append("|SSO2");
                } else if (this.properties.containsKey("jco.client.x509cert")) {
                    buffer.append("|X509");
                } else if (this.properties.containsKey("jco.client.extid_type") && this.properties.containsKey("jco.client.extid_data")) {
                    buffer.append("|EXTID");
                }
            }
        } else {
            tmp = this.properties.getProperty("jco.destination.repository.passwd");
            if (tmp != null) {
                buffer.append('|').append(Codecs.MD5.getMD5HashAsString(tmp));
            }
        }
        if (!"0".equals(tmp = this.properties.getProperty("jco.destination.repository.snc_mode"))) {
            tmp = this.properties.getProperty("jco.client.snc_mode");
        }
        if ("1".equals(tmp)) {
            buffer.append("|SNC");
            tmp = this.properties.getProperty("jco.client.snc_qop");
            if (tmp != null) {
                buffer.append(tmp);
            }
            buffer.append('|');
            tmp = this.properties.getProperty("jco.client.snc_partnername");
            if (tmp != null) {
                buffer.append(tmp);
            }
            if ((tmp = this.properties.getProperty("jco.client.snc_myname")) != null) {
                buffer.append('|').append(tmp);
            }
            if ("0".equals(tmp = this.properties.getProperty("jco.client.snc_sso"))) {
                buffer.append("|WOSSO");
            }
        }
        if ((tmp = this.properties.getProperty("jco.client.codepage")) != null) {
            buffer.append("|CP").append(tmp);
        }
        if ((tmp = this.properties.getProperty("jco.client.pcs")) != null) {
            buffer.append("|PCS").append(tmp);
        }
        if ("0".equals(tmp = this.properties.getProperty("jco.client.delta"))) {
            buffer.append("|DM0");
        }
        if ("1".equals(tmp = this.properties.getProperty("jco.client.trace"))) {
            buffer.append("|TRC");
        }
        if ((tmp = this.properties.getProperty("jco.client.cpic_trace")) != null && !tmp.equals("-1")) {
            buffer.append("|CPIC").append(tmp);
        }
        buffer.append("&REP");
        return buffer.toString();
    }

    public String getDestinationID() {
        if (this.destinationId == null) {
            this.destinationId = this.createDestinationID();
        }
        return this.destinationId;
    }

    String getRepositoryKey() {
        if (this.destinationRepositoryId == null) {
            this.destinationRepositoryId = this.createDestinationRepositoryID();
        }
        return this.destinationRepositoryId;
    }

    String getScopeType() {
        return this.scopeType;
    }

    protected void initialize() throws JCoException {
        String prop;
        if (this.isInitialized) {
            return;
        }
        ClientFactory factory = null;
        try {
            factory = ConnectionManager.getConnectionManager().getFactory(this, false, true);
            this.attributes = factory.getAttributes();
            this.type = JCoRuntime.findProperty("jco.client.type", factory.master.properties).charAt(0);
        }
        catch (JCoException ex) {
            JCoException jex = new JCoException(ex.getGroup(), ex.getKey(), new StringBuilder(150).append("Initialization of destination ").append(this.name).append(" failed: ").append(ex.getMessage()).toString(), ex);
            if (Trace.isOn(8)) {
                Trace.fireTrace(8, jex);
            }
            throw jex;
        }
        if (this.updateSSOTicket) {
            prop = this.properties.getProperty("jco.client.mysapsso2");
            if (prop != null) {
                factory.master.properties.put("jco.client.mysapsso2", prop);
            } else {
                factory.master.properties.remove("jco.client.mysapsso2");
            }
            this.updateSSOTicket = false;
        }
        if (this.updateX509Certificate) {
            prop = this.properties.getProperty("jco.client.x509cert");
            if (prop != null) {
                factory.master.properties.put("jco.client.x509cert", prop);
            } else {
                factory.master.properties.remove("jco.client.x509cert");
            }
            this.updateX509Certificate = false;
        }
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepository() throws JCoException {
        RfcDestination rfcDestination = this;
        synchronized (rfcDestination) {
            if (this.repository == null) {
                boolean assignParentDestinationRepository = false;
                if (this.parentDestination != null && (this.repositoryDestination == null || this.repositoryDestination == this.parentDestination)) {
                    this.repository = this.parentDestination.repository;
                    assignParentDestinationRepository = true;
                }
                if (this.repository == null) {
                    InternalDestination repDestination = this.getRepositoryDestination();
                    if (repDestination != null) {
                        this.repository = JCoRuntimeFactory.getRuntime().getRepositoryManager().getRepository(repDestination);
                        if (assignParentDestinationRepository && this.repository != null) {
                            this.parentDestination.repository = this.repository;
                        }
                    }
                    if (Trace.isOn(32)) {
                        StringBuilder buffer = new StringBuilder(200);
                        buffer.append("[JCoAPI] RfcDestination.getRepository() on destination ").append(this.getDestinationName());
                        if (this.repository != null) {
                            buffer.append(" allocated repository ").append(this.repository.getName());
                        } else {
                            buffer.append(" failed to allocate a repository");
                        }
                        if (repDestination != null && repDestination != this) {
                            buffer.append(" from repository destination ").append(repDestination.getDestinationName());
                        }
                        Trace.fireTrace(32, buffer.toString());
                    }
                }
            }
        }
    }

    String getSystemID() throws JCoException {
        try {
            ClientFactory factory = ConnectionManager.getConnectionManager().getFactory(this, true, true);
            return factory.getAttributes().getSystemID();
        }
        catch (JCoException ex) {
            JCoException jex = new JCoException(ex.getGroup(), ex.getKey(), new StringBuilder(160).append("Initialization of repository destination ").append(this.name).append(" failed: ").append(ex.getMessage()).toString(), ex);
            if (Trace.isOn(8)) {
                Trace.fireTrace(8, jex);
            }
            throw jex;
        }
    }

    public Properties getProperties() {
        Properties clonedP = this.getAllProperties();
        clonedP.remove("jco.client.passwd");
        clonedP.remove("jco.client.mysapsso2");
        clonedP.remove("jco.client.x509cert");
        clonedP.remove("jco.destination.repository.passwd");
        clonedP.remove("passwd");
        return clonedP;
    }

    Properties getAllProperties() {
        return (Properties)this.properties.clone();
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.properties.hashCode();
    }

    public boolean equals(Object destination) {
        if (destination == this) {
            return true;
        }
        if (destination instanceof RfcDestination) {
            RfcDestination rfcDestination = (RfcDestination)destination;
            return this.name.equals(rfcDestination.name) && this.properties.equals(rfcDestination.properties) && this.state.equals((Object)rfcDestination.state);
        }
        return false;
    }

    public BasicRepository getRepository() throws JCoException {
        if (this.repository == null) {
            if (!this.isValid()) {
                throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", this.getStateErrorMessage());
            }
            this.initRepository();
        }
        return this.repository;
    }

    InternalDestination getRepositoryDestination() throws JCoException {
        if (this.repositoryDestination == null) {
            String repDestinationName = this.properties.getProperty("jco.destination.repository_destination");
            if (repDestinationName != null) {
                JCoDestination dest = JCoDestinationManager.getDestination(repDestinationName);
                if (dest != null) {
                    char destType = dest.getType();
                    if (destType == 'R' || destType == 'E') {
                        JCoException jex = new JCoException(101, "JCO_ERROR_CONFIGURATION", new StringBuilder(250).append("Invalid configuration for destination ").append(this.name).append(". Its repository destination ").append(repDestinationName).append(" refers to ").append(destType == 'R' ? "a registered" : "an external").append(" RFC server program but needs to target an SAP AS ABAP system instead.").toString());
                        if (Trace.isOn(8)) {
                            Trace.fireTrace(8, jex);
                        }
                        throw jex;
                    }
                    if (!(dest instanceof InternalDestination)) {
                        throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unsupported class " + dest.getClass().getName() + " encountered when getting destination " + repDestinationName);
                    }
                    this.repositoryDestination = (InternalDestination)dest;
                }
            } else {
                char destType = this.getType();
                if (destType == 'R' || destType == 'E') {
                    JCoException jex = new JCoException(101, "JCO_ERROR_CONFIGURATION", new StringBuilder(240).append("Invalid configuration for destination ").append(this.name).append(". The destination refers to ").append(destType == 'R' ? "a registered" : "an external").append(" RFC server program and is lacking an additional repository destination property for targeting an SAP AS ABAP system.").toString());
                    if (Trace.isOn(8)) {
                        Trace.fireTrace(8, jex);
                    }
                    throw jex;
                }
                this.repositoryDestination = this;
            }
        }
        return this.repositoryDestination;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("destination ");
        result.append(this.name);
        result.append(" with properties: ");
        result.append(this.getProperties().toString());
        return result.toString();
    }

    public RfcCustomDestination createCustomDestination() {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoRuntimeException(136, "Not allowed to invoke createCustomDestination() while being in a PasswordHandler");
        }
        RfcCustomDestination dest = null;
        dest = this.parentDestination == null ? new RfcCustomDestination("custom_" + this.name, this.getAllProperties(), this) : new RfcCustomDestination("custom_" + this.parentDestination.name, this.getAllProperties(), this.parentDestination, this.scopeType);
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmTID(String tid) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke confirmTID() while being in a PasswordHandler");
        }
        if (!this.isInitialized) {
            this.initialize();
        }
        ClientConnection client = null;
        Context ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(this.scopeType);
        try {
            client = ctx.getConnection(this, false);
            client.confirmTID(tid);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ctx.releaseConnection(this, client);
            throw throwable;
        }
        ctx.releaseConnection(this, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTID() throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke createTID() while being in a PasswordHandler");
        }
        if (!this.isInitialized) {
            this.initialize();
        }
        ClientConnection client = null;
        Context ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(this.scopeType);
        String tid = null;
        try {
            client = ctx.getConnection(this, false);
            tid = client.createTID();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ctx.releaseConnection(this, client);
            throw throwable;
        }
        ctx.releaseConnection(this, client);
        return tid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmFunctionUnit(JCoUnitIdentifier unitIdentifier) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke confirmFunctionUnit(), while being in a PasswordHandler");
        }
        if (!this.isInitialized) {
            this.initialize();
        }
        ClientConnection client = null;
        Context ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(this.scopeType);
        try {
            client = ctx.getConnection(this, false);
            client.confirmUnitID(unitIdentifier);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ctx.releaseConnection(this, client);
            throw throwable;
        }
        ctx.releaseConnection(this, client);
    }

    public JCoFunctionUnitState getFunctionUnitState(JCoUnitIdentifier unitIdentifier) throws JCoException {
        AbapFunctionTemplate getStateT = StaticFunctionTemplates.getBGRFC_CHECK_UNIT_STATE_SERVERTemplate();
        AbapFunction getState = getStateT.getFunction();
        getState.getImportParameterList().setValue("UNIT_ID", unitIdentifier.getIDAsBytes());
        int unitKind = 1409196103;
        if (unitIdentifier.getType() == JCoUnitIdentifier.Type.TYPE_T) {
            unitKind = 1409196105;
        }
        getState.getImportParameterList().setValue("UNIT_KIND", unitKind);
        this.execute(getState);
        int srvState = getState.getExportParameterList().getInt("STATE");
        JCoFunctionUnitState unitState = JCoFunctionUnitState.ROLLED_BACK;
        switch (srvState) {
            case 22203: {
                unitState = JCoFunctionUnitState.CONFIRMED;
                break;
            }
            case 22202: {
                unitState = JCoFunctionUnitState.COMMITTED;
                break;
            }
            case 22201: {
                unitState = JCoFunctionUnitState.IN_PROCESS;
                break;
            }
            case 22206: {
                unitState = JCoFunctionUnitState.NOT_FOUND;
                break;
            }
            default: {
                unitState = JCoFunctionUnitState.ROLLED_BACK;
            }
        }
        return unitState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke ping() while being in a PasswordHandler");
        }
        if (!this.isInitialized) {
            this.initialize();
        }
        if (!this.isValid()) {
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", this.getStateErrorMessage());
        }
        ClientConnection client = null;
        Context ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(this.scopeType);
        try {
            client = ctx.getConnection(this, false);
            client.ping();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.releaseConnection(this, client);
            throw throwable;
        }
        ctx.releaseConnection(this, client);
    }

    public boolean isValid() {
        if (this.state != ConfigurationState.VALID) {
            return false;
        }
        if (this.parentDestination != null) {
            this.state = this.parentDestination.state;
            return this.state == ConfigurationState.VALID;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RfcDestination getDestinationForScope(String aScopeType) {
        ArrayList<RfcDestination> localList = this.scopeList;
        if (localList == null) {
            RfcDestination rfcDestination = this;
            synchronized (rfcDestination) {
                localList = this.scopeList;
                if (localList == null) {
                    localList = this.scopeList = new ArrayList();
                }
            }
        }
        RfcDestination destForScope = null;
        RfcDestination dest = null;
        int len = this.scopeList.size();
        for (int i = 0; i < len; ++i) {
            dest = this.scopeList.get(i);
            if (dest == null || !aScopeType.equals(dest.scopeType)) continue;
            destForScope = dest;
            break;
        }
        if (destForScope == null) {
            RfcDestination rfcDestination = this;
            synchronized (rfcDestination) {
                len = this.scopeList.size();
                for (int i = 0; i < len; ++i) {
                    dest = this.scopeList.get(i);
                    if (!aScopeType.equals(dest.scopeType)) continue;
                    destForScope = dest;
                    break;
                }
                if (destForScope == null) {
                    destForScope = this.clone();
                    destForScope.scopeType = aScopeType;
                    destForScope.state = this.state;
                    this.scopeList.add(destForScope);
                }
            }
        }
        return destForScope;
    }

    synchronized void resetRepository() {
        this.repository = null;
        this.repositoryDestination = null;
        if (this.scopeList != null) {
            for (RfcDestination dest : this.scopeList) {
                dest.repository = null;
                dest.repositoryDestination = null;
            }
        }
    }

    void markChanged() {
        this.state = ConfigurationState.CHANGED;
        if (this.monitor != null) {
            this.monitor.markChanged();
        }
        if (this.repoDestMonitor != null) {
            this.repoDestMonitor.markChanged();
        }
    }

    void markDeleted() {
        this.state = ConfigurationState.DELETED;
        if (this.monitor != null) {
            this.monitor.markDeleted();
        }
        if (this.repoDestMonitor != null) {
            this.repoDestMonitor.markDeleted();
        }
    }

    void execute(AbapFunction fct) throws JCoException {
        this.execute(fct, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(AbapFunction fct, String tid, String queueName) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke execute() while being in a PasswordHandler");
        }
        if (!this.isInitialized) {
            this.initialize();
        }
        if (!this.isValid()) {
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", this.getStateErrorMessage());
        }
        Context ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(this.scopeType);
        if (Trace.isOn(64)) {
            StringBuilder buf = new StringBuilder("[JCoAPI] destination ").append(this.name).append(" destinationID=").append(this.getDestinationID()).append(" executes ").append(fct.getName()).append(" sessionID=").append(ctx.sessionID).append(", threadID=0x").append(Long.toHexString(Thread.currentThread().getId()));
            Trace.fireTrace(64, buf.toString());
        }
        ClientConnection conn = null;
        try {
            conn = ctx.getConnection(this, false);
            conn.execute(fct, tid, queueName, (RepositoryProvider)this);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ctx.releaseConnection(this, conn);
            throw throwable;
        }
        ctx.releaseConnection(this, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(AbapFunctionUnit unit) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke execute() while being in a PasswordHandler");
        }
        if (!this.isInitialized) {
            this.initialize();
        }
        if (!this.isValid()) {
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", this.getStateErrorMessage());
        }
        Context ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(this.scopeType);
        ClientConnection conn = null;
        try {
            conn = ctx.getConnection(this, false);
            conn.execute(unit, (RepositoryProvider)this);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ctx.releaseConnection(this, conn);
            throw throwable;
        }
        ctx.releaseConnection(this, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String oldPassword, String newPassword) throws JCoException {
        if (this.isInPasswordChangeHandler()) {
            throw new JCoException(136, "Not allowed to invoke changePassword() while being in a PasswordHandler");
        }
        if (!this.isInitialized) {
            this.initialize();
        }
        if (!this.isValid()) {
            throw new JCoException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", this.getStateErrorMessage());
        }
        Context ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(this.scopeType);
        if (Trace.isOn(64)) {
            StringBuilder buf = new StringBuilder("[JCoAPI] destination ").append(this.name).append(" destinationID=").append(this.getDestinationID()).append(" executes changePassword() sessionID=").append(ctx.sessionID).append(", threadID=0x").append(Long.toHexString(Thread.currentThread().getId()));
            Trace.fireTrace(64, buf.toString());
        }
        ClientConnection conn = null;
        try {
            conn = ctx.getConnection(this, true);
            conn.changeBackendPassword(this.getUser(), oldPassword, newPassword);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ctx.releaseConnection(this, conn);
            throw throwable;
        }
        ctx.releaseConnection(this, conn);
    }

    String getStateErrorMessage() {
        StringBuilder buf = new StringBuilder(128).append("Destination ").append(this.name);
        if (this.parentDestination != null && !this.parentDestination.name.equals(this.name)) {
            buf.append(" is invalid because destination ").append(this.parentDestination.name);
        }
        switch (this.state) {
            case CHANGED: {
                buf.append(" was changed. Refresh the destination instance with the JCoDestinationManager.");
                break;
            }
            case DELETED: {
                buf.append(" was removed. Check the destination configuration.");
                break;
            }
            case CLONED: {
                buf.append(" was cloned. This is not allowed.");
                break;
            }
            case VALID: {
                buf.append(" is illegally still valid. This is an internal error.");
                break;
            }
            default: {
                buf.append(" is invalid. It cannot be used anymore.");
            }
        }
        String errorMessage = buf.toString();
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, "[JCoAPI] " + errorMessage);
        }
        return errorMessage;
    }

    static String getProperty(Properties props, String key, String defaultValue) {
        Object value = props.get(key);
        if (value != null) {
            return value.toString();
        }
        return defaultValue;
    }

    static String getProperty(Properties props, String key) {
        Object value = props.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    static int getIntProperty(Properties props, String key, int defvalue) {
        int result;
        Object value = props.get(key);
        if (value == null) {
            return defvalue;
        }
        try {
            result = Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            result = defvalue;
        }
        return result;
    }

    static long getLongProperty(Properties props, String key, long defvalue) {
        long result;
        Object value = props.get(key);
        if (value != null) {
            try {
                result = Long.parseLong(value.toString());
            }
            catch (Exception e) {
                result = defvalue;
            }
        } else {
            return defvalue;
        }
        return result;
    }

    public JCoDestinationMonitor getMonitor() {
        if (this.monitor == null) {
            ClientFactory factory = null;
            try {
                if (!this.isInitialized) {
                    this.initialize();
                }
                if (!this.isValid()) {
                    throw new JCoRuntimeException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", this.getStateErrorMessage());
                }
                factory = ConnectionManager.getConnectionManager().getFactory(this, false, true);
            }
            catch (JCoException ex) {
                throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", new StringBuilder(80).append("Initialization of destination ").append(this.name).append(" failed.").toString(), ex);
            }
            this.monitor = factory.getDestinationMonitor();
            if (this.monitor == null) {
                this.monitor = new RfcDestinationMonitor(factory);
            }
        }
        return this.monitor;
    }

    public JCoDestinationMonitor getRepositoryDestinationMonitor() {
        if (this.repoDestMonitor == null) {
            if (!this.isValid()) {
                throw new JCoRuntimeException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", this.getStateErrorMessage());
            }
            ClientFactory factory = ConnectionManager.getConnectionManager().getFactoryByDestinationID(this.getRepositoryKey());
            if (factory == null) {
                return null;
            }
            this.repoDestMonitor = factory.getDestinationMonitor();
            if (this.repoDestMonitor == null) {
                this.repoDestMonitor = new RfcDestinationMonitor(factory);
            }
        }
        return this.repoDestMonitor;
    }

    Context getCurrentContext() {
        return JCoRuntimeFactory.getRuntime().getRuntimeContext(this.scopeType);
    }

    Boolean supportsTurboRepository() {
        String isSupported = this.properties.getProperty("jco.destination.repository_roundtrip_optimization");
        if (isSupported == null) {
            return null;
        }
        if (isSupported.equals("1")) {
            return true;
        }
        return false;
    }

    public boolean canUseCachedValues() {
        return this.type != 'B' && this.type != 'b' && (this.type != '3' || this.getMessageServerHost() == null);
    }

    public String getConversationID() {
        Context.DestinationEntry destEntry;
        Context ctx = this.getCurrentContext();
        if (ctx != null && (destEntry = ctx.connToDest.get(this.getDestinationID())) != null && destEntry.conn != null) {
            return destEntry.conn.getConversationID();
        }
        return "00000000";
    }

    public String getInstanceNumber() {
        Context.DestinationEntry destEntry;
        Context ctx = this.getCurrentContext();
        if (ctx != null && (destEntry = ctx.connToDest.get(this.getDestinationID())) != null && destEntry.conn != null) {
            return destEntry.conn.getInstanceNumber();
        }
        return "<unknown>";
    }

    public String getPartnerHost() {
        Context.DestinationEntry destEntry;
        Context ctx = this.getCurrentContext();
        if (ctx != null && (destEntry = ctx.connToDest.get(this.getDestinationID())) != null && destEntry.conn != null) {
            return destEntry.conn.getPartnerHost();
        }
        return "<unknown>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConfigurationState {
        VALID,
        CHANGED,
        DELETED,
        CLONED;

    }
}

