/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.util.JCoTraceWriter;
import com.sap.conn.rfc.engine.Trc;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Trace {
    public static final int NONE = 0;
    public static final int ERROR = 2;
    public static final int WARNING = 4;
    public static final int INFO = 8;
    public static final int INFO2 = 16;
    public static final int INFO3 = 32;
    public static final int PATH = 64;
    public static final int PATH2 = 128;
    public static final int PATH3 = 256;
    static final int DUMMY1 = 512;
    static final int DUMMY2 = 1024;
    public static final int ENFORCE = 0;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static JCoTraceWriter[] writerList = new JCoTraceWriter[0];
    protected static JCoTraceListener[] listenerList = new JCoTraceListener[0];
    private static int envTraceLevel = 0;
    private static int writerCount = 0;
    private static int listenerCount = 0;
    protected static int jcoLogLevel = 0;
    protected static int internalLogLevel = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addTraceWriter(JCoTraceWriter writer) {
        if (writer == null) {
            return;
        }
        if (Trace.indexOf(writer) > -1) {
            return;
        }
        JCoTraceWriter[] jCoTraceWriterArray = writerList;
        synchronized (writerList) {
            if (writerCount == writerList.length) {
                JCoTraceWriter[] newList = new JCoTraceWriter[writerList.length + 1];
                System.arraycopy(writerList, 0, newList, 0, writerList.length);
                writerList = newList;
            }
            Trace.writerList[Trace.writerCount++] = writer;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTracelistener(JCoTraceListener listener) {
        if (listener == null) {
            return;
        }
        JCoTraceListener[] jCoTraceListenerArray = listenerList;
        synchronized (listenerList) {
            if (Trace.indexOf(listener) > -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (listenerCount == listenerList.length) {
                JCoTraceListener[] newList = new JCoTraceListener[listenerList.length + 3];
                System.arraycopy(listenerList, 0, newList, 0, listenerList.length);
                listenerList = newList;
            }
            Trace.listenerList[Trace.listenerCount++] = listener;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeTraceWriter(JCoTraceWriter writer) {
        if (writer == null) {
            return;
        }
        JCoTraceWriter[] jCoTraceWriterArray = writerList;
        synchronized (writerList) {
            int idx = Trace.indexOf(writer);
            if (idx == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (idx < writerCount - 1) {
                System.arraycopy(writerList, idx + 1, writerList, idx, writerCount - 1);
            }
            --writerCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTraceListener(JCoTraceListener listener) {
        if (listener == null) {
            return;
        }
        JCoTraceListener[] jCoTraceListenerArray = listenerList;
        synchronized (listenerList) {
            int idx = Trace.indexOf(listener);
            if (idx == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (idx < listenerCount - 1) {
                System.arraycopy(listenerList, idx + 1, listenerList, idx, listenerCount - idx - 1);
            }
            --listenerCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(JCoTraceListener listener) {
        JCoTraceListener[] jCoTraceListenerArray = listenerList;
        synchronized (listenerList) {
            for (int i = 0; i < listenerCount; ++i) {
                if (listener != listenerList[i]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(JCoTraceWriter writer) {
        JCoTraceWriter[] jCoTraceWriterArray = writerList;
        synchronized (writerList) {
            for (int i = 0; i < writerCount; ++i) {
                if (writer != writerList[i]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return -1;
        }
    }

    public static int getTraceWriterCount() {
        return writerCount;
    }

    public static int getTraceListenerCount() {
        return listenerCount;
    }

    protected static int toExternalTraceLevel(int internalLevel) {
        if (internalLevel == 0) {
            return 0;
        }
        if ((internalLevel & 0x400) != 0) {
            return 10;
        }
        if ((internalLevel & 0x200) != 0) {
            return 9;
        }
        if ((internalLevel & 0x20) != 0) {
            return 8;
        }
        if ((internalLevel & 0x100) != 0) {
            return 7;
        }
        if ((internalLevel & 0x10) != 0) {
            return 6;
        }
        if ((internalLevel & 0x80) != 0) {
            return 5;
        }
        if ((internalLevel & 0x40) != 0) {
            return 4;
        }
        if ((internalLevel & 8) != 0) {
            return 3;
        }
        if ((internalLevel & 4) != 0) {
            return 2;
        }
        if ((internalLevel & 2) != 0) {
            return 1;
        }
        return 0;
    }

    protected static int toInternalTraceLevel(int externalLevel) {
        int logLevel = 0;
        if (externalLevel > 10) {
            externalLevel = 10;
        }
        switch (externalLevel) {
            case 10: {
                logLevel = 2046;
                break;
            }
            case 9: {
                logLevel = 1022;
                break;
            }
            case 8: {
                logLevel = 510;
                break;
            }
            case 7: {
                logLevel = 478;
                break;
            }
            case 6: {
                logLevel = 222;
                break;
            }
            case 5: {
                logLevel = 206;
                break;
            }
            case 4: {
                logLevel = 78;
                break;
            }
            case 3: {
                logLevel = 14;
                break;
            }
            case 2: {
                logLevel = 6;
                break;
            }
            case 1: {
                logLevel = 2;
                break;
            }
            default: {
                logLevel = 0;
            }
        }
        return logLevel;
    }

    protected Trace() {
    }

    public abstract void trace(int var1, String var2);

    static StringBuilder bufferForConnectionProperties(Properties properties) {
        if (properties == null) {
            return new StringBuilder("null");
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append("{ ");
        for (Object key : properties.keySet()) {
            buf.append(key.toString()).append('=');
            if ("jco.client.passwd".equals(key) || "jco.destination.repository.passwd".equals(key) || "passwd".equals(key)) {
                buf.append("<secret>, ");
                continue;
            }
            buf.append(properties.get(key)).append(", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
            buf.append(' ');
        }
        buf.append('}');
        return buf;
    }

    protected static String dumpContent(char[] chars) {
        return Trace.dumpContent(chars, true, chars.length);
    }

    protected static String dumpContent(char[] chars, boolean withHex, int lengthToDump) {
        if (chars == null) {
            chars = new char[]{};
        }
        if (lengthToDump < 0 || lengthToDump > chars.length) {
            lengthToDump = chars.length;
        }
        StringBuilder buf = new StringBuilder((lengthToDump + 19) / 20 * (33 + (withHex ? 84 : 0)));
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        for (int i = 0; i < lengthToDump; i += 20) {
            int k;
            buf.append('|');
            for (k = 0; k < 8; ++k) {
                offsets[k] = i / (int)Math.pow(10.0, k) % 10;
            }
            for (k = 7; k >= 0; --k) {
                buf.append(offsets[k]);
            }
            buf.append('|');
            if (withHex) {
                for (k = 0; k < 20; ++k) {
                    if (i + k < chars.length) {
                        hexs[k * 4 + 0] = HEX[chars[i + k] >> 12 & 0xF];
                        hexs[k * 4 + 1] = HEX[chars[i + k] >> 8 & 0xF];
                        hexs[k * 4 + 2] = HEX[chars[i + k] >> 4 & 0xF];
                        hexs[k * 4 + 3] = HEX[chars[i + k] & 0xF];
                        continue;
                    }
                    hexs[k * 4 + 3] = 32;
                    hexs[k * 4 + 2] = 32;
                    hexs[k * 4 + 1] = 32;
                    hexs[k * 4] = 32;
                }
                for (k = 0; k < hexs.length; ++k) {
                    if (k != 0 && 0 == k % 20) {
                        buf.append(' ');
                    }
                    buf.append(hexs[k]);
                }
                buf.append('|');
            }
            for (k = 0; k < 20; ++k) {
                char curChar = i + k < chars.length ? chars[i + k] : (char)' ';
                buf.append(!Character.isISOControl(curChar) && Character.isDefined(curChar) && (curChar < '\ud800' || curChar >= '\ue000') ? curChar : (char)'.');
            }
            buf.append("|\n");
        }
        return buf.toString();
    }

    protected static String dumpContent(byte[] bytes) {
        return Trace.dumpContent(bytes, bytes.length);
    }

    protected static String dumpContent(byte[] bytes, int lengthToDump) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (lengthToDump < 0 || lengthToDump > bytes.length) {
            lengthToDump = bytes.length;
        }
        StringBuilder buf = new StringBuilder((lengthToDump + 39) / 40 * 96);
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        for (int i = 0; i < lengthToDump; i += 40) {
            int k;
            buf.append('|');
            for (k = 0; k < 8; ++k) {
                offsets[k] = i / (int)Math.pow(10.0, k) % 10;
            }
            for (k = 7; k >= 0; --k) {
                buf.append(offsets[k]);
            }
            buf.append('|');
            for (k = 0; k < 40; ++k) {
                if (i + k < bytes.length) {
                    hexs[k * 2 + 0] = HEX[bytes[i + k] >> 4 & 0xF];
                    hexs[k * 2 + 1] = HEX[bytes[i + k] & 0xF];
                    continue;
                }
                hexs[k * 2 + 1] = 32;
                hexs[k * 2] = 32;
            }
            for (k = 0; k < hexs.length; ++k) {
                if (k != 0 && 0 == k % 20) {
                    buf.append(' ');
                }
                buf.append(hexs[k]);
            }
            buf.append("|\n");
        }
        return buf.toString();
    }

    private static StringBuilder dumpMetadata(List<Object> mdsToDump, List<Object> dumpedMds) {
        StringBuilder buf = new StringBuilder(1000);
        byte itype = 0;
        while (!mdsToDump.isEmpty()) {
            AbstractMetaData md;
            AbstractRecord r;
            Object o = mdsToDump.remove(0);
            if (o instanceof AbstractMetaData) {
                r = null;
                md = (AbstractMetaData)o;
            } else if (o instanceof AbstractRecord) {
                r = (AbstractRecord)o;
                md = r.metaData;
            } else {
                buf.append("warning unexpected class ").append(o.getClass().getName()).append('\n');
                continue;
            }
            String str = md.getName();
            buf.append(str);
            if (md.comment != null && md.comment.length() > 0) {
                for (int c = str.length(); c < 112; ++c) {
                    buf.append(' ');
                }
                buf.append(md.comment);
            }
            buf.append('\n');
            for (int index = 0; index < md.getFieldCount(); ++index) {
                int c;
                buf.append("  ");
                str = md.name[index];
                buf.append(str);
                for (c = str.length(); c < 31; ++c) {
                    buf.append(' ');
                }
                o = md.getRecordTypeName(index);
                str = o != null ? (String)o : "-";
                buf.append(str);
                for (c = str.length(); c < 31; ++c) {
                    buf.append(' ');
                }
                str = md.getTypeAsString(index);
                buf.append(str);
                for (c = str.length(); c < 11; ++c) {
                    buf.append(' ');
                }
                str = String.valueOf(md.boffset[index]);
                for (c = str.length(); c < 5; ++c) {
                    buf.append(' ');
                }
                buf.append(str);
                str = String.valueOf(md.blength[index]);
                for (c = str.length(); c < 6; ++c) {
                    buf.append(' ');
                }
                buf.append(str);
                str = md instanceof JCoRecordMetaData ? String.valueOf(((JCoRecordMetaData)((Object)md)).getByteOffset(index)) : "-";
                for (c = str.length(); c < 6; ++c) {
                    buf.append(' ');
                }
                buf.append(str);
                str = String.valueOf(md.getByteLength(index));
                for (c = str.length(); c < 6; ++c) {
                    buf.append(' ');
                }
                buf.append(str);
                str = md instanceof JCoRecordMetaData ? String.valueOf(((JCoRecordMetaData)((Object)md)).getUnicodeByteOffset(index)) : "-";
                for (c = str.length(); c < 6; ++c) {
                    buf.append(' ');
                }
                buf.append(str);
                str = String.valueOf(md.getUnicodeByteLength(index));
                for (c = str.length(); c < 6; ++c) {
                    buf.append(' ');
                }
                buf.append(str);
                if (md instanceof JCoListMetaData) {
                    buf.append("  ");
                    if (((JCoListMetaData)((Object)md)).isImport(index)) {
                        buf.append('I');
                    }
                    if (((JCoListMetaData)((Object)md)).isChanging(index)) {
                        buf.append('C');
                    }
                    if (((JCoListMetaData)((Object)md)).isExport(index)) {
                        buf.append('E');
                    }
                    if (((JCoListMetaData)((Object)md)).isOptional(index)) {
                        buf.append('O');
                    }
                    if (r != null && r instanceof DefaultParameterList) {
                        if (((DefaultParameterList)r).isActive(index)) {
                            buf.append('A');
                        }
                        if ((((DefaultParameterList)r).flags[index] & 1) != 0) {
                            buf.append('u');
                        }
                        if ((((DefaultParameterList)r).flags[index] & 8) != 0) {
                            buf.append('s');
                        }
                    }
                }
                buf.append('\n');
                itype = md.type[index];
                if (itype != 17 && itype != 99) continue;
                JCoMetaData jmd = md.getRecordMetaData(index);
                if (jmd != null) {
                    if (dumpedMds.contains(jmd) || mdsToDump.contains(jmd)) continue;
                    mdsToDump.add(jmd);
                    continue;
                }
                if (r == null || r.getValue(index) == null || (jmd = ((JCoRecord)r.getValue(index)).getMetaData()) == null || dumpedMds.contains(jmd) || mdsToDump.contains(jmd)) continue;
                mdsToDump.add(jmd);
            }
        }
        return buf;
    }

    protected static StringBuilder dumpMetadata(Object obj, List<Object> dumpedMds) {
        if (obj == null) {
            return new StringBuilder();
        }
        try {
            ArrayList<Object> mdsToDump = new ArrayList<Object>();
            if (dumpedMds == null) {
                dumpedMds = new ArrayList<Object>();
            }
            mdsToDump.add(obj);
            return Trace.dumpMetadata(mdsToDump, dumpedMds);
        }
        catch (Throwable t) {
            return new StringBuilder(64).append("[").append(t.toString()).append(" within the trace]");
        }
    }

    protected static String dumpMetadata(Object obj) {
        if (obj instanceof JCoFunction) {
            JCoFunction f = (JCoFunction)obj;
            ArrayList<Object> dumped = new ArrayList<Object>();
            StringBuilder buffer = new StringBuilder(4000);
            if (f.getImportParameterList() != null) {
                buffer.append((CharSequence)Trace.dumpMetadata(f.getImportParameterList(), dumped));
            }
            if (f.getExportParameterList() != null) {
                buffer.append((CharSequence)Trace.dumpMetadata(f.getExportParameterList(), dumped));
            }
            if (f.getChangingParameterList() != null) {
                buffer.append((CharSequence)Trace.dumpMetadata(f.getChangingParameterList(), dumped));
            }
            if (f.getTableParameterList() != null) {
                buffer.append((CharSequence)Trace.dumpMetadata(f.getTableParameterList(), dumped));
            }
            return buffer.toString();
        }
        return Trace.dumpMetadata(obj, null).toString();
    }

    protected static String dumpRecord(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        StringBuilder buf = new StringBuilder(2000);
        AbstractRecord rec = null;
        AbstractRecord r = null;
        if (obj instanceof AbstractRecord) {
            rec = (AbstractRecord)obj;
            boolean dumpHex = Trace.isOn(256);
            boolean fullDumps = Trace.isOn(32);
            if (rec.metaData.numOdata != rec.metaData.numFields) {
                buf.append("content:\n").append(Trace.dumpContent(rec.data, dumpHex, fullDumps ? rec.data.length : Math.min(1000, rec.data.length)));
            }
            for (int index = 0; index < rec.metaData.numFields; ++index) {
                byte itype = rec.metaData.type[index];
                if (itype != 29 && itype != 30 && itype != 17 && itype != 99) continue;
                Object o = rec.odata[rec.metaData.oindex[index]];
                buf.append(rec.metaData.name[index]).append(": ");
                if (o == null) {
                    buf.append("<null>");
                } else if (itype == 29) {
                    char[] ca = ((String)o).toCharArray();
                    buf.append('\n').append(Trace.dumpContent(ca, dumpHex, fullDumps ? ca.length : Math.min(1000, ca.length)));
                } else if (itype == 30) {
                    byte[] ba = (byte[])o;
                    buf.append('\n').append(Trace.dumpContent(ba, fullDumps ? ba.length : Math.min(1000, ba.length)));
                } else {
                    r = (AbstractRecord)o;
                    boolean isFlat = true;
                    for (int rIdx = 0; rIdx < r.getFieldCount(); ++rIdx) {
                        int rType = r.metaData.getType(rIdx);
                        if (rType != 29 && rType != 30 && rType != 17 && rType != 99) continue;
                        isFlat = false;
                        break;
                    }
                    if (isFlat) {
                        if (itype == 17) {
                            buf.append('\n').append(Trace.dumpContent(r.data, dumpHex, fullDumps ? r.data.length : Math.min(1000, r.data.length)));
                        } else {
                            buf.append(r.numRows).append(" row(s)\n");
                            int rowsToDump = fullDumps ? r.numRows : Math.min(5, r.numRows);
                            for (int row = 0; row < rowsToDump; ++row) {
                                buf.append("row ").append(row).append('\n');
                                buf.append(Trace.dumpContent(r.tableDataRows[row], dumpHex, fullDumps ? r.tableDataRows[row].length : Math.min(1000, r.tableDataRows[row].length)));
                            }
                        }
                    } else {
                        char[] ca = r.toXML().toCharArray();
                        buf.append('\n').append(Trace.dumpContent(ca, dumpHex, fullDumps ? ca.length : Math.min(1000, ca.length)));
                    }
                }
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public static StringBuilder dumpFunction(StringBuilder buf, boolean withMetadata, boolean withInput, boolean withOutput, JCoFunction function) {
        String functionName = function.getName();
        JCoParameterList input = function.getImportParameterList();
        JCoParameterList changing = function.getChangingParameterList();
        JCoParameterList output = function.getExportParameterList();
        JCoParameterList tables = function.getTableParameterList();
        boolean supportsASXML = false;
        JCoFunctionTemplate template = function.getFunctionTemplate();
        if (template != null) {
            supportsASXML = template.supportsASXML();
        } else if (function instanceof AbapFunction) {
            supportsASXML = ((AbapFunction)function).supportsASXML();
        }
        return Trace.dumpFunction(buf, withMetadata, withInput, withOutput, functionName, input, changing, output, tables, tables, supportsASXML);
    }

    public static StringBuilder dumpFunction(StringBuilder buf, boolean withMetadata, boolean withInput, boolean withOutput, String functionName, JCoParameterList input, JCoParameterList changing, JCoParameterList output, JCoParameterList inputTables, JCoParameterList outputTables, boolean supportsASXML) {
        buf.append("\nFunction ").append(functionName).append(" (basXML ").append(supportsASXML ? "" : "not ").append("supported)\n");
        if (withMetadata) {
            ArrayList<Object> dumped = new ArrayList<Object>();
            buf.append((CharSequence)Trace.dumpMetadata(input, dumped));
            buf.append((CharSequence)Trace.dumpMetadata(changing, dumped));
            buf.append((CharSequence)Trace.dumpMetadata(output, dumped));
            buf.append((CharSequence)Trace.dumpMetadata(inputTables, dumped));
            if (outputTables != inputTables) {
                buf.append((CharSequence)Trace.dumpMetadata(outputTables, dumped));
            }
            buf.append('\n');
        }
        if (withInput) {
            buf.append("Input:");
            if (input != null) {
                buf.append('\n').append(Trace.dumpRecord(input));
            } else {
                buf.append(" <null>");
            }
            buf.append('\n');
        }
        if (withOutput) {
            buf.append("Output:");
            if (output != null) {
                buf.append('\n').append(Trace.dumpRecord(output));
            } else {
                buf.append(" <null>");
            }
            buf.append('\n');
        }
        buf.append("Changing:");
        if (changing != null) {
            buf.append('\n').append(Trace.dumpRecord(changing));
        } else {
            buf.append(" <null>");
        }
        buf.append('\n');
        if (withInput) {
            buf.append("Input Tables:");
            if (inputTables != null) {
                buf.append('\n').append(Trace.dumpRecord(inputTables));
            } else {
                buf.append(" <null>");
            }
            buf.append('\n');
        }
        if (withOutput) {
            buf.append("Output Tables:");
            if (outputTables != null) {
                buf.append('\n').append(Trace.dumpRecord(outputTables));
            } else if (inputTables != null) {
                buf.append('\n').append(Trace.dumpRecord(inputTables));
            } else {
                buf.append(" <null>");
            }
            buf.append('\n');
        }
        return buf;
    }

    protected static int setJCoTrace(int level) {
        if (level > 10) {
            level = 10;
        }
        if (level < envTraceLevel) {
            level = envTraceLevel;
        }
        Trace.setLogLevel(Trace.toInternalTraceLevel(level));
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLogLevel(int level) {
        jcoLogLevel = level;
        JCoTraceWriter[] jCoTraceWriterArray = writerList;
        synchronized (writerList) {
            int writersLogLevel = 0;
            for (int i = 0; i < writerCount; ++i) {
                writersLogLevel |= writerList[i].getTraceLevel();
            }
            internalLogLevel = writersLogLevel | jcoLogLevel;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isOn(int level) {
        return (level & internalLogLevel) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean isOn(int level, boolean check) {
        if (check) {
            JCoTraceWriter[] jCoTraceWriterArray = writerList;
            // MONITORENTER : writerList
            int writersLogLevel = 0;
            for (int i = 0; i < writerCount; writersLogLevel |= writerList[i].getTraceLevel(), ++i) {
            }
            internalLogLevel = writersLogLevel | jcoLogLevel;
            // MONITOREXIT : jCoTraceWriterArray
        }
        if ((level & internalLogLevel) == 0) return false;
        return true;
    }

    public static void fireTrace(int level, String text, Throwable causedBy) {
        if (Trace.isOn(level)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.write(text);
            if (causedBy != null) {
                pw.write(10);
                causedBy.printStackTrace(pw);
            }
            pw.flush();
            Trace.fireTrace(level, sw.getBuffer().toString());
        }
    }

    public static void fireTrace(int level, Throwable causedBy) {
        Trace.fireTrace(level, "[JCoAPI] exception occurred:", causedBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void fireTraceCritical(String msg) {
        try {
            if (Trace.isOn(2, true)) {
                JCoTraceWriter[] jCoTraceWriterArray = writerList;
                // MONITORENTER : writerList
                for (int i = 0; i < writerCount; ++i) {
                    try {
                        writerList[i].trace(2, msg);
                        continue;
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : jCoTraceWriterArray
                int standaloneTraceLevel = Trace.toExternalTraceLevel(2);
                JCoTraceListener[] jCoTraceListenerArray = listenerList;
                // MONITORENTER : listenerList
                for (int i = 0; i < listenerCount; ++i) {
                    try {
                        listenerList[i].trace(standaloneTraceLevel, msg);
                        continue;
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : jCoTraceListenerArray
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trc.generalInfo(null, msg);
    }

    public static void fireTraceCritical(String msg, boolean where) {
        try {
            if (where) {
                Throwable t = new Throwable();
                t.fillInStackTrace();
                StackTraceElement[] stackTrace = t.getStackTrace();
                StringBuilder buffer = new StringBuilder(stackTrace.length * 100 + (msg != null ? msg.length() : 4));
                buffer.append(msg).append('\n');
                for (int i = 1; i < stackTrace.length; ++i) {
                    buffer.append("\tinvoked at ").append(stackTrace[i]).append('\n');
                }
                msg = buffer.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trace.fireTraceCritical(msg);
    }

    public static void fireTraceCritical(String msg, Throwable th) {
        try {
            if (th != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                th.printStackTrace(pw);
                pw.close();
                StringBuilder buffer = new StringBuilder((msg != null ? msg.length() : 4) + 1 + sw.getBuffer().length());
                buffer.append(msg).append(' ').append(sw.getBuffer().toString());
                msg = buffer.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trace.fireTraceCritical(msg);
    }

    protected static String levelToString(int level) {
        StringBuilder buf = new StringBuilder(level * 6);
        if ((level & 2) != 0) {
            buf.append(" ERROR");
        }
        if ((level & 4) != 0) {
            buf.append(" WARNING");
        }
        if ((level & 0x40) != 0) {
            buf.append(" PATH");
        }
        if ((level & 0x80) != 0) {
            buf.append(" PATH2");
        }
        if ((level & 0x100) != 0) {
            buf.append(" PATH3");
        }
        if ((level & 8) != 0) {
            buf.append(" INFO");
        }
        if ((level & 0x10) != 0) {
            buf.append(" INFO2");
        }
        if ((level & 0x20) != 0) {
            buf.append(" INFO3");
        }
        return buf.toString();
    }

    public static void fireTrace(int level, String msg) {
        try {
            Trace.fireTrace(level, msg, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fireTrace(int level, String msg, boolean where) {
        if (where) {
            try {
                Throwable t = new Throwable();
                t.fillInStackTrace();
                StackTraceElement[] stackTrace = t.getStackTrace();
                StringBuilder buffer = new StringBuilder(stackTrace.length * 100 + (msg != null ? msg.length() : 4));
                buffer.append(msg).append('\n');
                for (int i = 1; i < stackTrace.length; ++i) {
                    buffer.append("\tinvoked at ").append(stackTrace[i]).append('\n');
                }
                msg = buffer.toString();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if ((level & internalLogLevel) == 0 && level != 0) return;
        JCoTraceWriter[] e = writerList;
        synchronized (writerList) {
            for (int i = 0; i < writerCount; ++i) {
                try {
                    writerList[i].trace(level, msg);
                    continue;
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            // ** MonitorExit[e] (shouldn't be in output)
            int standaloneTraceLevel = Trace.toExternalTraceLevel(level);
            JCoTraceListener[] jCoTraceListenerArray = listenerList;
            synchronized (listenerList) {
                for (int i = 0; i < listenerCount; ++i) {
                    try {
                        listenerList[i].trace(standaloneTraceLevel, msg);
                        continue;
                    }
                    catch (Throwable e3) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var4_8] (shouldn't be in output)
                return;
            }
        }
    }

    protected static String getFilePathToClass(Class<?> cls) {
        String filepath = null;
        try {
            String ptc;
            String rsc = cls.getName().replace('.', '/') + ".class";
            URL url = cls.getClassLoader().getResource(rsc);
            String string = ptc = url != null ? url.getProtocol() : null;
            if ("bundleresource".equals(ptc)) {
                Class<?> classURLResolver;
                try {
                    classURLResolver = cls.getClassLoader().loadClass("org.eclipse.core.runtime.FileLocator");
                }
                catch (Throwable t) {
                    classURLResolver = cls.getClassLoader().loadClass("org.eclipse.core.runtime.Platform");
                }
                Method methodResolve = classURLResolver.getDeclaredMethod("resolve", URL.class);
                url = (URL)methodResolve.invoke(classURLResolver, url);
                ptc = url.getProtocol();
            }
            if ("jar".equals(ptc) || "file".equals(ptc)) {
                filepath = URLDecoder.decode(url.getFile(), "UTF-8");
                if ((filepath = filepath.substring(0, filepath.length() - rsc.length() - ("jar".equals(ptc) ? 2 : 1))).startsWith("jar:")) {
                    filepath = filepath.substring(4);
                }
                if (filepath.startsWith("file:")) {
                    filepath = filepath.substring(5);
                }
                filepath = new File(filepath).getCanonicalPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return filepath;
    }

    protected static void writeInfo(JCoTraceListener tl) {
        if (tl == null) {
            return;
        }
        tl.trace(8, "************************  " + new Date() + "  ************************");
        tl.trace(8, "SAP Java Connector runtime information");
        tl.trace(8, "");
        String os_version = System.getProperty("os.name") + " " + System.getProperty("os.version") + " for " + System.getProperty("os.arch");
        String java_version = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String default_charset = Charset.defaultCharset().name();
        tl.trace(8, "Java Runtime:");
        tl.trace(8, "\tOperating System    : " + os_version);
        tl.trace(8, "\tJava VM             : " + java_version);
        tl.trace(8, "\tDefault charset     : " + default_charset);
        tl.trace(8, "");
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        tl.trace(8, "Versions:");
        tl.trace(8, "\tJCo API             : " + JCoRuntime.getRuntimeVersion());
        tl.trace(8, "\tJCo middleware      : " + rt.getMiddlewarePropertyValue("jco.middleware.name") + " " + rt.getMiddlewarePropertyValue("jco.middleware.version"));
        tl.trace(8, "\tJCo library         : " + rt.getMiddlewarePropertyValue("jco.middleware.native_layer_version"));
        tl.trace(8, "");
        String jar_path = Trace.getFilePathToClass(rt.getClass());
        String lib_path = rt.getMiddlewarePropertyValue("jco.middleware.native_layer_path");
        tl.trace(8, "Library Paths:");
        tl.trace(8, "\tPath to JCo archive : " + (jar_path == null ? "not found" : jar_path));
        tl.trace(8, "\tPath to JCo library : " + (lib_path == null ? "system defined" : lib_path));
        tl.trace(8, "");
        Properties rtProps = JCoRuntime.properties;
        StringBuilder sBuilder = new StringBuilder(80);
        tl.trace(8, "Configuration:");
        for (Object key : rtProps.keySet()) {
            sBuilder.append('\t').append(key).append(" = ").append(rtProps.getProperty((String)key));
            tl.trace(8, sBuilder.toString());
            sBuilder.setLength(0);
        }
        tl.trace(8, "");
        tl.trace(8, "********************************************************************************");
        tl.trace(8, "[JCoAPI] Current JCo trace level is " + rt.getTraceLevel());
    }

    static {
        try {
            envTraceLevel = Integer.parseInt(System.getProperty("jco.trace_level", "0"));
        }
        catch (Exception e) {
            envTraceLevel = 0;
        }
    }
}

