/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.support;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.server.DefaultServerHandlerFactory;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFactory;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import com.sap.conn.jco.support.SimpleDataProviderImpl;
import com.sap.conn.jco.support.Test;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class JRfcServ {
    static void startServer(PrintWriter out, BufferedReader in, String name, SimpleDataProviderImpl ddpi) {
        out.println();
        do {
            if (name == null) {
                List<String> availableServerCfgs = ddpi.getAvailableServerConfigurations();
                if (!availableServerCfgs.isEmpty()) {
                    out.println();
                    out.println("    Available server configurations:");
                    out.print("    ");
                    Iterator<String> availServerCfgIt = availableServerCfgs.iterator();
                    while (availServerCfgIt.hasNext()) {
                        out.print(availServerCfgIt.next());
                        if (!availServerCfgIt.hasNext()) continue;
                        out.print(", ");
                    }
                    out.println();
                }
                if ((name = Test.ask(out, in, "\nEnter server name.......................", "")).length() == 0) {
                    return;
                }
            }
            try {
                JCoServer server = JCoServerFactory.getServer(name);
                MyThrowableListener l = new MyThrowableListener(out);
                DefaultServerHandlerFactory.FunctionHandlerFactory factory = new DefaultServerHandlerFactory.FunctionHandlerFactory();
                factory.registerHandler("STFC_CONNECTION", new StfcConnectionHandler(out));
                factory.registerGenericHandler(new GenericHandler(out));
                server.setCallHandlerFactory(factory);
                server.addServerErrorListener(l);
                server.addServerExceptionListener(l);
                server.addServerStateChangedListener(new MyServerStateChangedListener(out));
                out.println("Start server " + name);
                out.flush();
                server.start();
            }
            catch (Exception e) {
                out.println();
                out.println("           Exception             ");
                e.printStackTrace(out);
                out.println();
                out.flush();
                name = null;
            }
        } while (name == null);
    }

    private static void usage(PrintWriter out) {
        out.println("\nSyntax for start and run in registered mode:");
        out.println("        JRfcServ [options]");
        out.println("");
        out.println("options = -a<program ID>                   e.g. <own host name>.srfcserv");
        out.println("        = -g<SAP gateway host name>        e.g. hs0311");
        out.println("        = -x<SAP gateway service>          e.g. sapgw53");
        out.println("        = -c<connection count>             e.g. 2");
        out.println("        = -t<Level>    RFC/JCo-Trace on    e.g. 5");
        out.println("        = -L<SNC library, optional>");
        out.println("        = -S<SNC myname, optional>");
        out.println("        = -Q<SNC quality of protection, optional>");
        out.println("        = -H<SAP application server>       e.g. hs0311");
        out.println("        = -N<SAP system number>            e.g. 53");
        out.println("        = -C<SAP client>                   e.g. 000");
        out.println("        = -U<SAP user ID>                  e.g. muster");
        out.println("        = -P<SAP password>                 e.g. secret");
        out.println("");
        out.println("Option L, S and Q can be set if working with SNC (Secure Network");
        out.println("Communication). In order to register a server at a gateway use");
        out.println("options a, g and x.");
        out.println("");
        out.flush();
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out, true);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Properties servP = new Properties();
        Properties clientP = new Properties();
        SimpleDataProviderImpl ddpi = new SimpleDataProviderImpl(out, in);
        Environment.registerDestinationDataProvider(ddpi);
        Environment.registerServerDataProvider(ddpi);
        String serverName = null;
        if (args.length == 0) {
            JRfcServ.usage(out);
        } else {
            try {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("-t")) {
                        servP.setProperty("jco.server.trace", "true");
                        int jco_trc_level = Integer.parseInt(args[i].substring(2));
                        JCo.setTrace(jco_trc_level, ".");
                        continue;
                    }
                    if (args[i].startsWith("-a")) {
                        servP.setProperty("jco.server.progid", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-g")) {
                        servP.setProperty("jco.server.gwhost", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-x")) {
                        servP.setProperty("jco.server.gwserv", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-c")) {
                        servP.setProperty("jco.server.connection_count", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-L")) {
                        servP.setProperty("jco.server.snc_lib", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-S")) {
                        servP.setProperty("jco.server.snc_myname", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-Q")) {
                        servP.setProperty("jco.server.snc_qop", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-H")) {
                        clientP.setProperty("jco.client.ashost", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-N")) {
                        clientP.setProperty("jco.client.sysnr", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-C")) {
                        clientP.setProperty("jco.client.client", args[i].substring(2));
                        continue;
                    }
                    if (args[i].startsWith("-U")) {
                        clientP.setProperty("jco.client.user", args[i].substring(2));
                        continue;
                    }
                    if (!args[i].startsWith("-P")) continue;
                    clientP.setProperty("jco.client.passwd", args[i].substring(2));
                }
                if (clientP.size() > 0) {
                    ddpi.setDestinationProperties("%%console_client", clientP);
                    JCoDestination test = JCoDestinationManager.getDestination("%%console_client");
                    test.ping();
                }
                if (servP.size() > 1) {
                    servP.setProperty("jco.server.repository_destination", "%%console_client");
                    ddpi.setServerProperties("%%console_server", servP);
                    serverName = "%%console_server";
                }
            }
            catch (Exception ex) {
                Test.displayException(out, ex);
                JRfcServ.usage(out);
                return;
            }
        }
        out.flush();
        JRfcServ.startServer(out, in, serverName, ddpi);
        ddpi.saveAll();
    }

    static class MyServerStateChangedListener
    implements JCoServerStateChangedListener {
        private PrintWriter out;

        MyServerStateChangedListener(PrintWriter out) {
            this.out = out;
        }

        public void serverStateChangeOccurred(JCoServer server, JCoServerState oldState, JCoServerState newState) {
            this.out.println(">>> state changed on [server: " + server.getProgramID() + "] from " + oldState.toString() + " to " + newState.toString());
            this.out.flush();
        }
    }

    static class MyThrowableListener
    implements JCoServerErrorListener,
    JCoServerExceptionListener {
        private PrintWriter out;

        MyThrowableListener(PrintWriter out) {
            this.out = out;
        }

        public void serverErrorOccurred(JCoServer jcoServer, String connectionId, JCoServerContextInfo ctx, Error error) {
            this.out.println(">>> Error occured on " + jcoServer.getProgramID() + " connection " + connectionId);
            if (ctx != null) {
                this.out.println("Context: " + (ctx.isStatefulSession() ? "session id " + ctx.getSessionID() : "stateless"));
            }
            error.printStackTrace(this.out);
        }

        public void serverExceptionOccurred(JCoServer jcoServer, String connectionId, JCoServerContextInfo ctx, Exception error) {
            this.out.println(">>> Error occured on " + jcoServer.getProgramID() + " connection " + connectionId);
            if (ctx != null) {
                this.out.println("Context: " + (ctx.isStatefulSession() ? "session id " + ctx.getSessionID() : "stateless"));
            }
            error.printStackTrace(this.out);
        }
    }

    static class GenericHandler
    implements JCoServerFunctionHandler {
        private PrintWriter out;

        GenericHandler(PrintWriter out) {
            this.out = out;
        }

        public void handleRequest(JCoServerContext serverCtx, JCoFunction function) {
            this.out.println("----------------------------------------------------------------");
            this.out.println("call              : " + function.getName());
            this.out.println("ConnectionId      : " + serverCtx.getConnectionID());
            this.out.println("SessionId         : " + serverCtx.getSessionID());
            this.out.println("TID               : " + serverCtx.getTID());
            this.out.println("repository name   : " + serverCtx.getRepository().getName());
            this.out.println("is in transaction : " + serverCtx.isInTransaction());
            this.out.println("is stateful       : " + serverCtx.isStatefulSession());
            this.out.println("----------------------------------------------------------------");
            this.out.println("gwhost: " + serverCtx.getServer().getGatewayHost());
            this.out.println("gwserv: " + serverCtx.getServer().getGatewayService());
            this.out.println("progid: " + serverCtx.getServer().getProgramID());
            this.out.println("----------------------------------------------------------------");
            this.out.println("attributes  : ");
            this.out.println(serverCtx.getConnectionAttributes().toString());
            this.out.println("----------------------------------------------------------------");
            this.out.println();
            this.out.println(function.toXML());
            this.out.println();
            this.out.flush();
        }
    }

    static class StfcConnectionHandler
    implements JCoServerFunctionHandler {
        private PrintWriter out;

        StfcConnectionHandler(PrintWriter out) {
            this.out = out;
        }

        public void handleRequest(JCoServerContext serverCtx, JCoFunction function) {
            this.out.println("----------------------------------------------------------------");
            this.out.println("call              : " + function.getName());
            this.out.println("ConnectionId      : " + serverCtx.getConnectionID());
            this.out.println("SessionId         : " + serverCtx.getSessionID());
            this.out.println("TID               : " + serverCtx.getTID());
            this.out.println("repository name   : " + serverCtx.getRepository().getName());
            this.out.println("is in transaction : " + serverCtx.isInTransaction());
            this.out.println("is stateful       : " + serverCtx.isStatefulSession());
            this.out.println("----------------------------------------------------------------");
            this.out.println("gwhost: " + serverCtx.getServer().getGatewayHost());
            this.out.println("gwserv: " + serverCtx.getServer().getGatewayService());
            this.out.println("progid: " + serverCtx.getServer().getProgramID());
            this.out.println("----------------------------------------------------------------");
            this.out.println("attributes  : ");
            this.out.println(serverCtx.getConnectionAttributes().toString());
            this.out.println("----------------------------------------------------------------");
            this.out.println("req text: " + function.getImportParameterList().getString("REQUTEXT"));
            function.getExportParameterList().setValue("ECHOTEXT", function.getImportParameterList().getString("REQUTEXT"));
            function.getExportParameterList().setValue("RESPTEXT", "Hello World");
            this.out.flush();
        }
    }
}

